<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
// require_once(dirname(__FILE__) . "/../../includes/debug.php");

class YardScenario extends API
{
    public function __construct()
    {
        DBConnection::getInstance();
        // call the super constructor
        $this->_request = parent::__construct();
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ------------------- Yard Scenario ---------- //

    // --------------------- get bean for yard Scenario -------------------- //
    // --------------------------------------------------------------------- //
    public function getDefaultYardScenario()
    {
        $sql = "select id,
                        name ,
                        description,
                        CAST(`details` AS CHAR CHARSET UTF8) AS details,
                        status,
                        create_date
                from yard_scenario
                where id = 1";

        $result = DBConnection::runBindDatabaseQuery($sql, []);

        foreach ($result as $bean) {
            $bean->details = json_decode($bean->details);
        }

        parent::response($result[0]);
    }

    // --------------------------------------------------------------------- //
    // --------------------- get bean for yard Scenario -------------------- //
    // --------------------------------------------------------------------- //
    public function getYardScenario()
    {
        $id = $this->_request->id;

        $sql = "select id,
                       name ,
                       description,
                       CAST(`details` AS CHAR CHARSET UTF8) AS details,
                       status,
                       create_date
                from yard_scenario
                where status = 'ACTIVE' and id = ?";

        $param = [$id];
        $result = DBConnection::runBindDatabaseQuery($sql, $param);

        foreach ($result as $bean) {
            $bean->details = json_decode($bean->details);
        }

        parent::response($result[0]);
    }

    // --------------------------------------------------------------------- //
    // --------------------- search list for yard Scenario -------------------- //
    // --------------------------------------------------------------------- //
    public function searchYardsScenario()
    {
        $filter = $this->_request->filter;
        if (gettype($filter) == "string") {
            $filter = json_decode($filter);
        }

        $sql = "select id,
                       name ,
                       description,
                       status,
                       create_date
                from yard_scenario
               
                where status = 'ACTIVE'  ";
        foreach ($filter as $key => $value) {
            $sql .= "and $key = '$value' ";
        }

        $data = DBConnection::runBindDatabaseQuery($sql, []);

        $result = [];
        $result['data'] = $data;
        $result['found_rows'] = sizeof($data);
        parent::response($result);
    }

    // ------------------------------------------------------------------- //
    // --------------------- create new yard Scenario -------------------- //
    // ------------------------------------------------------------------- //
    public function createYardsScenario()
    {
        // get user info
        $name =  $this->_request->name;
        $description =  $this->_request->description;
        $details['input'] = json_decode(json_encode($this->_request->input), true);
        $details['output'] = json_decode(json_encode($this->_request->output), true);

        //validate input
        if (!$name) throw new Exception("name is required");
        if (!$description) throw new Exception("description is required");
        if (!$details) throw new Exception("details is required");

        // validate details is JSON
        if (!$details['output']) {
            throw new Exception("details is not valid JSON");
        }

        // echo $description;
        // die;
        // insert into database
        try {
            $sql = "INSERT INTO `waybill`.`yard_scenario` (`name`, `description`, `details`, `status`) VALUES (?, ?, ?, 'ACTIVE')";
            DBConnection::runBindDatabaseQuery($sql, [$name, $description, json_encode($details)]);
        } catch (\Throwable $th) {
            echo $th;
            die;
        }

        $result = [];
        $result['message'] = "تمت العملية بنجاح";
        parent::response($result);
    }

    // ------------------------------------------------------------------- //
    // --------------------- deactivate yard Scenario -------------------- //
    // ------------------------------------------------------------------- //
    public function changeStatus()
    {

        // get user input
        $id = $this->_request->id;
        $new_status = $this->_request->new_status;

        //validate input
        if (!$id) throw new Exception("id is required");
        if (!$new_status) throw new Exception("new_status is required");
        $new_status = strtoupper($this->_request->new_status);
        if ($new_status != "ACTIVE" && $new_status != "INACTIVE")  throw new Exception("invalid new status");

        // update DB
        $sql = "update yard_scenario set status = ? where id = ?";
        $data = DBConnection::runBindDatabaseQuery($sql, [$new_status, $id]);

        $result = [];
        $result['message'] = "تمت العملية بنجاح";
        parent::response($result);
    }
}

new YardScenario();
