
<?php
ini_set('max_execution_time', 240000); //600 seconds = 10 minutes
ini_set('memory_limit', '-1');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require_once(dirname(__FILE__) . "/includes/util.php");
require_once(dirname(__FILE__) . "/includes/Jormall_sms_gateway.php");
require_once(dirname(__FILE__) . "/includes/debug.php");
require_once(dirname(__FILE__) . "/core/account/account_core.php");
require_once(dirname(__FILE__) . "/core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/Grains.php");
require_once(dirname(__FILE__) . "/core/outgoing_integration/mg_registrar.php");
require_once(dirname(__FILE__) . "/core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/core/tender_claim/tender_claim_core.php");
require_once(dirname(__FILE__) . "/core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/core/company/company_core.php");
require_once(dirname(__FILE__) . "/core/company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/core/company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/core/assign_cargo/assign_cargo_core.php");
require_once(dirname(__FILE__) . "/core/waybill_draft/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/core/truck_routing/truck_routing_core.php");
require_once(dirname(__FILE__) . "/core/pa_route_wage/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/core/fps_claim/fps_claim_core.php");
require_once(dirname(__FILE__) . "/core/fps_voucher/fps_voucher_core.php");
require_once(dirname(__FILE__) . "/core/policy/policy_core.php");
require_once(dirname(__FILE__) . "/core/land_trip/land_trip_core.php");

require_once(dirname(__FILE__) . "/vendor/autoload.php");
require_once(dirname(__FILE__) . "/core/GCPTask/GCPTask_core.php");


$paymentCore = new PaymentCore();
$waybillCore = new WaybillCore();
$waybillOrderCore = new WaybillOrderCore();
$grains = new Grains();
$voucherCore = new VoucherCore();
$zain_cash = new Zain_cash();
$queueCore = new QueueCore();
$tenderClaimCore = new TenderClaimCore();
$tenderCore = new TenderCore();
$truckOwnerCore = new TruckOwnerCore();
$companyEmployeeCore = new CompanyEmployeeCore();
$truckingCompanyCore = new TruckingCompanyCore();
$notificationCore = new NotificationCore();
$userCore = new UserCore();
$cargoCore = new CargoCore();
$socialCore = new SocialCore();
$taskQueuesCore = new TaskQueuesCore();
$accountCore = new AccountCore();
$jo_petrol_integration = new Jo_Petrol();
$pollIntegration = new Poll();
$addNoteCore = new Add_notes_core();
$routeWageCore = new RouteWageCore();
$driverCore = new DriverCore();
$assignCargoCore = new AssignCargoCore();
$customerCare = new CustomerCare();
$waybillDraft = new WaybillDraftCore();
$paymentCore = new PaymentCore();
$registrationCore = new RegistrationCore();
$truckRoutingCore = new TruckRoutingCore();
$paRouteWageCore = new PaRouteWageCore();
$fps = new FPS();
$fps_claim = new Fps_claim_core();
$fps_voucher = new Fps_voucher_core();
$dbrCore = new DBR_Core();
$mg_registrar = new MG_registrar();
$cargoAgentCore = new CargoAgentCore();
$fpsVoucherCore = new Fps_voucher_core();
$policyCore = new Policy_Core();
$fps_claim_core = new Fps_claim_core();
$landtripCore = new LandtripCore();

 
$land_trip_id = 2210190231;
$answers = '[{"value": 0, "question_id": 0}, {"value": "https://storage.googleapis.com/waybill-project.appspot.com/Newsletter%2Faad541a1-3e30-416b-ab78-6d85f0c65ce2.png", "question_id": 1}, {"value": "https://storage.googleapis.com/waybill-project.appspot.com/Newsletter%2Fde2baf3c-8e8e-4956-b84e-8b5414bc3fd9.png", "question_id": 2}, {"value": "تم التسليم", "question_id": 3}, {"value": 0, "question_id": 4}]';
$user_id = 10468;
$landtripCore->createContainerDischargeReport($land_trip_id, $answers, $user_id);

die;


$poll_id = 9623;
$answers = '[{"value": 0, "question_id": 0}, {"value": "https://storage.googleapis.com/waybill-project.appspot.com/Newsletter%2Fe37fd6a4-3953-41b1-9bc9-58b1261aa626.png", "question_id": 1}, {"value": "https://storage.googleapis.com/waybill-project.appspot.com/Newsletter%2Fd67b1c0b-5813-4c3f-bfe4-b6efd7100fe5.png", "question_id": 2}, {"value": "مرحبا", "question_id": 3}, {"value": 0, "question_id": 4}]';
$pollBean = $pollIntegration->getPoll($poll_id);

$callBack = $pollBean['details']['attributes']['callback'];

if ($callBack && $callBack[0]) {
    $callBackMethod = $callBack[0]['data']['method'];
    if ($callBackMethod == "createJoinMgPayTicket") {
        // $answers = is_string($answers) ? json_decode($answers, true) : $answers;
        // $liecence_photo_front = $answers[2]['value'];
        //$tn = $answers[1]['value'];
        // $this->_tenderCore->createJoinMgPayTicket($tn, $liecence_photo_front,//$_SESSION['user_id']);
    }elseif($callBackMethod==='createDischargeReport'){
        $answers = is_string($answers) ? json_decode($answers, true) : $answers;
        $recipients = $pollBean['recipients'];
        $activeRecipients = null;
        foreach ($recipients as $key => $recipient) {
            if ($recipient['status'] == 'ACTIVE') {
                $activeRecipients = $recipient;
            }
        }
 
        $waybill_id = json_decode($activeRecipients['bind_params'])->waybill_id;
 
        if(!$waybill_id){
            throw new Exception("waybill_id is not defined");
        }

        $waybillCore->createDischargeReport($waybill_id,$answers,2);
    }
}

die;



 

// // generate trx
// $trx = [];
// $ledger_account_id = 590000;
// $temp = new stdClass();
// $temp->amount =  112.110;
// $temp->account = "590000-6077364";
// $temp->op = 'D';
// $temp->notes =  "فرق خطأ في احتساب غرامة نقص الحمولة";
// $trx[] = $temp;

// $temp2 = new stdClass();
// $temp2->amount =   112.110;
// $temp2->account = "590000-14008";
// $temp2->op = 'C';
// $temp2->notes =   "فرق خطأ في احتساب غرامة نقص الحمولة";
// $trx[] = $temp2;

// // create the new trx
// $data = new stdClass();
// $data->ledger_account_id = $ledger_account_id;
// $data->jv_date = "2022-06-26 13:00";
// $data->remarks = "فرق خطأ في احتساب غرامة نقص الحمولة";
// $data->trx = $trx;

 
// $fps->createTrx($data,2);

// echo "done";
// die;


//163.705


$waybillBean = $waybillCore->getWaybillBasic(427102, 0);
$discharge_weight = 35000;
$loading_weight = 35000;

$routeWage =  $routeWageCore->searchWageForFreight(
    13,
    '91090000',
    '91100003',
    '2010000006',
    '2022-03-03',
    'payable',
    true,
    $waybillBean,
    2
);

$pa_id = 57;
$frieght = $paymentCore->calculateFreight($waybillBean, $discharge_weight, $loading_weight, $routeWage, null, $pa_id);
dump($frieght);die;



$request = new stdClass();
$request->filter = new stdClass();
$request->filter->status_in = ["ACTIVE"];
$request->filter->payee_reference_value = 430717;
$request->filter->payee_reference_code = "TRUCK_OWNER";
$claimsReuslt = $fps->searchClaims($request, 0);

// search if the truck_owner has any delayed claims, stop it here
foreach ($claimsReuslt['data'] as $claim) {
    $claim_details = json_decode($claim['claim_details']);

    if (isset($claim_details->is_delayed) && $claim_details->is_delayed) {
        throw new Exception("لا تستطيع المتابعة، مالك الشاحنة عليه سلفة متعثرة");
    }
}
echo 1;
die;



// generate trx
$trx = [];
$ledger_account_id = 590000;
$temp = new stdClass();
$temp->amount =  351.599;
$temp->account = "590000-6077378";
$temp->op = 'C';
$temp->notes =  "سداد قيمة السلفة من رحلة المستند رقم 2120154278";
$trx[] = $temp;

$temp2 = new stdClass();
$temp2->amount =  351.599;
$temp2->account = "590000-14008";
$temp2->op = 'D';
$temp2->notes =  "سداد قيمة السلفة من رحلة المستند رقم 2120154278";
$trx[] = $temp2;

// create the new trx
$data = new stdClass();
$data->ledger_account_id = $ledger_account_id;
$data->jv_date = "2022-03-23 11:17:21";
$data->remarks =  "سداد قيمة السلفة من رحلة المستند رقم 2120154278";
$data->trx = $trx;

$fps->createTrx($data, 2);

echo "done";
die;




$MGPAY_tender_id = 23;
$waybillBean = $waybillCore->getWaybillBasic(423976, 0);
$payment_amount = 250;

// search for tender truck record
$tenderTruckFilter = [
    ['key' => 'tender_id', 'val' => $MGPAY_tender_id],
    ['key' => 'tn', 'val' => $waybillBean->document->carrier[0]->truck->tn],
    ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
];
$tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0,  0);

$financial_details = $tenderTruckResult->data[0]->financial_details;
if (!$financial_details) {
    throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
}

if (gettype($financial_details) == "string")
    $financial_details = json_decode($financial_details);

$truck_owner_id = $financial_details->truck_owner->id;

$tender_bean = $tenderCore->getTenderBasic($MGPAY_tender_id, 0);
$account_ledger_id = $tender_bean->manifest->account_ledger_id;
$accountFilter = new stdClass();
$accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $truck_owner_id];
$accountFilter->filter = json_encode($accountFilter->filter);
$owner_account_qry =  $fps->searchAccount($accountFilter, 0);
$generateFpsVoucherTrxData = new stdClass();
$generateFpsVoucherTrxData->net_amount = $payment_amount;
$generateFpsVoucherTrxData->truck_owner_account =  $owner_account_qry['data'][0]['id'] . "-" .  $owner_account_qry['data'][0]['sub_id'];
$generateFpsVoucherTrxData->debit_note = "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn;

$template_id = 4;   //4= سداد السلفة
$jv_trx_2 = $fpsVoucherCore->generateFpsVoucherTrx(
    $template_id,
    $generateFpsVoucherTrxData,
    $recipient_company_id,
    "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn,
    true
);
$data = new stdClass();
$data->ledger_account_id = $account_ledger_id;
$data->jv_date = DBConnection::getSystemDate();
$data->remarks = "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn;
$data->trx = $jv_trx_2;

$fps->createTrx($data, 0);

dump($data);
die;





$poll_id = 109647;
$pollBean = $pollIntegration->getPoll($poll_id);
$callBack = $pollBean['details']['attributes']['callback'];
if ($callBack && $callBack[0]) {
    dump($callBack[0]['data']['method']);
    die;
}
die;

// $waybill_id = 417857;
// $cargo_id = 2110021850;
// $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);

// $cargoPolicyBean = new stdClass();
// $cargoPolicyBean->waybill_id  = $waybill_id;
// $cargoPolicyBean->cargo_id  = $cargo_id;
// $cargo_policy_id = $cargoCore->createCargoPolicy($cargoPolicyBean, 0);

// // add new integration node in waybill document to store Cargo Policy info
// $cargoPolicyBean = $policyCore->getCargoPolicy($cargo_policy_id, 0);
//  if(!$waybillBean->document->integeration_details){
//     $waybillBean->document->integeration_details = new stdClass();
// }
// $waybillBean->document->integeration_details->cargo_policy = new stdClass();
// $waybillBean->document->integeration_details->cargo_policy->id = $cargoPolicyBean->id;
// $waybillBean->document->integeration_details->cargo_policy->serial_number = $cargoPolicyBean->serial_number;
// $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

// dump($cargoPolicyBean);die;




$truck_owner_id = 432877;
$account_ledger_id = 590000;
$recipient_company_id = 266770;


$jv_trx_2 = [];
$jv_trx_2[] = array(
    "account" => "590000-6077385", //TODO
    "amount" =>  200.771,
    "op" => "C",
    "notes" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143649",
    "trx_note" => ["text" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143649"],
    "source_account" => true
);
$jv_trx_2[] = array(
    "account" => "590000-14008", //TODO
    "amount" => 200.771,
    "op" => "D",
    "notes" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143649",
    "trx_note" => ["text" => "بدل فرق قيمة سلفة الديزل للشاحنة بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143649"],
    "source_account" => false
);


$data = new stdClass();
$data->ledger_account_id = $account_ledger_id;
$data->jv_date = DBConnection::getSystemDate();
$data->remarks = "سداد قيمة السلفة من رحلة المستند رقم 2120143649";
$data->trx = $jv_trx_2;

$fps->createTrx($data, 0);

echo "done";
die;




// $trx_template = [];
// $trx_template[] = array(
//     "account" => "590000-6077352", //TODO
//     "amount" =>  44.391,
//     "op" => "C",
//     "notes" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143205",
//     "trx_note" => ["text" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143205"],
//     "source_account" => true
// );
// $trx_template[] = array(
//     "account" => "590000-14008", //TODO
//     "amount" => 44.391,
//     "op" => "D",
//     "notes" => "بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143205",
//     "trx_note" => ["text" => "بدل فرق قيمة سلفة الديزل للشاحنة بدل فرق سداد قيمة السلفة من رحلة المستند رقم 2120143205"],
//     "source_account" => false
// );
// $data = new stdClass();
// $data->ledger_account_id = 590000;
// $data->jv_date = DBConnection::getSystemDate();
// $data->remarks = "بدل فرق قيمة سلفة الديزل ";
// $data->trx = $trx_template;

// $fps->createTrx($data, 2);


die;


$waybill_id = 416028;
$waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
$payment_amount = $waybillBean->document->freight->amount->total_advance_payment;

// add new payment to truck claim in case it has
$fps_claim_core = new Fps_claim_core();
$truck_owner_id = $waybillBean->document->carrier[0]->truck_owner->id;
$fps_claim_core->addPaymentToTruckOwnerClaim($payment_amount, $truck_owner_id, "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn, 0);


die;



// validate truck account and limit
$tenderTruckFilter = [
    ['key' => 'tender_id', 'val' => 23],
    ['key' => 'tn', 'val' => $tn],
    ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
];
$tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0,  0);
$financial_details = $tenderTruckResult->data[0]->financial_details;
if (!$financial_details) {
    throw new Exception("لا يوجد حساب مالي للشاحنة على مشروع سلف الشاحنات");
}
$financial_details = json_decode($financial_details);
$default_contact_truck_owner_id = $tenderTruckResult->data[0]->default_contact_user_id;
$truckOwnerBean = $truckOwnerCore->getTruckOwnerBasic($default_contact_truck_owner_id, 0);
$default_recipient_bean = $userCore->getUserBasic($truckOwnerBean->user_id, 0);

// for testing
$default_recipient_user_id = $default_recipient_bean->id;
$default_recipient_phone_number = convertToInternational($default_recipient_bean->phone);
//$this->_socialCore->createPost($sender_id, $default_recipient_user_id, $body); 


// Generate view voucher QR link
$smsHash = substr($secret, 0, 20);
$url =  "g.minagate.com/?c=";
$sms_url = $url . $smsHash;

// fetch voucher details
$voucher_amount = $voucher_amount . " دينار ";
$smsMsg = "سلفة " .  $voucher_type_caption . " بقيمة " . $voucher_amount . "\n" . " عن طريق" . "\n" . $sms_url;

$sms_msg_id = 3;

$claim_item_bean = $fps->getClaimItem($claim_item_id, 2);
$details = $claim_item_bean['details'];

$details['sms_details'] = [];
$details['sms_details']['msg_id'] = $sms_msg_id;
$details['sms_details']['text'] = str_replace("\n", " ", $smsMsg);
$details['sms_details']['recipient'] = $default_recipient_phone_number;
$details['sms_details']['time_stamp'] = DBConnection::getSystemDate();

$smsUpdateData = new stdClass();
$smsUpdateData->claim_item_id = $claim_item_id;
$smsUpdateData->details = $details;
$response = $fps->updateClaimItemDetails($smsUpdateData, 2);



dump($response);

die;







$poll_id = 109207;
foreach ($phones as $p) {
    $searchFilter = [['key' => 'phone', 'val' => convertToInternational($p)]];
    $userBean = $userCore->searchUser($searchFilter, 1, 0, 0)->data[0];

    if ($userBean) {
        $recipients = [];

        $rec['user_id'] = $userBean->id;
        $rec['bind_params'] = [];
        $rec['communication_channels'] = [
            ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
            ['channel' => 'SMS', 'details' => ['phone_number' => $userBean->phone], 'status' => 'ACTIVE', 'priority' => 2]
        ];
        $recipients[] = $rec;
        $pollIntegration->appendRecipientToPoll($poll_id, $recipients);
    }
}


die;



$taskCore = new GCPTask_core();
$task_name = "test";
$queue_name = "wallMessages";
$cb_url = "test";
$cb_data = [];
$delay = 100;
$result = $taskCore->pushTask($task_name, $queue_name, $cb_url, $cb_data, $delay);
dump($result);
die;

// generate trx
$trx = [];
$ledger_account_id = 590000;
$temp = new stdClass();
$temp->amount =  495.533;
$temp->account = "500003-43003";
$temp->op = 'C';
$temp->notes =  "موافقة على المستند 2120130907 للشاحنة رقم 6057766";
$trx[] = $temp;

$temp2 = new stdClass();
$temp2->amount =  495.533;
$temp2->account = "500003-43004";
$temp2->op = 'D';
$temp2->notes =  "موافقة على المستند 2120130907 للشاحنة رقم 6057766";
$trx[] = $temp2;

// create the new trx
$data = new stdClass();
$data->ledger_account_id = $ledger_account_id;
$data->jv_date = "2022-01-10 11:37:21";
$data->remarks = "موافقة على المستند 2120130907 للشاحنة رقم 6057766";
$data->trx = $trx;

$fps->createTrx($data,2);

echo "done";
die;







// call fps to add payment claim

$company_id = 900964;
$voucher_amount = 967.122;
$fps_claim->addPaymentToCompanyClaim($voucher_amount, $company_id, "حركة تسوية حساب مكتب ابو جحيشة", $_SESSION['user_id']);


die;



// generate feedback poll
$user_id = $_SESSION['user_id'];
$fps = new FPS();
$filter = ['tn' => 600001, 'status' => 'COMPLETE'];
$data = new stdClass();
$data->filter = json_encode($filter);
$voucherResult = $fps->searchVouchers($data, $user_id);


// $user_id = $_SESSION['user_id'];
// $fps = new FPS();
// $filter = ['claim_id' => 21000154, 'status' => 'COMPLETE'];
// $data = new stdClass();
// $data->filter = json_encode($filter);
// $voucherResult = $fps->searchVouchers($data, $user_id);

dump($voucherResult);
die;






$fps_claim_core = new Fps_claim_core();
$wn = 2120057858;
$fps_claim_core->addPaymentToClaim(420.554, 6054702, "سداد قيمة الدفعة المقدمة من رحلة المستند رقم " . $wn, 0);
die;



$data = $jo_petrol_integration->fetchWaybills(7);
// $data = ["ddd"=>2];
$file = 'status_7.txt';
file_put_contents($file, json_encode($data));

die;

$user_id = $_SESSION['user_id'];

//$processData = new stdClass();
$processData = new stdClass();
$processData->voucher_id = 2140057715;
$fps->processVoucherTrx($processData, $user_id);

die;


$waybill_id = 319301;
$waybillFilter = [['key' => 'id', 'val' => $waybill_id]];
$waybill = $waybillCore->searchWaybills($waybillFilter, 1000, 0, 0)->data[0];
$tn =  $waybill->tn;

$ledger_account_id = 590000;
$tn = $tn;

$data = new stdClass();
$data->filter = [
    "id" => $ledger_account_id,
    "sub_id" => $tn,
    "status" => "ACTIVE"
];
$data->filter = json_encode($data->filter);
$acc = $fps->searchAccount($data, 0);
dump($acc['found_rows']);
die;
if ($acc['found_rows'] == 0) {
    throw new Exception("لا يوجد حساب فعال للشاحنة");
}
die;



// Analyze user answers to determine the correct scenarion
$tn = 6050451;
$scenario_info = $pollIntegration->validateDownpaymentPreRequestsForCreate($tn);
dump($scenario_info);
die;


$user_ids = [
    10849, 11312, 11319, 12204, 11846, 11846, 12177, 12034, 12779, 11250, 11561, 11577, 11522, 12320, 12675, 13301, 12227, 12318, 11533, 13134, 11965, 12149, 9602, 12047, 12047, 12958, 12365, 15456, 11495, 12981, 11765, 11522, 11053
];

foreach ($user_ids as $user_id) {

    $payload = new stdClass();
    $payload->type = "set_notification";
    $payload->id = rand();
    $payload->message =  "لديك استبيان دفعة مقدمة بحاجة إالى المتابعة ";
    $result = $notificationCore->sendDataMessage($user_id, $payload);
}

echo $result;
die;







foreach ($voucherResult['data'] as $voucher) {
    if ($voucher['voucher_type_code'] == "DOWNPAYMENT") {
        echo 1;
        die;
        break;
    }
}
die;



// get what services has been taken by the truck by searching on the complete vouchers for this waybill
$filter = ['waybill_id' => $waybillBean->id, 'status' => 'COMPLETE'];
$data = new stdClass();
$data->filter = json_encode($filter);
$voucherResult = $fps->searchVouchers($data, $user_id);

$downpaymentFees = 0;
$driverWageFees = 0;
foreach ($voucherResult['data'] as $voucher) {
    if ($voucher['voucher_type_code'] == "DOWNPAYMENT") {
        $downpaymentFees = 5;
    } else if ($voucher['voucher_type_code'] == "DRIVER_WAGE") {
        $driverWageFees = 2;
    }
}


dump($downpaymentFees);
die;




$waybill_id = 199187;
$fps_claim_core = new Fps_claim_core();
$downpayment_amount = 50;
$tn = 600001;
$waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
$fps_claim_core->addPaymentToClaim($downpayment_amount, $tn, "سداد قيمة الدفعة المقدمة من رحلة المستند رقم " . $waybillBean->wn, 0);
die;


$user_id = $_SESSION['user_id'];
$id = $fps_voucher->createWaybillCompletetVoucher($waybill_id, $user_id);
dump($id);
// die;

// $tn = "6059985";
// $tender_id = "11";
// $notes = "ملاحظة المطالبات";
// $recipient_name = "محمد أحمد";
// $done_by = $_SESSION['user_id'];
// $claim_id = $fps_claim->createWaybillDownpaymentClaim($tn , $tender_id, $recipient_name, $notes , $done_by);
// // $claim_id = 21000078;
// // $waybill_id = 261208;
// // $result = $fps_claim->appendDownpaymentClaimItem($claim_id, $waybill_id, $done_by);

// dump($result);
// die;



// insert
$waybillBean = $waybillCore->getWaybillBasic(162012, 0);
// $result = $jo_petrol_integration->insertWaybill($waybillBean);


// delete
// $result = $jo_petrol_integration->deleteWaybill(275201);

// change status 3 => 4
$result = $jo_petrol_integration->getLoadsData();


dump($result);
die;











$poll_id = 103089;
$user_id = 4160;
$voucher_id = 1234;
$voucher_amount = 50;

// log voucher id in recipents
$pollBean = $pollIntegration->getPoll($poll_id);

foreach ($pollBean['recipients'] as &$recipient) {
    if ($recipient['remote_user_id'] == $user_id) {
        $recipient_id = $recipient['id'];
    }
}

$pollIntegration->logActivity($recipient_id, "انشاء أمر الصرف: " . $voucher_id . ":بقيمة: " . $voucher_amount, "VOUCHER_ID");


die;







try {
    $pa_project_id = 2;
    $paProjectBean = $paRouteWageCore->getBasicPaProject($pa_project_id, 0);
    $trx_templates = $paProjectBean->trx_template;
    foreach ($trx_templates as $template) {
        if ($template->code == 'DOWNPAYMENT') {
            $trx_template = $template->trx_template->template;
        }
    }


    // prepare the sourceAccountBean 
    foreach ($trx_template as $trx) {
        if ($trx->source_account) {
            $account_id = $trx->value[0];
            $sourceAccountBean = $fps->getAccountBasic($account_id, $_SESSION['user_id']);
        }
    }

    $frieght = null;
    $item = [];
    $item['tn'] = "6301254";
    $payment = new stdClass();
    $payment->value = 100;

    // generate the trx (freight amounts + commission + notes to be logged)
    $trx = $voucherCore->generateVoucherTrx($trx_template, $sourceAccountBean, $payment, $frieght, $item);

    dump($trx);
    die;
} catch (Exception $e) {
    dump($e);
    die;
}

echo "done";
die;


$filter = [['key' => 'TN', 'value' => 6038563]];
$nafithGrainsPermit = $registrationCore->searchNafithGrainPermit($filter, 1);
dump($nafithGrainsPermit);
die;

// good
// $waybill_id = 282271;

// bad
$waybill_id = 282321;
$waybillCore->createPermitTicket($waybill_id);
die;


dump($r);
die;





// FPS create voucher test
session_start();
$data = new stdClass();

// authority object
$authority = new stdClass();
$authority->source_account_id = intval(500001);
$authority->source_sub_id = intval(19901);
$data->authority = $authority;

// destination object
$destination = new stdClass();
$destination->user_id = 2;
$data->voucher_destination[] = $destination;

// jv_template array
$jv_template = [];
$jv_template['code'] = "code";

$voucher_note = new stdClass();
$voucher_note->text = "voucher_note";
$jv_template['voucher_note'] = $voucher_note;

$jv_note = new stdClass();
$jv_note->text = "jv_note";
$jv_template['jv_note'] = $jv_note;

$trx_template = [];
$trx_template[] = array(
    "account_id" => "500001-19901",
    "amount" => intval(5.578),
    "op" => "C",
    "notes" => "فرق مستحقات",
    "trx_note" => ["text" => "trx_note_1"],
    "source_account" => true
);
$trx_template[] = array(
    "account_id" => "500001-50001",
    "amount" => intval(5.578),
    "op" => "D",
    "notes" => "فرق مستحقات",
    "trx_note" => ["text" => "trx_note_2"]
);
$jv_template['trx_template'] = $trx_template;

$data->jv_template = $jv_template;
$data->amount = 5.578;

$r = $fps->createVoucher($data, $_SESSION['user_id']);

dump($r);
die;








$waybillBean = $waybillCore->getWaybillBasic(277608, 0);


// check if the route wage is defined for the cargo_id and origin and destination
$routeWageFilter = [
    ['key' => 'destination_id', 'val' => $waybillBean->destination_id],
    ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
    ['key' => 'cargo_id', 'val' => $waybillBean->document->cargo[0]->cargo_id],
    ['key' => 'start_date', 'val' =>  $waybillBean->create_date, 'op' => 'less than'],
    ['key' => 'end_date', 'val' =>  $waybillBean->create_date, 'op' => 'greater than'],
    ['key' => 'status', 'val' => 'ACTIVE']
];
$routeWageInfo = $routeWageCore->searchRouteWage($routeWageFilter, 1, 0, 0);

// if the route wage is not found
if ($routeWageInfo->found_rows == 0) {

    // check if there is already a ticket for the given input, so dont create
    $filter = [];
    $filter['data->body->tender_id'] = $waybillBean->tender_id;
    $filter['data->body->destination_id'] = $waybillBean->destination_id;
    $filter['data->body->cargo_id'] = $waybillBean->document->cargo[0]->cargo_id;
    $filter['type_code'] = 'ADD_ROUTE_WAGE';
    $filter['status'] = "NEW";
    $tickets = $customerCare->searchTickets($filter, 1, 1000, null);
    dump($tickets);
    die;
    // else  create new ticket of type ADD_ROUTE_WAGE
    if (sizeof($tickets['data']) == 0) {
        $ticket = new stdClass();
        $ticket->title = "انشاء تسعيرة";
        $ticket->senderName = "مدارج للخدمات اللوجستية";
        $ticket->type_code = "ADD_ROUTE_WAGE";
        $ticket->priority = 3;
        $ticket->company_id = 266770;
        $ticket->body = [
            "cargo_id" => $waybillBean->document->cargo[0]->cargo_id,
            "destination_id" => $waybillBean->destination_id,
            "origin_id" => $waybillBean->origin_id,
            "tender_id" => $waybillBean->tender_id
        ];
        $this->_customerCare->createTicket($ticket);
    }
}


die;


DBConnection::startTransaction();

try {
    // setp 1
    try {
        DBConnection::updateQueueRank($queue_id, $new_status);
    } catch (Exception $e) {
        throw new Exception("step 1: " . $e->getMessage());
    }

    // step 2
    $queueBean = $queueCore->getQueueBasic($queue_id, 0);
    $queueBean->status = $new_status;;
    unset($queueBean->truck_id);
    unset($queueBean->trailer_id);
    unset($queueBean->active_truck_id);
    DBConnection::updateDB("queue", $queueBean, 0);

    //step 3
    $new_queue_id = $queueCore->addQueue($truck_id, $driver_id, $trailer_id, 3, $tender_id, 0);
    throw new Exception("Error Processing Request", 1);

    DBConnection::commitTransaction();
} catch (Exception $e) {
    DBConnection::rollBackTransaction();
    dump($e->getMessage());
    die;
}


echo "done";
die;




// get beans
$ticket_id = 8471;
$ticketBean = $customerCare->getTicket($ticket_id);
$ticketData = json_decode($ticketBean['request']['data']);
$waybill_order_id = $ticketData->call_details->id;

$ticketBean = new stdClass();
echo (gettype($ticketBean));
die;

if (
    gettype($ticketBean) == 'array' && strtoupper($ticketBean['type'] == 'CALL')  ||
    gettype($ticketBean) == 'array' && strtoupper($ticketBean->type == 'CALL')
)
    die;

if (strtoupper($ticketBean->type) == 'CALL') {
    echo "y";
}
die;



$waybill_id = 140252;
$claimNumber = 33;
$result = $jo_petrol_integration->saveWaybillClaimNumber($waybill_id, 33);
dump($result);
die;


$result = [];
$result['addValue'] = 100;
$waybillBean = $waybillCore->getWaybillBasic(79973, 0);
// send notification
// $sender_id = 266770;
// $sender_name =  "شركة مدارج للخدمات اللوجستية ";
// $body = $socialCore->createPostBody("تعبئة ديزل" ,
//                                     "تمت تعبئة " . $result['addValue'] . " دينار في بطاقة الديزل للشاحنة " .$waybillBean->tn,                                                   
//                                     null ,
//                                     $sender_id ,
//                                     $sender_name);

$driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
$driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
dump($driver_qry);
die;
$taskQueuesCore->createPostOnWallTask($driver_qry->user_id, $body, "تعبئة ديزل");




die;

// ----------------------------------------------------------------------------------------- //
// ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
// ----------------------------------------------------------------------------------------- //
function curl($url, $fields, $method)
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 40);
    if ($method == 'POST') {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
    }

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception(curl_error($ch), curl_errno($ch));
    }

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);


    if ($http_code != 200) {
        throw new Exception("Error Processing Request : " . $result, 1);
    }
    $response = json_decode($result, 1);
    if ($response) {
        return $response;
    } else {
        return $result;
    }
}


die;


//write remark on tender_truck

//  notifivations:
//     {
//         "registration_ids": [
//     "eX5LQQ13fvs:APA91bHskC8nDUdD4RDzxg3V9o5SeGPLuXLs0uM3oUOUipYpKC3tL6JlfzwIDIkURA101DZjI8FLGoiaxwn6NXPVHq7jbseq8wtZ57Hp8opo1b7WK3us2ULKN1xsUL0fXA1XzSayAca_"
//                 ],
//         "notification":{
//             "title" : "لديك رد جديد",
//             "body": "قام محمد بالرد على المعاملة رقم125 "
//         },
//         "data": {
//             "type": "open_uri",
//             "uri": "minagate://ticket/125"
//         },
//         "priority": "high",
//         "content_available": true
//     }

$user_id = 2;
$payload = new stdClass();
$payload->user_id = $user_id;
$payload->type = "open_uri";
$payload->uri = "minagate://ticket/125";
$notification = new stdClass();
$notification->title = "لديك رد جديد على المعاملة رقم 25";
$notification->message = "لديك رد جديد على المعاملة رقم 25";
$notification->icon = "minagate_logo.png";

$result = $notificationCore->sendDataMessage($user_id, $payload, $notification);

dump($result);
die;
// if($waybillOrderBean->create_date > ){
//     echo "R";
// die;
//     // reject this assign
//     $this->cancelCall($waybill_order_id);
// }
// echo "C";
die;


// // // $company_id = 65017;
// // // $accountCore->setupSubAccounts($company_id,0);
// // // die;

// // $pa_id =2;
// // $trucking_company_id = 13;
// // $accountCore->setupFinancialConections_type1($pa_id,$trucking_company_id);

// // die;


 

// // $jo_petrol_integration = new Jo_Petrol();

// // $waybillBean = $waybillCore->getWaybillBasic(79973,0);
// // $r = $jo_petrol_integration->insertWaybill($waybillBean);
// //  dump($r);
// //  die;


// // $jo_petrol_integration = new Jo_Petrol();
// // $tn = 6057017;
// // $result = $jo_petrol_integration->transferDeisil($tn , null);

// // dump($result);
// // die;




// $assign_cargo_id = 40605;


// $assignCargoBean = $assignCargoCore->getAssignCargoBasic($assign_cargo_id,0);

// $orders = $assignCargoBean->details->orders;

//     // loop on the orders
//     foreach ($orders as $order) {
//         $tenderOrderBean = $tenderCore->getTenderOrderBasic($order->id,0);
//         $order_notes = json_decode($tenderOrderBean->order_notes);
//         $order_notes->assign_mode = "indivisual";
//         $updateBean = new stdClass();
//         $updateBean->id = $tenderOrderBean->id;
//         $updateBean->order_notes = $order_notes;
     
//         //DBConnection::updateDB("tender_order",$updateBean,2);
//     }
   
//     // change assign_cargo to PENDING: جاهز لتوزيع الأفراد
//     $assignCargoCore->changeStatus($assign_cargo_id , "PENDING" , 0);

//     // inform super visor
//     $socialCore = new SocialCore();
//     $wall_message = "تم الإنتهاء من توزيع طلبية الشركات رقم " . $assign_cargo_id;
//     $notification_message = $wall_message;
//     $supervisor_id = 2;
//     $socialCore->informSupervisor('انتهاء طلبية الشركات', $wall_message, $notification_message, $supervisor_id);



// die;







// // setup trucking company accounts
 




// $jo_petrol_integration = new Jo_Petrol();
// $currentBalance = $jo_petrol_integration->transferDeisil(6063165 , null);              
// dump($currentBalance);
// die;
// // $accountCore->setupSubAccounts(147943,0);

// // die;
// // $trucking_company_id = 147943;
// // $pa_id = 2;
// // $accountCore->setupFinancialConections_type1($pa_id,$trucking_company_id);


// die;

// // $jo_petrol_integration = new Jo_Petrol();

// // $waybillBean = $waybillCore->getWaybillBasic(79973,0);
// // $r = $jo_petrol_integration->insertWaybill($waybillBean);
// //  dump($r);
// //  die;


// // die;

// // $voucher_id = 1940000151;
// // $voucherBean = $voucherCore->processVoucher($voucher_id,0);
// // die;

// // $new_act = new stdClass();
// // $new_act->code = "تمت عملية الدفع بنجاح , الرقم المرجعي : " . 2;
// // $new_act->time_stamp = DBConnection::getSystemDate();
// // $activity = [];
// // $activity[] = $new_act;

// // $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
// // $integration_details->activity = $activity;
// // $voucherBean->integration_details = $integration_details;

// // $voucherCore->updateVoucherInfo($voucherBean , $voucher_id, $user_id);

// // echo "done";
// // die;

// // die;

// // test zain trx result

// // $url = Config::$zain_cash_base_url . '/face';
// // $fields = array(
// //     'method'=>"testTrx", 
// //     'private_key'=> md5($voucher_id),
// //     'amount' => 574.095,
// //     'mobile' => '962788367185'
// // );
// // $response = curl($url,$fields);
// // dump($response);
// // die;



// // function curl($url,$fields){

// //     $ch = curl_init();
// //     curl_setopt($ch, CURLOPT_URL, $url);
// //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
// //     curl_setopt($ch, CURLOPT_POST, 1);
// //     curl_setopt($ch, CURLOPT_TIMEOUT, 40);
// //     curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
// //     curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
// //     curl_setopt($ch, CURLOPT_HTTPHEADER, array(
// //         'PUBLIC-KEY: '. '5Ju2KWu7LLK5nY9GnnvUcQWrknR8sMLj7gXYnSkwpLgKKpQsjzsVHCLFkygZqfKq'
// //     ));

// //     $result = curl_exec($ch);

// //     if (curl_errno($ch)) {
// //         throw new Exception(curl_error($ch) , curl_errno($ch));
// //     }

// //     $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
// //     curl_close ($ch);

// //     if($http_code != 200){
// //         throw new Exception("Error Processing Request", 1);            
// //     }

// //     $response = json_decode($result,1);
// //     if($response){
// //         return $response;
// //     }else{
// //         return $result;
// //     }
// // }
// // die;




// // die;






// // // create JV for target account
// // $from_account = "590036,30001";
// // $to_account = "530001,0";
// // $waybill_net_amount = 0.01;
// // $consignee_target_account = "";
// // $jv1_owner_account = "590000";
// // $jv_date = DBConnection::getSystemDate();

// // // $jv_trx = [];
// // // $jv_trx[] = array("account" => $from_account,
// // //                 "amount" => $waybill_net_amount,
// // //                 "op" => "C",
// // //                 "notes" => "مستحقات عن المستند رقم TEST",
// // //                 );
// // // $jv_trx[] = array("account" => $to_account,
// // //                 "amount" => $waybill_net_amount,
// // //                 "op" => "D",
// // //                 "notes" => "TEST",
// // //                 );
// // // try{
// // //     DBConnection::startTransaction();                       
// // //         $jv_id = $paymentCore->addJV($jv1_owner_account, $jv_date, $jv_trx , "TEST مستحقات المستفيد عن  مستند الشحن ", 0);
// // //     DBConnection::commitTransaction();
// // // }catch(Exception $e){
// // //     DBConnection::rollBackTransaction();
// // //     throw new Exception($e->getMessage());
// // // }
// // // die;

 
// // // $clientPayment = (object) array("name"=>"WAYBILL_PAYMENT",
// // //                                 "label"=>'قيد مستحقات',
// // //                                 "target_account"=>$consignee_target_account,
// // //                                 "time_stamp" => DBConnection::getSystemDate(),
// // //                                 "value"=>$waybill_net_amount);

// // // $voucher_id = $voucherCore->createVoucher($from_account, $to_account, $waybill_net_amount,
// // //                                           "ZAIN_CASH" ,$clientPayment,null,
// // //                                           'WAYBILL', "TEST" , "مستحقات المستند رقم TEST", 10);

// // //  die;


// // // $trucking_company_id = 300;
// // // $pa_id = 2;
// // // $accountCore->setupFinancialConections_type1($pa_id,$trucking_company_id);
// // // die;


// // // // // echo "result =" ;
// // // // // dump($result);
// // // // // die;

// // // // $waybillBean = $waybillCore->getWaybillBasic(36707 , 2);
// // // // $waybillCore->saveTagreeshData($waybillBean, 2);
// // // // die;

// // // // die;



// // // // // setup trucking company sub-accounts
// // // // $accountCore->setupSubAccounts(1912,0);
// // // //  die;

// // // // setup pa sub-accounts
// // // $trucking_company_id = 300;
// // // $pa_id = 2;
// // // $accountCore->setupFinancialConections_type1($pa_id,$trucking_company_id);
// // // die;

// // // // discharge financial
 



// //     DBConnection::startTransaction();

// //     $jv_date = DBConnection::getSystemDate();

// //     $jv_trx = [];    
// //     $jv_trx[] = array( "account" => "500034-30002",
// //                         "amount" => 248.440,
// //                         "op" => "C",
// //                         "notes" => "صرف نقدي المستند رقم 1920023455",
// //         );      
// //     $jv_trx[] = array( "account" => "500034-60001",
// //         "amount" => 248.440,
// //         "op" => "C",
// //         "notes" => "صرف نقدي المستند رقم 1920023455"
// //     );    
// //     $paymentCore->addJV("500034", $jv_date, $jv_trx , "1920023455 صرف نقدي المستند رقم", 0);


// //     // $jv_trx = [];
// //     // $jv_trx[] = array( "account" => "510000-30034",
// //     //                     "amount" => 314.860,
// //     //                     "op" => "C",
// //     //                     "notes" => "مستحقات شركة النقل عن المستند رقم 1920041939",
// //     //                     );
// //     // $jv_trx[] = array( "account" => "510000-60001",
// //     //                     "amount" => 314.860,
// //     //                     "op" => "D",
// //     //                     "notes" => "تكاليف عن المستند رقم 1920041939",
// //     //     );      
// //     // $paymentCore->addJV("510000", $jv_date, $jv_trx , "مستحقات شركة النقل", 0);


// //     DBConnection::commitTransaction();


// // // // close financial
// // // $waybillBean = $waybillCore->getWaybillBasic(36539,0);
// // // $accountId = $paymentCore->completeWaybillFinancialProcedure($waybillBean);
 

// // // ---------------------------------------------------- Google Distance
 



// function getLocationId($location_name){

//     switch (trim($location_name)) {
//         case 'صوامع الجويدة' : return 91010025;break;
//         case 'صوامع الرصيفة' : return 91030008;break;
//         case 'الشوبك' : return 91110004;break;
//         case 'المنشية معان' : return 91110005;break;
//         case 'الجفر' : return 91110003;break;
//         case 'أيل' : return 91110006;break;
//         case 'الحسينية' : return 91110002;break;
//         case 'المريغة' : return 91110007;break;
//         case 'المشيرفة' : return 91060006;break;
//         case 'الربة' : return 91060009;break;
//         case 'القطرانة' : return 91060010;break;
//         case 'غور الصافي' : return 91060008;break;
//         case 'الدامخي' : return 91060007;break;
//         case 'الحسا' : return 91120003;break;
//         case 'غرندل' : return 91120004;break;
//         case 'العقبة' : return 91090000;break;
//         case 'القويرة' : return 91090002;break;
//         case 'الريشة' : return 91090011;break;
//         case 'الديسة' : return 91090013;break;
//         case 'رم' : return 91090014;break;
//         case 'القريقرة' : return 91090012;break;
//         case 'الموقر' : return 91010011;break;
//         case 'مستودعات الغباوي' : return 91030010;break;
//         case 'مستودعات المفرق' : return 91040013;break;
//         case 'الازرق الشمالي' : return 91030013;break;
//         case 'مركز اعلاف ناعور' : return 91010023;break;
//         case 'الجيزة' : return 91010036;break;
//         case 'ضبعة' : return 91010022;break;
//         case 'رويشد' : return 91040016;break;
//         case 'مستودعات سنقرط' : return 91010002;break;
//         case 'مستودع العالمية' : return 91010003;break;
//         case 'مستودعات القدومي' : return 91010008;break;
//         case 'مستودعات الهدف' : return 91090015;break;
//         case 'مستودعات الرز' : return 91090016;break;
//         case 'مستودعات حمودة' : return 91010001;break;
//         case 'مطاحن عمان الكبرى' : return 91010029;break;
//         case 'مطاحن جنوب عمان' : return 91010004;break;
//         case 'مطاحن الجويدة' : return 91010028;break;
//         case 'صوامع الشمال/ قلابات' : return 91020009;break;
//         case 'مستودعات واعلاف خو' : return 91030009;break;
//         case 'مطحنة ابو نصير' : return 91100003;break;
//         case 'مطحنة بوابة الشمال' : return 91020006;break;
//         case 'مطحنة الفخر' : return 91020008;break;
//         case 'مركز اعلاف مادبا' : return 91080004;break;
//         case 'مركز اعلاف الجويدة' : return 91010025;break;
//         case 'مطحنة الدقيق الاردنية' : return 91010037;break;
//         case 'وادي موسى' : return 91110008;break;
//         case 'صوامع اربد' : return 91020000;break;
//         case 'مطحنة الزرقاء الاهليه' : return 91030014;break;
//         case 'مطحنة اربد' : return 91020007;break;
//         case 'مطحنة النميش' : return 91020005;break;
//         case 'مطحنة لازورد' : return 91040015;break;
//         case 'مدينة معان' : return 91110001;break;
//         case 'مستودعات عجلون' : return 91100002;break;
//         case 'مستودعات جرش' : return 91070002;break;
//         case 'معان المدينه' : return 91110001;break;
//         case 'الطفيلة المدينه' : return 91120001;break;

        
//         default: return $location_name;
//     }
// }