<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once (dirname(__FILE__)."/../core/API.php");
use google\appengine\api\taskqueue\PushQueue;
use google\appengine\api\taskqueue\PushTask;

class TaskQueueService extends API{

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();
        DBConnection::getInstance();

        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest(){
        $func = $this->_request->method;
        unset($this->_request->method);
        if((int)method_exists($this,$func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found',404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // ------------------------------------------------------------------- //
    // ------------- create new task on cloud queue ---------------------- //
    // ------------------------------------------------------------------- //
    public function pushTaskQueue(){
        try{

            // parse incoming params
            $name = $this->_request->name;
            $delay_seconds = intval($this->_request->delay_seconds);
            $data = json_decode($this->_request->data);
            $handlerName = $this->_request->handlerName;
            $queueName = $this->_request->queueName;

            // queue task parameter
            $params = ["name" => $name . rand(), 'delay_seconds' => $delay_seconds];

            // create task
            $task = new PushTask("/$handlerName", $data, $params);
            $queue = new PushQueue($queueName);
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}


new TaskQueueService();