<?php

 // Allow from any origin
 if (isset($_SERVER['HTTP_ORIGIN'])) {
    $http_origin = $_SERVER['HTTP_ORIGIN'];
    header("Access-Control-Allow-Origin: $http_origin");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');    // cache for 1 day
}else{
    header("Access-Control-Allow-Origin: *");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');    // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        // may also be using PUT, PATCH, HEAD etc
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

    exit(0);
}


$arrContextOptions=array(
    "ssl"=>array(
        "verify_peer"=>false,
        "verify_peer_name"=>false,
    ),
);
 
$imagick = new Imagick(); 
$imagenblob= file_get_contents($_GET['src'], false, stream_context_create($arrContextOptions));
$imagick->readimageblob($imagenblob);

$imagick->setIteratorIndex(0);
$imagick->setImageFormat('jpg');

// in case the file is pdf and in portrait mode,  crop it
if (strpos($_GET['src'], '.pdf?') !== false &&
    ($imagick->getImageHeight() > $imagick->getImageWidth()) ){
    $w = 0;
    $h = $imagick->getImageHeight()/2;
    $startX = 0;
    $startY = $imagick->getImageHeight()/4;
    $imagick->cropImage($w, $h, $startX, $startY);
}else{
   // $imagick->rotateimage(new ImagickPixel('#00000000'), -90);
}

// resize image
$imagick->scaleImage(720, 720, true);

$base64 = base64_encode($imagick);

echo($base64);
 

function endsWith($haystack, $needle)
{
    $length = strlen($needle);

    return $length === 0 || 
    (substr($haystack, -$length) === $needle);
}

?>