
<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); 

require_once (dirname(__FILE__)."/../core/outgoing_integration/zain_cash.php");
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once ('../includes/config.php');

$zain_cash = new Zain_Cash();
$currentDate = DBConnection::getSystemDate();
$fromTime = date('Y-m-d',strtotime($currentDate . "-1 days")) . " 00:00:00";
$toTime = date('Y-m-d',strtotime($currentDate)). " 00:00:00";

// ------------------------------------- crude_oil Trx ------------------------------------------------

$wallet_id = 'crude_oil';
$transactions = $zain_cash->getTransactions($wallet_id, $fromTime,$toTime,null,null,"transferZainCashTrx",0);
foreach (array_reverse($transactions['RESULT']) as $trx) {

    //validate the trx is already logged
    $sql = "select * from waybill.zain_cash_log
            where DestinationMSISDN = ? and TransactionAmount = ? and TransactionDate = ?";
    $param = [$trx['DestinationMSISDN'] , $trx['TransactionAmount'] , $trx['TransactionDate'] ];    
    $result = DBConnection::runBindDatabaseQuery($sql,$param);
    if(sizeof($result) > 0 ){
        continue;
    }

    // insert the trx
    $sql = "insert into waybill.zain_cash_log (Comment, Description , DestinationMSISDN , Status , TransactionAmount , TransactionDate , TransactionReference, Wallet_id) 
            values (?,?,?,?,?,?,?,?)";
    $param = [$trx['Comment'] , $trx['Description'] , $trx['DestinationMSISDN'] , $trx['Status'] , $trx['TransactionAmount'] , $trx['TransactionDate'] , $trx['TransactionReference'], $wallet_id];    
    $result = DBConnection::runBindDatabaseQuery($sql,$param);
}


// ------------------------------------- Fuel Trx ------------------------------------------------

$wallet_id = 'fuel';
$transactions = $zain_cash->getTransactions($wallet_id, $fromTime,$toTime,null,null,"transferZainCashTrx",0);
foreach (array_reverse($transactions['RESULT']) as $trx) {

    //validate the trx is already logged
    $sql = "select * from waybill.zain_cash_log
            where DestinationMSISDN = ? and TransactionAmount = ? and TransactionDate = ?";
    $param = [$trx['DestinationMSISDN'] , $trx['TransactionAmount'] , $trx['TransactionDate'] ];    
    $result = DBConnection::runBindDatabaseQuery($sql,$param);
    if(sizeof($result) > 0 ){
        continue;
    }

    // insert the trx
    $sql = "insert into waybill.zain_cash_log (Comment, Description , DestinationMSISDN , Status , TransactionAmount , TransactionDate , TransactionReference,  Wallet_id) 
            values (?,?,?,?,?,?,?,?)";
    $param = [$trx['Comment'] , $trx['Description'] , $trx['DestinationMSISDN'] , $trx['Status'] , $trx['TransactionAmount'] , $trx['TransactionDate'] , $trx['TransactionReference'], $wallet_id];    
    $result = DBConnection::runBindDatabaseQuery($sql,$param);
}