
<?php
// ------------------------------------------------------------------------------------------------ //
// --------------- create new waybill order then send the required notification to user ----------- //
// ------------------------------------------------------------------------------------------------ //
ini_set('display_errors', 'On');

require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../core/waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/poll.php");

// for testing
if(!isset($_POST['order_id'])){
    $_POST = $_GET;
}

// get the params from POST
// $order_id = $_POST['order_id'];
// $cargo_id = $_POST['cargo_id'];
// $truck_owner_id = $_POST['truck_owner_id'];
// $queue_id = $_POST['queue_id'];
// $tender_id = $_POST['tender_id'];

// prepare objects
$waybillOrderCore = new WaybillOrderCore();
$userCore = new UserCore();
$pollIntegration = new Poll;

//TODO: create WO


$waybill_order_id = 2030002935;
$contact_user_id = 10994;

// prepare args
$searchFilter = [['key'=>'id','val' => $waybill_order_id]];
$waybillOrdersQry = $waybillOrderCore->searchWaybillOrder($searchFilter,1,0,0);
$waybillOrder = $waybillOrdersQry->data[0];
$order_notes = json_decode($waybillOrder->order_notes);
 
    $poll = [];
    $poll['details'] = [];

    // questions 1
    $question1_label =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn على الحمل $waybillOrder->cargo_name مع $waybillOrder->trucking_company_name";
    if($order_notes->accept_waybill_order_sms){
        $question1_label .= " - " . $order_notes->accept_waybill_order_sms;
    }
    if($order_notes->extra_note){
        $question1_label .= " - " . $order_notes->extra_note;
    }
    $question = [];
    $question['question_id'] = "0";
    $question['validation'] = ["method" => "none"];
    $question['question_lable'] = $question1_label;
    $question['question_type'] = "SINGLE";  // SINGLE , MULTIPLE, FREE_TEXT
    $answers = [["caption"=>"الموافقة" , "value" => 1 , "theme" => "primary" , "next_question" => 1] , 
                ["caption"=>"رفض أمر الحركة" , "value" => 0 , "theme" => "outline", "next_question" => null] ];
    $question['answers'] = $answers;
    $poll['details']['questions'][] = $question;    

    // questions 2
    $question = [];
    $question['question_id'] = "1";
    $question['validation'] = ["method" => "remote" , 
                               "endpoint" => "https://api-dev-dot-waybill-project.appspot.com/poll?method=validatePollAnswer" , 
                               "object" => "trn",
                               "param" => ["poll_id","question_id","user_answer"] ];
    $question['question_lable'] = "الرجاء تحديد رقم المقطورة";
    $question['question_type'] = "FREE_TEXT";  // SINGLE , MULTIPLE, FREE_TEXT
    $answers = [["caption"=> "متابعة" , "value" => "714425" , "next_question" => 2]];
    $question['answers'] = $answers;
    $poll['details']['questions'][] = $question;

    // questions 3
    $question = [];
    $question['question_id'] = "2";
    $question['validation'] = ["method" => "auto_complete" , "endpoint" => "https://api-dev-dot-waybill-project.appspot.com/driver?method=driverAutoCompleteForMobile" , "param" => ["poll_id","question_id","user_answer"] ];
    $question['question_lable'] = "الرجاء تحديد السائق عبر ادخال الهاتف او الرقم الوطني";
    $question['question_type'] = "FREE_TEXT";  // SINGLE , MULTIPLE, FREE_TEXT
    $answers = [["caption"=> "متابعة" , "value" => "." , "next_question" => null]];
    $question['answers'] = $answers;
    $poll['details']['questions'][] = $question;    

    // attributes
    $poll['details']['attributes'] = [];
    $poll['details']['attributes']['title'] = 'أمر حركة';
    $poll['details']['attributes']['is_dismissible'] = false;
    $poll['details']['attributes']['expiry_date'] = date('Y-m-d H:i:s', strtotime("+15 minutes", strtotime(DBConnection::getSystemDate())));
    $poll['details']['attributes']['can_change_answer'] = false;
    $poll['details']['attributes']['max_retries'] = "1";
    $poll['details']['attributes']['description'] = "أمر حركة";
    $poll['details']['attributes']['communication_channel_code'] = "FCM";
    $poll['details']['attributes']['callback'] = [
                                                    ["type"=> "answer" ,
                                                    "url" => "https://api-dev-dot-waybill-project.appspot.com/waybill_order" , 
                                                    "data"=> ["waybill_order_id"=>$waybill_order_id , "method" => "processWaybillOrder"]],
                                                    ["type"=> "expiry" ,
                                                    "url" => "https://api-dev-dot-waybill-project.appspot.com/waybill_order" , 
                                                    "data"=> ["waybill_order_id"=>$waybill_order_id , "method" => "pushToCallCenter" , "force_manual_mode" => false]]
                                                ];
    $poll['details']['attributes']['notification_title'] = "لديك أمر حركة بحاجة للموافقة";
    $poll['details']['attributes']['priority'] = "1";
    $poll['details']['attributes']['scenario'] = "waybillOrderScenario";
    $poll['details']['attributes']['type'] = "notice";         // تلبيغ
    
    // recipients
    $userBean = $userCore->getUserBasic($contact_user_id , 0);

    $poll['recipients'] = [];
    $rec = [];
    $rec['user_id'] = $userBean->id;
    $rec['communication_channel_code'] = "FCM";
    $rec['communication_channel_details'] = [];
    $rec['communication_channel_details']['fcm_registration_id'] = $userBean->notification_token;
    $poll['recipients'][] = $rec;

    // create poll
    $poll_id = $pollIntegration->createPoll($poll);
    dump($poll_id);
 
    // publish poll
    $pollIntegration->publishPoll($poll_id);
                