
<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);


require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/Jo_Petrol.php");
require_once (dirname(__FILE__)."/../core/taskQueues/taskQueues_core.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/FPS.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/poll.php");
require_once (dirname(__FILE__)."/../core/social/social_core.php");


require_once ('../includes/DBConnection.php');
require_once ('../includes/Poll_DBConnection.php');
require_once ('../includes/util.php');
require_once ('../includes/config.php');

// call Jo_Petrol system to fetch data
$tender_id = 11; //TODO
$status = 2;
$jo_petrol = new Jo_Petrol();
$waybillCore = new WaybillCore();
$_SESSION['user_id'] = '0';
$jo_petrol_waybills = $jo_petrol->fetchWaybills($status);


echo "phase 1: " . $jo_petrol_waybills['found_rows'];

// loop on all waybills
$index = 0;
foreach ($jo_petrol_waybills['data'] as $rawData) {

    try{

        // convert Jo petrol raw data to meaningfull names
        $waybill = $jo_petrol->mapWaybillInfo($rawData);
        $waybillBean = $waybillCore->getWaybillBasic($waybill['id'] , 0);

        if(!$waybillBean) continue;

        if($waybillBean->status == "COMPLETE") {
            $jo_petrol->changeWaybillStatus($waybillBean->id , 3);
        }
        if($waybillBean->status == "CLOSED") {
            $result = $jo_petrol->changeWaybillStatus($waybillBean->id , 3);
        }
        if($waybillBean->status == "ACTIVE" || $waybillBean->status =="PENDING" ){
            // continue excution this script
        }else{
            continue;
        }

                // validate if the weight is defined
                // TODO: take action here
                if(!$waybill['loading_weight'] || $waybill['loading_weight']=="") continue;

                $waybill['loading_weight'] = doubleval($waybill['loading_weight']);
                $loading_weight = doubleval($waybill['loading_weight'] / 1000);

                // gross weight
                if(strLen($waybill['loading_gross_weight']) > 5) {
                    $loading_gross_weight = substr($waybill['loading_gross_weight'], 0, 5);
                }else{
                    $loading_gross_weight = $waybill['loading_gross_weight'];
                }

                // tare weight
                if(strLen($waybill['loading_tare_weight']) > 5) {
                    $loading_tare_weight = substr($waybill['loading_tare_weight'], 0, 5);
                }else{
                    $loading_tare_weight = $waybill['loading_tare_weight'];
                }

                // change status of waybill to PENDING
                if($waybillBean->status == "ACTIVE"){
                    $waybillCore->changeStatus($waybillBean->id,'PENDING',$_SESSION['user_id']) ;
                    $waybillBean = $waybillCore->getWaybillBasic($waybillBean->id, $_SESSION['user_id']);
                }

                // format $loading_time_stamp;
                $cargoBean = $waybillBean->document->cargo[0];
                $loading_time_stamp = $waybill['loading_date'] . " " . $waybill['loading_time'];
                   if(!$loading_time_stamp || $loading_time_stamp == "" || $loading_time_stamp == " "){
                        $loading_time_stamp = DBConnection::getSystemDate();
                        $cargoBean->weights->loading->time_stamp_source = "MINAGATE";
                   }

                // write down the loading weights

                $cargoBean->weights->loading->net_weight = $loading_weight;
                $cargoBean->weights->loading->time_stamp = $loading_time_stamp;
                $cargoBean->weights->loading->gross_weight->weight = $loading_gross_weight;
                $cargoBean->weights->loading->gross_weight->time_stamp = $loading_time_stamp;
                $cargoBean->weights->loading->tare_weight->weight = $loading_tare_weight;
                $cargoBean->weights->loading->tare_weight->time_stamp = $loading_time_stamp;

                $waybillBean->document->cargo[0] = $cargoBean;
                $waybillCore->updateWeight($waybillBean ,$_SESSION['user_id']);

                // write down Jo_Petrol integration node
                if(!$waybillBean->document->integeration_details->jo_petrol){
                    $waybillBean->document->integeration_details->jo_petrol = new stdClass();
                }
                $waybillBean->document->integeration_details->jo_petrol = $rawData;
                $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

                // if the loading weight in waybill is different than integration weight
                $original_loading_weight = $cargoBean->weights->loading->net_weight;
                if($original_loading_weight && $original_loading_weight != $loading_weight){
                    $waybillCore->logActivity($waybillBean->id,
                    "تغير وزن التحميل - ربط إلكتروني",
                    "وزن التحميل القديم: ". $original_loading_weight ."  - الوزن الجديد : " . $loading_weight . " كغم",
                    "LOAD_CARGO",0);
                }else{
                    // write down note
                    $waybillCore->logActivity($waybillBean->id,
                    " تثبيت وزن التحميل - ربط الكتروني ",
                    "وزن التحميل : ". $loading_weight ." كغم ",
                    "LOAD_CARGO",0);
                }

                // change status of waybill to ONROAD
                $waybillCore->changeStatus($waybillBean->id,'ONROAD',$_SESSION['user_id']) ;

                // write a confirmation message on Jo_Petrol system , by updating the status to 3
                $jo_petrol->changeWaybillStatus($waybillBean->id , 3);

                // in case the tender id is 12 , close the waybill after 6 hours
                if($waybillBean->tender_id == 12){
                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->createCloseWaybillTask($waybillBean->id,6, "السبب : اغلاق المستند بسبب مرور أكثر من 6 ساعة على التحميل");
                }




    }catch(Exception $e){
        echo $e->getMessage();

        // inform supervisor
    }
}

echo "start phase 2 , the discharge";




// --------------------- Stage 2 ----------------


$status = 5;
$jo_petrol_waybills = $jo_petrol->fetchWaybills($status);
dump($jo_petrol_waybills);die;


// loop on all waybills
foreach ($jo_petrol_waybills['data'] as $rawData) {

    try{

        // convert Jo petrol raw data to meaningfull names
        $waybill = $jo_petrol->mapWaybillInfo($rawData);
        $waybillBean = $waybillCore->getWaybillBasic($waybill['id'] , 0);

        if(!$waybill['discharge_weight'] || $waybill['discharge_weight']=="") continue;

        $waybill['discharge_weight'] = doubleval($waybill['discharge_weight']);
        $discharge_weight = doubleval($waybill['discharge_weight'] / 1000);

        // add sea water weight
        if($waybill['sea_water'] && $waybill['sea_water'] != "" && $waybill['sea_water_confirmation'] == "1"){

            $waybill['sea_water'] = doubleval($waybill['sea_water']);
            $sea_water = doubleval($waybill['sea_water'] / 1000);
            $discharge_weight += doubleval($sea_water);

            if($discharge_weight > $loading_weight){
                $discharge_weight = $loading_weight;
            }
        }

        if(strLen($waybill['discharge_gross_weight']) > 5) {
            $discharge_gross_weight = substr($waybill['discharge_gross_weight'], 0, 5);
        }else{
            $discharge_gross_weight = $waybill['discharge_gross_weight'];
        }

        if(strLen($waybill['discharge_tare_weight']) > 5) {
            $discharge_tare_weight = substr($waybill['discharge_tare_weight'], 0, 5);
        }else{
            $discharge_tare_weight = $waybill['discharge_tare_weight'];
        }

        // change status of waybill to ARRIVED
        if($waybillBean->status == "ONROAD") {
            $waybillCore->changeStatus($waybillBean->id,'ARRIVED',$_SESSION['user_id']) ;
            $waybillBean = $waybillCore->getWaybillBasic($waybillBean->id, $_SESSION['user_id']);
        }

        // write down Jo_Petrol integration node
        if(!$waybillBean->document->integeration_details->jo_petrol){
            $waybillBean->document->integeration_details->jo_petrol = new stdClass();
        }
        $waybillBean->document->integeration_details->jo_petrol = $rawData;
        $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

        // format $discharge_time_stamp;
        $discharge_time_stamp = $waybill['discharge_gate_out_date'] . " " . $waybill['discharge_gate_out_time'];

        // write down the discharge weight
        $cargoBean = $waybillBean->document->cargo[0];
        $cargoBean->weights->discharge->net_weight = $discharge_weight;
        $cargoBean->weights->discharge->time_stamp = $discharge_time_stamp;
        $cargoBean->weights->discharge->gross_weight->weight = $discharge_gross_weight;
        $cargoBean->weights->discharge->gross_weight->time_stamp = $discharge_time_stamp;
        $cargoBean->weights->discharge->tare_weight->weight = $discharge_tare_weight;
        $cargoBean->weights->discharge->tare_weight->time_stamp = $discharge_time_stamp;

        $waybillBean->document->cargo[0] = $cargoBean;
        $waybillCore->updateWeight($waybillBean ,$_SESSION['user_id']);

        // if the discharge weight in waybill is different than integration weight
        $original_weight = $cargoBean->weights->discharge->net_weight;
        if($original_weight && $original_weight != $discharge_weight){
            $waybillCore->logActivity($waybillBean->id,
            "تغير وزن التفريغ - ربط إلكتروني",
            "وزن التفريغ القديم: ". $original_weight ."  - الوزن الجديد : " . $discharge_weight . " كغم",
            "LOAD_CARGO",0);
        }else{
            // write down note
            $waybillCore->logActivity($waybillBean->id,
            " تثبيت وزن التفريغ - ربط الكتروني ",
            "وزن التفريغ : ". $discharge_weight ." كغم ",
            "LOAD_CARGO",0);
        }

        if($waybillBean->status == "ARRIVED") {
            // change status of waybill to CLOSED
            $waybillCore->changeStatus($waybillBean->id,'CLOSED',$_SESSION['user_id']) ;
        }

        // write a confirmation message on Jo_Petrol system , by updating the status to 6
        $jo_petrol->changeWaybillStatus($waybillBean->id , 6);

        if($waybillBean->status == "COMPLETE") {
            // TODO: send ticket to financial super visor to inform him that the discharge weight has been updated after issuing voucher
        }



    }catch(Exception $e){

        echo $e->getMessage();
        // inform supervisor

        logHamzeh("erro in sync joPetrol",$e->getMessage());
    }
}


echo "finish";




