<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once (dirname(__FILE__)."../../includes/DBConnection.php");


class FileSessionHandler{

    public function __construct(){
        DBConnection::getInstance();
    }

    function open($savePath, $sessionName){

        $milliseconds = round(microtime(true) * 1000) . rand(1,999);

        // log session into database
        $sqlQuery = "insert into session
                        (id,php_session,start_session,ip_address,browser,update_by)
                    values
                        (?,?,?,?,?,?)";
            
        $id = intval($milliseconds);
        $php_session = session_id();
        $start_session = date("Y/m/d") . " " .  date("h:i:s");
        $ip_address = $this->getIpAddressInfo()->ip;
        $browser = $_SERVER['HTTP_USER_AGENT'];

        try{
            $param = [$id, $php_session, $start_session, $ip_address, $browser, 0];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery,$param);
        }catch(Exception $e){}
    
        return true;
    }

    function close()
    {
        dump("close");
        return true;
    }

    function read($id)
    {
        dump("read" . $id);
        return "";
    }

    function write($id, $data)
    {
        $_SESSION[$id] = $data;       
        return "";
    }

    function destroy($id)
    {
        dump("destroy" . $id );       
        return true;
    }

    function gc($maxlifetime)
    {
        dump("gc" . $maxlifetime );        

        return true;
    }

    function getIpAddressInfo(){
        //step1
        $cSession = curl_init(); 
        //step2
        curl_setopt($cSession,CURLOPT_URL,"https://ipinfo.io/".$_SERVER['REMOTE_ADDR']."/json");
        curl_setopt($cSession,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($cSession,CURLOPT_HEADER, false); 
        //step3
        $result=curl_exec($cSession);       
        //step4
        curl_close($cSession);
        //step5
        $result = json_decode($result);
        return $result;
       
    }
}

$handler = new FileSessionHandler();
session_set_save_handler(
    array($handler, 'open'),
    array($handler, 'close'),
    array($handler, 'read'),
    array($handler, 'write'),
    array($handler, 'destroy'),
    array($handler, 'gc')
    );

// the following prevents unexpected effects when using objects as save handlers
register_shutdown_function('session_write_close');
session_start();

// proceed to set and retrieve values by key from $_SESSION