<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/notes/add_notes_core.php");


// init 
DBConnection::getInstance();
$queueCore = new QueueCore();
$tenderCore = new TenderCore();
$addNoteCore = new Add_notes_core();

$user_id =2;
$erros = [];
$activeQueueStatus = DBConnection::getActiveStatus('queue');
$tender_id = 3;
$q_id = 1;

// read truck_id from csv
$filePath = 'queue_truck.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];
$result = parseCsvFile($filePath,$startRow,$limit);

foreach ($result as $queueTruck) {
    try{
           
        // get queue info
        $queueSearchFilter = [
            ['key'=>'tn','val' =>$queueTruck[0]],
            ['key'=>'q_id','val' =>$q_id],
            ['key'=>'tender_id','val' =>$tender_id],
            ['key'=>'status','val' =>$activeQueueStatus , 'op' => 'in']];
        $queueTruckResult = $queueCore->searchQueue($queueSearchFilter,1,0,$user_id) ;
        $queue_id = $queueTruckResult->data[0]->id;

        if(!$queue_id){
            continue;
        }
    
        // remove from queue       
        $queueCore->changeStatus($queue_id,'INACTIVE',$user_id);

        // change tender_truck status to PENDING
        $tenderTruckSearchFilter = [['key'=>'tender_id','val' => $tender_id],
                                    ['key'=>'q_id','val' => $q_id],
                                    ['key'=>'tn','val' => $queueTruck[0]],
                                    ['key'=>'status','val' => ['ACTIVE','NEW'] , 'op'=>'in']
                                ];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckSearchFilter,1,0,0);      
        $tender_truck_id = $tenderTruckResult->data[0]->id;
      
        $tenderCore->changeTruckStatus($tender_truck_id, "PENDING", $user_id);

        // add remarks on tender_truck
        $remarks = 'ايقاف عقد تشغيل الشاحنة بسبب عدم قيامها بأي رحلة لاكثر من 3 شهور';
        $addNoteCore->addNotes('tender_truck', $tender_truck_id, $remarks , $user_id );

        // send SMS to truck owner
        $truck_owner_phone = $queueTruckResult->data[0]->truck_owner_phone;
        $messageBody = "يرجى العلم انه ونظرا لعدم قيامك بالتحميل على البواخر لمدة تزيد عن ثلاثة شهور فقد تم حذف الشاحنة رقم ($queueTruck[0]) عن دور البواخر.";    
        sendSMS($truck_owner_phone,$messageBody);

        dump($queueTruck[0]);
    }catch(Exception $e){
        dump("------Error----------------");
        dump($queueTruck[0]);
        dump("----------------------");
    }
}
