<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/mg_registrar.php");
require_once (dirname(__FILE__)."/../core/company/trucking_company/trucking_company_core.php");
require_once (dirname(__FILE__)."/../core/company/company_core.php");


// init obj
$truckCore = new TruckCore();
$truckContractCore = new TruckContractCore();
$tenderCore = new TenderCore();
$mg_registrar = new MG_registrar();
$truckingCompanyCore = new TruckingCompanyCore();
$tenderCompanyCore = new TenderCompanyCore();
$companyCore = new CompanyCore();

session_start();
$created_by = 2;

// get input params
$destinationsFilePath = 'json/tender_trucks.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];
$tender_id = 13;

$tenderTrucks = parseCsvFile($destinationsFilePath,$startRow,$limit);
$activeTenderTrucks =  DBConnection::getActiveStatus('tender_truck');

 
foreach ($tenderTrucks as $truck) {

    $tender_company_id = $truck['0'];
    $tn = $truck['2'];
    $trn = $truck['3'];

    $tenderFilter = [['key'=>'tn','val' =>$tn],
                    ['key'=>'status', 'val' =>$activeTenderTrucks , 'op'=>'in'],
                     ['key'=>'tender_id','val' =>$tender_id]];
    $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,$limit, $startRow,0);
    if($tenderTruck_qry->found_rows > 0){
        echo "continue </br>";
        continue;
    }


    // validate if the truck exists
    $truckFilter = [['key'=>'tn','val' =>$tn],
                    ['key'=>'status','val' => ['INACTIVE'], 'op'=>'not in']];
    $truck_qry = $truckCore->searchTrucks($truckFilter,1, 0, $_SESSION['user_id'] );


    // get truck owner
    $searchFilter = [['key'=>'id','val' => $tender_company_id ,'op' => '=']];
    $tenderCompany = $tenderCompanyCore->searchTenderCompany($searchFilter,1,0,$_SESSION['user_id']);
    $tc_id = $tenderCompany->data[0]->trucking_company_id;

    $tc_searchFilter = [['key'=>'id','val' => $tc_id]];
    $tc_qry = $truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);

    $company_id = $tc_qry->data[0]->company_id;

    $searchFilter = [['key'=>'id','val' => $company_id]];
    $companyInfo = $companyCore->searchCompany($searchFilter,1,0,$_SESSION['user_id']);
    $truck_owner_id = $companyInfo->data[0]->truck_owner_id;


    // try to search in MG_REG
    if($truck_qry->found_rows == 0){

        try{
            $result = $mg_registrar->getTruckData($tn, 'JOR', 'c395');     
            if($result)  {
                $autocompleteTruckBean = $result[0]['details'];
                $truckBean = json_decode($autocompleteTruckBean,true);
            }
        }catch(Exception $e){

        }
       
 
        if($truckBean){
            $date = str_replace('/', '-', $truckBean['reg_expiry'] );
            $truckBean['reg_expiry'] = date("Y-m-d", strtotime($date));
            unset($truckBean['tc']);
            unset($truckBean['truck_owner_name']);
            $truckBean = ToObject($truckBean);         
            $truckBean->status = "NEW";

             // create truck record
            $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,$_SESSION['user_id']);
            $truckBean->id = $truck_ID;

            // activate it
            $truckCore->changeStatus($truck_ID, 'ACTIVE',$_SESSION['user_id']);
            
        }

        //if no truck is found, insert empty record
        if(!$truckBean){

            $truckBean = new stdClass();
            $truckBean->tn = $tn;
            $truckBean->nationality_code = 'JOR';
            $truckBean->reg_num = 0;
            $truckBean->tt = 920000;
            $truckBean->minor_tt =  9;
            $truckBean->cat =  "TRUCK";
            $truckBean->status =  "NEW";
            $truckBean->truck_owner_id =  $truck_owner_id;
            $truckBean->update_by = 2;

            $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,$_SESSION['user_id']);
            $truckBean->id = $truck_ID;

             // activate it
            $truckCore->changeStatus($truck_ID, 'ACTIVE',$_SESSION['user_id']);

            echo "empty truck " . $tn . "</br>"; 
        }
    }else{
        $truckBean = $truck_qry->data[0];
    }

    $tenderTruck = new stdClass();
    $tenderTruck->tender_id = $tender_id;
    $tenderTruck->tender_company_id = $tender_company_id;
    if($truckBean->cat == "TRUCK"){
        $tenderTruck->truck_id = $truckBean->id;
    }else{
        $tenderTruck->trailer_id = $truckBean->id;
    }
    $tenderTruck->questionnaire = '[{"id": 1, "val": ["*"]}, {"id": 2, "val": 91090000}, {"id": 3, "val": "_TRUCK_$_MINOR_TT_"}]';
    $tenderTruck->financial_details = '{"advance_payment_account": [], "waybill_beneficiary_account": ""}';
    
    // create the DB record tender
    $createTenderTruckResult = DBConnection::insertDB("tender_truck",$tenderTruck,$_SESSION['user_id']);
    $tender_truck_id =  $createTenderTruckResult[0]['@id'];    

    $tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', $_SESSION['user_id']);
 

}

    
function ToObject($Array) { 
      
    // Create new stdClass object 
    $object = new stdClass(); 
      
    // Use loop to convert array into 
    // stdClass object 
    foreach ($Array as $key => $value) { 
        if (is_array($value)) { 
            $value = ToObject($value); 
        } 
        $object->$key = $value; 
    } 
    return $object; 
}