<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");

require_once ('../includes/util.php');

// init obj
$truckCore = new TruckCore();
$truckContractCore = new TruckContractCore();
$tenderCore = new TenderCore();
session_start();

// get input params
$destinationsFilePath = 'json/destinations.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

// parse the file and load it into memory
//$trucks = parseCsvFile($truckFilePath,$startRow,$limit);
$destinations = parseCsvFile($destinationsFilePath,1,4000);

$erros = [];
$created_by = 2;
$tender_id = 13;
$activeTenderTrucks =  DBConnection::getActiveStatus('tender_truck');

$tenderFilter = [['key'=>'status', 'val' =>$activeTenderTrucks , 'op'=>'in'],
                 ['key'=>'tender_id','val' =>$tender_id],             
                ];
$tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,$limit,$startRow, $created_by);
 
// loop on the trucks array
foreach ($tenderTruck_qry->data as $tenderTruckBean) {
    try{
          
        $tn = $tenderTruckBean->tn;       
        // generate questionarre
        $questionnaire = [];

        $question1 = new stdClass();
        $question1->id = 1;
        $question1->val = getDestinations($tn,$destinations);
        $questionnaire[] = $question1;
        
        $question2 = new stdClass();
        $question2->id = 2;
        $question2->val = 91090000; // العقبة
        $questionnaire[] = $question2;

        $question3 = new stdClass();
        $question3->id = 3;
        $question3->val = '_TRUCK_$_MINOR_TT_';
        $questionnaire[] = $question3;

        // update it
        $tenderTruckBean->questionnaire = json_encode($questionnaire,JSON_UNESCAPED_UNICODE);
        $tenderCore->updateTenderTruck($tenderTruckBean, $tenderTruckBean->id, $_SESSION['user_id']);

    }catch(Exception $e){
        dump($tn);        
        dump($e);       
    }

}

dump("finish");
die;




function getDestinations($input_tn,&$allDestinations){
 
    $result = [];
    foreach ($allDestinations as $index1 => $dest) {     
        $tn = $dest[0];  
        if($tn == $input_tn){
            foreach ($dest as $index => $destination_name) {
                if($index == 0) continue;
    
                $destination_id = getLocationId($destination_name);
                $result[] = $destination_id;
            }
       
            unset($allDestinations[$index1]);
            break;
        }        
    }

    if(sizeof($result) == 0){
        $result[] = "*";
    }

    return $result;
}


function getLocationId($location_name){

    switch ($location_name) {
        case 'صوامع الجويدة' : return 91010025;break;
        case 'صوامع الرصيفة' : return 91030008;break;
        case 'صوامع اربد' : return 91020004;break;
        case 'الشوبك' : return 91110004;break;
        case 'المنشية معان' : return 91110005;break;
        case 'الجفر' : return 91110003;break;
        case 'أيل' : return 91110006;break;
        case 'الحسينية' : return 91110002;break;
        case 'المريغة' : return 91110007;break;
        case 'المشيرفة' : return 91060006;break;
        case 'الربة' : return 91060009;break;
        case 'القطرانة' : return 91060010;break;
        case 'غور الصافي' : return 91060008;break;
        case 'الدامخي' : return 91060007;break;
        case 'الحسا' : return 91120003;break;
        case 'غرندل' : return 91120004;break;
        case 'العقبة' : return 91090000;break;
        case 'القويرة' : return 91090002;break;
        case 'الريشة' : return 91090011;break;
        case 'الديسة' : return 91090013;break;
        case 'رم' : return 91090014;break;
        case 'القريقرة' : return 91090012;break;
        case 'الموقر' : return 91010011;break;
        case 'مستودعات الغباوي' : return 91030010;break;
        case 'مستودعات المفرق' : return 91040013;break;
        case 'الازرق الشمالي' : return 91030013;break;
        case 'مركز اعلاف ناعور' : return 91010023;break;
        case 'الجيزة' : return 91010036;break;
        case 'ضبعة' : return 91010022;break;
        case 'رويشد' : return 91040016;break;
        case 'مستودعات سنقرط' : return 91010002;break;
        case 'مستودع العالمية' : return 91010003;break;
        case 'مستودعات القدومي' : return 91010008;break;
        case 'مستودعات الهدف' : return 91090015;break;
        case 'مستودعات الرز' : return 91090016;break;
        case 'مستودعات حمودة' : return 91010001;break;
        case 'مطاحن عمان الكبرى' : return 91010039;break;
        case 'مركز اعلاف الجويدة' : return 91010040;break;
        case 'مطاحن جنوب عمان' : return 91010029;break;
        case 'مطاحن الجويدة' : return 91010028;break;
        case 'صوامع الشمال/ قلابات' : return 91020009;break;
        case 'مستودعات واعلاف خو' : return 91030009;break;
        case 'مطحنة ابو نصير' : return 91100003;break;
        case 'مطحنة بوابة الشمال' : return 91020006;break;
        case 'مطحنة الفخر' : return 91020008;break;
        case 'مركز اعلاف مادبا' : return 91080004;break;        
        case 'مطحنة الدقيق الاردنية' : return 91010037;break;
        case 'وادي موسى' : return 91110008;break;        
        case 'مدينة الطفيلة' : return 91120001;break;
        case 'مدينة الكرك' : return 91060002;break;
        case 'مدينة معان' : return 91110001;break;

        default: throw new Exception("LOCATION IS NOT FOUND");
        ;
    }
}










