<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
require_once(dirname(__FILE__) . "/../../../includes/util.php");
require_once(dirname(__FILE__) . "/../../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../../core/tender/tender_core.php");
error_reporting(E_ALL);
class generate_monthly_finance
{
    public function Fetch()
    {
        $date_from   = date('Y-m', strtotime("-1 month"))  . "-01";
        $date_to   = date('Y-m') . "-01";
        DBConnection::getInstance();
        $tenderCore = new TenderCore();
        $result = [];
        $tender_ids = [3, 11, 12, 13];
        // title
        $result['_$_MONTH_$_'] = date('m', strtotime("-1 month"));
        // مجموع المبالغ المدفوعة ومجموع المستفيدين
        $tender_ids_string = implode(', ', $tender_ids);
        // calculate average amount during current year
        $avgQuery = " select avg(v.amount) as amount_avg , avg(v.count) count_avg from (
            select 
            sum(trx_template->>'$.amount') amount,
            count(trx_template->>'$.amount') count
            from voucher v where 
            date(payment_date) >= '" . date("Y") . "-01-01'
            and date(payment_date) < '" . date("Y-m-d") . "'
            and status = 'COMPLETE'
            and trx_template->>'$.tender_id' in (3,11,12,13)
            and system_code != 'payment_voucher'
            group by month(payment_date)
            ) as v";
        $avgResult = DBConnection::runBindDatabaseQuery($avgQuery, []);
        $voucher_amount_avg = $avgResult[0]->amount_avg;
        $voucher_count_avg = $avgResult[0]->count_avg;
        $totalSqlQry = "select sum(v.amount) as month_amount_sum , sum(v.total_voucher) month_number_of_voucher from (
        select date(payment_date) payment_date, 
        sum(trx_template->>'$.amount') amount,
        count(id) as total_voucher
        from voucher where 
                date(payment_date) >= ?
                and date(payment_date) < ?
                and status = 'COMPLETE'
                and trx_template->>'$.tender_id' in ($tender_ids_string )
                and system_code != 'payment_voucher'
                group by date(payment_date)
                ) as v";
        $totalResult = DBConnection::runBindDatabaseQuery($totalSqlQry, [$date_from, $date_to]);
        $result['_$_TOTAL_AMOUNT_$_'] = number_format($totalResult[0]->month_amount_sum, 0);
        $result['_$_TOTAL_AMOUNT_PERCENT_$_'] = $this->calculatePercentage($voucher_amount_avg, $totalResult[0]->month_amount_sum);
        $result['_$_TOTAL_AMOUNT_AVG_$_'] = number_format($voucher_amount_avg, 0);
        $result['_$_TOTAL_VOUCHERS_$_'] = $totalResult[0]->month_number_of_voucher;
        $result['_$_TOTAL_VOUCHERS_PERCENT_$_'] = $this->calculatePercentage($voucher_count_avg, $totalResult[0]->month_number_of_voucher);
        $result['_$_TOTAL_VOUCHERS_AVG_$_'] = number_format($voucher_count_avg, 0);
        
        
        // المبالغ المدفوعة حسب الأيام
        $dailyTotalSqlQry = "
            select day(payment_date) payment_date, 
            sum(trx_template->>'$.amount') amount,
            payment_method
            from voucher where 
                    date(payment_date) >= ?
                    and date(payment_date) < ?
                    and status = 'COMPLETE'
                    and trx_template->>'$.tender_id' in ($tender_ids_string )
                    and system_code != 'payment_voucher'
                    group by day(payment_date),payment_method
                    ";
        $dailyTotalResultQry = DBConnection::runBindDatabaseQuery($dailyTotalSqlQry, [$date_from, $date_to]);
        $dailyTotalResult = [];
        $payment_methods = ["ZAIN_CASH", "CHECK"];
        $date = date('F Y', strtotime("-1 month"));    //previous Month Year
        $previous_month = date("m", strtotime("+0 day", strtotime($date)));

        while (strtotime($date) <= strtotime(date('Y-m', strtotime("-1 month")) . '-' . date('t', strtotime($date)))) {
            $day = date("d", strtotime("+0 day", strtotime($date)));
           
            $dayObject = [];
            $dayObject["payment_date"] =  date("Y-m-d", strtotime($date));
            foreach ($payment_methods as $temp_payment_method) {
                // fill record from DB if exists
                foreach ($dailyTotalResultQry as $dailyRow) {
                    $amountObj = new stdClass();
                    $amountObj->payment_method = $temp_payment_method;
                    $amountObj->amount = 0;
                    if ($dailyRow->payment_date == $day && $dailyRow->payment_method == $temp_payment_method) {
                        $amountObj->amount = $dailyRow->amount;
                        break;
                    }
                }
                $dayObject[$temp_payment_method] = $amountObj->amount;
            }
           
            // go to next day
            $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
        
            // push new record
            $dailyTotalResult[] = $dayObject;
            $mon = date("m" , strtotime($date));
            if($mon > $previous_month){               
                break;
            }
        }

  
 
        $dailyArray = [];
        foreach ($dailyTotalResult as $key => $value) {
            $tempArr = [];
            foreach ($value as $v) {
                $tempArr[] = $v;
            }
            $dailyArray[] = $tempArr;
        }
        $payment_method_url = "https://chartengine-beta-dot-waybill-project.uc.r.appspot.com/GenerateCashFlowLineChart?data=" . json_encode($dailyArray);
        $dailyCashFlowResponse = $this->curl($payment_method_url, "", "POST");
        $result['_$_DAILY_CASHFLOW_BASE64_$_'] = $dailyCashFlowResponse;
         
        
        // المبالغ المدفوعة حسب طريقة الدفع        
        $payment_methods = ['CASH', 'ZAIN_CASH', 'CHECK'];
        foreach ($payment_methods as $method) {
            $byPaymentMethodSqlQry = "  SELECT sum(v.amount) as amount from(
                                        SELECT date(payment_date) payment_date , payment_method, sum(trx_template->>'$.amount') as amount
                                            FROM 
                                                voucher v
                                            WHERE
                                                date(payment_date) >= ?
                                                and date(payment_date) < ?
                                                AND status = 'COMPLETE'
                                                and payment_method = ?
                                                AND trx_template->>'$.tender_id' in ( $tender_ids_string )
                                                and system_code != 'payment_voucher'
                                                GROUP BY date(payment_date) , payment_method 
                                        ) as v";
            $byPaymentMethodResult = DBConnection::runBindDatabaseQuery($byPaymentMethodSqlQry, [$date_from, $date_to, $method]);
            $byPaymentMethodAvgSqlQry =  "select avg(v.amount) as amount_avg , avg(v.count) count_avg from (
                    select 
                    sum(trx_template->>'$.amount') amount,
                    count(trx_template->>'$.amount') count
                    from voucher v where 
                    date(payment_date) >= '" . date("Y") . "-01-01'
                    and date(payment_date) < '" . date("Y-m-d") . "'
                    and status = 'COMPLETE'
                    and trx_template->>'$.tender_id' in ($tender_ids_string)
                    and payment_method = ?
                    and system_code != 'payment_voucher'
                    group by month(payment_date)
                    ) as v";
            $byPaymentMethodAvgResult = DBConnection::runBindDatabaseQuery($byPaymentMethodAvgSqlQry, [$method]);
            if (sizeof($byPaymentMethodResult) == 0) {
                $result['_$_' . $method . '_$_'] = 0;
            } else {
                $result['_$_' . $method . '_$_'] = number_format($byPaymentMethodResult[0]->amount, 0);
            }
            $result['_$_' . $method . '_PERCENT_$_'] =  $this->calculatePercentage($byPaymentMethodAvgResult[0]->amount_avg, $byPaymentMethodResult[0]->amount);
            $result['_$_' . $method . '_AVG_$_'] =   number_format($byPaymentMethodAvgResult[0]->amount_avg, 0);
        }
        // generate bie chart
        $byMethodPieChartData = [
            "كاش" => str_replace(",", "", $result['_$_CASH_$_']),
            "زين_كاش" =>  str_replace(",", "", $result['_$_ZAIN_CASH_$_']),
            "شيكات" => str_replace(",", "", $result['_$_CHECK_$_'])
        ];
        $payment_method_url = "https://chartengine-beta-dot-waybill-project.uc.r.appspot.com/GeneratePieChart?data=" . json_encode($byMethodPieChartData);
        $response = $this->curl($payment_method_url, "", "POST");

        $result['_$_PAYMENT_METHOD_BASE64_$_'] = $response;
        // المبالغ المدفوعة حسب المشاريع        
        foreach ($tender_ids as $tender_id) {
            // calculate avg amount for each tender
            $tenderAvgQuery = " select avg(v.amount) as amount_avg from (
                            select 
                            sum(trx_template->>'$.amount') amount,
                            count(trx_template->>'$.amount') count
                            from voucher v where 
                                date(payment_date) >= '" . date("Y") . "-01-01'
                                and date(payment_date) < '" . date("Y-m-d") . "'
                            and status = 'COMPLETE'
                            and system_code != 'payment_voucher'
                            and trx_template->>'$.tender_id' = ?
                            group by month(payment_date)
                        ) as v";
            $tenderAvgResult = DBConnection::runBindDatabaseQuery($tenderAvgQuery, [$tender_id]);
            // calculate amount paid for the tender in target date
            $byTenderSqlQry = " SELECT sum(v.amount) as amount from(
                                SELECT date(payment_date) payment_date, t.manifest->>'$.name' tender_name, sum(trx_template->>'$.amount') amount
                                    FROM
                                        voucher v , tender_view t
                                    WHERE
                                        date(payment_date) >= ?
                                        and date(payment_date) < ?
                                        AND v.status = 'COMPLETE'
                                        AND trx_template->>'$.tender_id' = ?
                                        and trx_template->>'$.tender_id' = t.id
                                        and system_code != 'payment_voucher'
                                        GROUP BY date(payment_date) , t.manifest->>'$.name'
                                ) as v";
            $byTenderResult = DBConnection::runBindDatabaseQuery($byTenderSqlQry, [$date_from, $date_to, $tender_id]);
            if (sizeof($byTenderResult) == 0) {
                $result['_$_tender_' . $tender_id . '_$_'] = 0;
            } else {
                $result['_$_tender_' . $tender_id . '_$_'] = number_format($byTenderResult[0]->amount, 0);
            }
            $result['_$_tender_' . $tender_id . '_PERCENT_$_'] = $this->calculatePercentage($tenderAvgResult[0]->amount_avg, $byTenderResult[0]->amount);
            $result['_$_tender_' . $tender_id . '_AVG_$_'] = number_format($tenderAvgResult[0]->amount_avg, 0);
        }
 
        // generate bie chart  $tender_ids = [3,11,12,13];
        $byProjectPieChartData = [
            "البواخر" => str_replace(",", "", $result['_$_tender_3_$_']),
            "النفط_الخام" =>  str_replace(",", "", $result['_$_tender_11_$_']),
            "الفيول" => str_replace(",", "", $result['_$_tender_12_$_']),
            "التموين" => str_replace(",", "", $result['_$_tender_13_$_'])
        ];
        $project_method_url = "https://chartengine-beta-dot-waybill-project.uc.r.appspot.com/GeneratePieChart?data=" . json_encode($byProjectPieChartData);
        $response = $this->curl($project_method_url, "", "POST");
        $result['_$_TENDER_BASE64_$_'] = $response;

        dump($result);
        die;
        return $result;
    }
    public function calculatePercentage($amount1, $amount2)
    {
        $arrow_up =  "&#8679;";
        $arrow_down =  "&#8681;";
        if ($amount1 == 0 && $amount2 == 0) {
            $result = 0;
        } else if ($amount1 == 0 || $amount2 == 0) {
            $result = 100;
        } else {
            if ($amount1 <= $amount2) {
                $result = (1 - $amount1 / $amount2) * 100;
            } else {
                $result = (1 - $amount2 / $amount1) * 100;
            }
        }
        if ($amount2 <  $amount1)
            return '<p style="color:red;">' . $arrow_down . number_format($result, 0) . '%</p>';
        else
            return '<p style="color:green;">' . $arrow_up . number_format($result, 0) . '%</p>';
    }
    private function getIntegrationToken()
    {
        return 'zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg';
    }
    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}