<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
require_once('../includes/debug.php');
require_once('../includes/DBConnection.php');
require_once('../includes/util.php');
error_reporting(E_ALL);

DBConnection::getInstance();

// todo
$date_from = '2021-01-01';
$date_to = "2021-2-01";

////////////////////////////////////////////////////////////
/////////////// fitch trucks Per Ratio data //////////////////////
//////////////////////////////////////////////////////////
$trucksPerTripSqlQuery = "SELECT 
COUNT(tn) as number_of_trucks, cnt as number_of_trips
FROM 
(SELECT 
    COUNT(id) cnt, tn
FROM
    waybill_view
WHERE
    tender_id = 11
        AND create_date > ?
        AND create_date < ?
        AND status NOT IN ('INACTIVE' , 'REVOKED')
GROUP BY tn) AS t
GROUP BY cnt";
$trucksPerTripSqlQueryResult = DBConnection::runBindDatabaseQuery($trucksPerTripSqlQuery, [$date_from, $date_to]);

$total_trucks = 0;
$total_trips = 0;

// calculate totals 
foreach ($trucksPerTripSqlQueryResult as $trip) {
    $total_trucks = $total_trucks +  $trip->number_of_trucks;
    $total_trips = $total_trips + ($trip->number_of_trucks * $trip->number_of_trips);
}

// preparing the data from the data base 
$data_obj = new stdClass();
foreach ($trucksPerTripSqlQueryResult as &$trip) {
    $n_trip = $trip->number_of_trips . '-Trip';
    $n_trip_percent = $n_trip . '-percent';
    $trip->percent = ceil(round($trip->number_of_trucks / $total_trucks * 1000)) / 10;
    $data_obj->$n_trip = $trip->number_of_trucks;
    $data_obj->$n_trip_percent = $trip->percent;
}
$data_obj->total_trucks = $total_trucks;
$data_obj->total_trips = $total_trips;





////////////////////////////////////////////////////////////
/////////////// fitch indivisual Ratio data //////////////////////
//////////////////////////////////////////////////////////

$indivisualRatioSqlQuery = 'select date_format(loading_date,"%m %Y") date, (CASE
WHEN w.truck_owner_id =410080 THEN "indivisual"
WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN "company"
ELSE "indivisual"
END) owner, count(distinct truck_id) trucks, count(*) trips
from waybill w
where w.tender_id=11 and w.status not in("inactive","revoked") #and w.truck_owner_id=410080
and w.loading_date > ? and w.loading_date < ?
and w.loading_date is not null
group by (CASE
WHEN w.truck_owner_id =410080 THEN "indivisual"
WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN "company"
ELSE "indivisual"
END),date_format(loading_date,"%m %Y"),date_format(loading_date,"%Y%m")
order by date_format(loading_date,"%Y%m"),owner';
$indivisualRatioSqlQueryResult = DBConnection::runBindDatabaseQuery($indivisualRatioSqlQuery, [$date_from, $date_to]);


$t_trucks = 0;
$t_trips = 0;
// calculate total  
foreach ($indivisualRatioSqlQueryResult as $trip) {
    $t_trucks = $t_trucks +  $trip->trucks;
    $t_trips = $t_trips + $trip->trips;
}

$data = new stdClass();
foreach ($indivisualRatioSqlQueryResult as &$trip) {
    if ($trip->owner == "indivisual") {
        $trip->indivisual_truck_ration = ceil(round($trip->trucks / $t_trucks * 1000)) / 10;
        $trip->indivisual_trip_ration = ceil(round($trip->trips / $t_trips * 1000)) / 10;
        $trip->date = "01-" .  $trip->date;
        $data->indivisual = $trip;
    } else {
        $trip->company_truck_ration = ceil(round($trip->trucks / $t_trucks * 1000)) / 10;
        $trip->company_trip_ration = ceil(round($trip->trips / $t_trips * 1000)) / 10;
        $trip->date = "01-" .  $trip->date;
        $data->company = $trip;
    }
}

$final_data = new stdClass();
$final_data->trucks_per_Trip = $data_obj;
$final_data->ratio = $data;
$final_data = json_encode($final_data);
$insert_sql = " INSERT INTO `waybill`.`jo_petrol_dashboard_2` (`tender_id`,`group_by`,  `from_date`, `to_date`, `details`, `status`, `update_by`) VALUES (?,?,?,?,?,?,?)";
// echo ($insert_sql);
// die;

// echo ("asdas");
// die;
DBConnection::runBindDatabaseQuery($insert_sql, [11, "YEARLY", $date_from, $date_to, $final_data, 'ACTIVE', 0]);
echo ("SUCCESS");
dump($final_data);
die;
