<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
require_once(dirname(__FILE__) . "/../../../includes/DBConnection.php");


class generate_jo_petrol
{
    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for customer care System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken()
    {
        return 'zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg';
    }
    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }

    
    public function Fetch()
    {

        // run some database queries to generate the raw data of the news letter and save it in database
        $generate_date_from = date('Y-m-01', strtotime("-1 month"));
        $generate_date_to   = date('Y-m-01');
        $this->generateJoPetrolData($generate_date_from, $generate_date_to);

        // use the data which is generated in previous step and format it
        $date_from = date('Y-m-01',strtotime("-2 month"));
        $date_to   = date('Y-m-01');
        $group_by = "MONTHLY";
        DBConnection::getInstance();
        $searchJoPetrolSqlQry = "SELECT
            id , from_date , to_date ,  CAST(details AS CHAR CHARSET UTF8) AS details
            FROM
                 jo_petrol_dashboard_2
            WHERE
               date(from_date) >= ?
               AND date(to_date) <= ?
               AND group_by = ?";
        $searchJoPetrolQry = DBConnection::runBindDatabaseQuery($searchJoPetrolSqlQry, [$date_from, $date_to, $group_by]);
        $result = [];

        // header date
        $result['_$_MONTH_$_'] = substr(json_decode($searchJoPetrolQry[1]->details)->ratio->company->date, 3);
        $result['_$_PRE_MONTH_$_'] =date('Y-m',strtotime("-2 month"));;

        // preparing part one 
        $one_trip = "1-Trip";
        $one_trip_percent = "1-Trip-percent";
        if (json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$one_trip) {
            $result['_$_ONE_TRIP_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$one_trip;
            $result['_$_ONE_TRIP_PERCENT_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$one_trip_percent;
        } else {
            $result['_$_ONE_TRIP_$_'] = 0;
            $result['_$_ONE_TRIP_PERCENT_$_'] = 0;
        }
        $two_trip = "2-Trip";
        $two_trip_percent = "2-Trip-percent";
        if (json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$two_trip) {
            $result['_$_TWO_TRIP_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$two_trip;
            $result['_$_TWO_TRIP_PERCENT_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$two_trip_percent;
        } else {
            $result['_$_TWO_TRIP_$_'] = 0;
            $result['_$_TWO_TRIP_PERCENT_$_'] = 0;
        }
        $three_trip = "3-Trip";
        $three_trip_percent = "3-Trip-percent";
        if (json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$three_trip) {
            $result['_$_THREE_TRIP_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$three_trip;
            $result['_$_THREE_TRIP_PERCENT_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->$three_trip_percent;
        } else {
            $result['_$_THREE_TRIP_$_'] = 0;
            $result['_$_THREE_TRIP_PERCENT_$_'] = 0;
        }
        // totals percentage 
        $result['_$_TOTAL_TRIPS_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->total_trips;
        $result['_$_TOTAL_TRUCKS_$_'] = json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->total_trucks;
        $total_truck_percent = ((json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->total_trucks / json_decode($searchJoPetrolQry[0]->details)->trucks_per_Trip->total_trucks) - 1) * 100;
        $total_trip_percent = ((json_decode($searchJoPetrolQry[1]->details)->trucks_per_Trip->total_trips / json_decode($searchJoPetrolQry[0]->details)->trucks_per_Trip->total_trips) - 1) * 100;
        // preparing part 2  
        $arrow_up = "&#8679;";
        $arrow_down =  "&#8681;";
        if ($total_truck_percent > 0) {
            $truck_percent_img = $arrow_up;
            $result['_$_TOTAL_TRUCK_PERCENT_$_'] = '<p style="color:green;">' .  $truck_percent_img . (number_format($total_truck_percent, 2) . " %") . '</p>';
        } else {
            $truck_percent_img = $arrow_down;
            $total_truck_percent = abs($total_truck_percent);
            $result['_$_TOTAL_TRUCK_PERCENT_$_'] = '<p style="color:red;">' .  $truck_percent_img . (number_format($total_truck_percent, 2) . " %") . '</p>';
        }
        if ($total_trip_percent > 0) {
            $trip_percent_img = $arrow_up;
            $result['_$_TOTAL_TRIPS_PERCENT_$_'] = '<p style="color:green;">' .  $trip_percent_img . "  " . (number_format($total_trip_percent, 2) . " %") . '</p>';
        } else {
            $trip_percent_img = $arrow_down;
            $total_trip_percent = abs($total_trip_percent);
            $result['_$_TOTAL_TRIPS_PERCENT_$_'] = '<p style="color:red;">' .  $trip_percent_img  . "  " . (number_format($total_trip_percent, 2) . " %") . '</p>';
        }
        
        
        // indivisual 
        $result['_$_IND_TRUCKS_$_'] = json_decode($searchJoPetrolQry[1]->details)->ratio->indivisual->trucks;
        $result['_$_IND_TRUCKS_PERCENT_$_'] =  json_decode($searchJoPetrolQry[1]->details)->ratio->indivisual->indivisual_truck_ration . " %";
        $result['_$_IND_TRIPS_$_'] = json_decode($searchJoPetrolQry[1]->details)->ratio->indivisual->trips;
        $result['_$_IND_TRIPS_PERCENT_$_'] =  json_decode($searchJoPetrolQry[1]->details)->ratio->indivisual->indivisual_trip_ration . " %";
       
         // company 
        $result['_$_COMP_TRUCKS_$_'] = json_decode($searchJoPetrolQry[1]->details)->ratio->company->trucks;
        $result['_$_COMP_TRUCKS_PERCENT_$_'] =  json_decode($searchJoPetrolQry[1]->details)->ratio->company->company_truck_ration . " %";
        $result['_$_COMP_TRIPS_$_'] = json_decode($searchJoPetrolQry[1]->details)->ratio->company->trips;
        $result['_$_COMP_TRIPS_PERCENT_$_'] = json_decode($searchJoPetrolQry[1]->details)->ratio->company->company_trip_ration . " %"; 

        $data = ["رحلة_واحدة" => $result['_$_ONE_TRIP_$_'], "رحلتين" =>  $result['_$_TWO_TRIP_$_'], "ثلاث_رحلات" => $result['_$_THREE_TRIP_$_']];
        $url = "https://chartengine-dot-waybill-project.uc.r.appspot.com/GeneratePieChart?data=" . json_encode($data);
        $response = $this->curl($url, "", "POST");
        $result['_$_BASE64_$_'] = $response;

        return $result;
    }


    public function generateJoPetrolData($date_from, $date_to)
    {

        ////////////////////////////////////////////////////////////
        /////////////// fitch trucks Per Ratio data //////////////////////
        //////////////////////////////////////////////////////////
        $trucksPerTripSqlQuery = "SELECT
            COUNT(tn) as number_of_trucks, cnt as number_of_trips
            FROM
            (SELECT
                COUNT(id) cnt, tn
            FROM
                waybill_view
            WHERE
                tender_id = 11
                    AND create_date > ?
                    AND create_date < ?
                    AND status NOT IN ('INACTIVE' , 'REVOKED')
            GROUP BY tn) AS t
            GROUP BY cnt";
        $trucksPerTripSqlQueryResult = DBConnection::runBindDatabaseQuery($trucksPerTripSqlQuery, [$date_from, $date_to]);

        $total_trucks = 0;
        $total_trips = 0;

        // calculate totals
        foreach ($trucksPerTripSqlQueryResult as $trip) {
            $total_trucks = $total_trucks +  $trip->number_of_trucks;
            $total_trips = $total_trips + ($trip->number_of_trucks * $trip->number_of_trips);
        }

        // preparing the data from the data base
        $data_obj = new stdClass();
        foreach ($trucksPerTripSqlQueryResult as &$trip) {
            $n_trip = $trip->number_of_trips . '-Trip';
            $n_trip_percent = $n_trip . '-percent';
            $trip->percent = ceil(round($trip->number_of_trucks / $total_trucks * 1000)) / 10;
            $data_obj->$n_trip = $trip->number_of_trucks;
            $data_obj->$n_trip_percent = $trip->percent;
        }
        $data_obj->total_trucks = $total_trucks;
        $data_obj->total_trips = $total_trips;


        ////////////////////////////////////////////////////////////
        /////////////// fitch indivisual Ratio data //////////////////////
        //////////////////////////////////////////////////////////

        $indivisualRatioSqlQuery = 'select date_format(loading_date,"%m %Y") date, (CASE
            WHEN w.truck_owner_id =410080 THEN "indivisual"
            WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN "company"
            ELSE "indivisual"
            END) owner, count(distinct truck_id) trucks, count(*) trips
            from waybill w
            where w.tender_id=11 and w.status not in("inactive","revoked") #and w.truck_owner_id=410080
            and w.loading_date > ? and w.loading_date < ?
            and w.loading_date is not null
            group by (CASE
            WHEN w.truck_owner_id =410080 THEN "indivisual"
            WHEN mid(w.truck_owner_id,1,2) = 41 and w.truck_owner_id !=410080 THEN "company"
            ELSE "indivisual"
            END),date_format(loading_date,"%m %Y"),date_format(loading_date,"%Y%m")
            order by date_format(loading_date,"%Y%m"),owner';
        $indivisualRatioSqlQueryResult = DBConnection::runBindDatabaseQuery($indivisualRatioSqlQuery, [$date_from, $date_to]);


        $t_trucks = 0;
        $t_trips = 0;
        // calculate total
        foreach ($indivisualRatioSqlQueryResult as $trip) {
            $t_trucks = $t_trucks +  $trip->trucks;
            $t_trips = $t_trips + $trip->trips;
        }

        $data = new stdClass();
        foreach ($indivisualRatioSqlQueryResult as &$trip) {
            if ($trip->owner == "indivisual") {
                $trip->indivisual_truck_ration = ceil(round($trip->trucks / $t_trucks * 1000)) / 10;
                $trip->indivisual_trip_ration = ceil(round($trip->trips / $t_trips * 1000)) / 10;
                $trip->date = "01-" .  $trip->date;
                $data->indivisual = $trip;
            } else {
                $trip->company_truck_ration = ceil(round($trip->trucks / $t_trucks * 1000)) / 10;
                $trip->company_trip_ration = ceil(round($trip->trips / $t_trips * 1000)) / 10;
                $trip->date = "01-" .  $trip->date;
                $data->company = $trip;
            }
}

        $final_data = new stdClass();
        $final_data->trucks_per_Trip = $data_obj;
        $final_data->ratio = $data;
        $final_data = json_encode($final_data);
        $insert_sql = " INSERT INTO `waybill`.`jo_petrol_dashboard_2` (`tender_id`,`group_by`,  `from_date`, `to_date`, `details`, `status`, `update_by`) VALUES (?,?,?,?,?,?,?)";

        DBConnection::runBindDatabaseQuery($insert_sql, [11, "MONTHLY", $date_from, $date_to, $final_data, 'ACTIVE', 0]);
    }
}
