<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
require_once(dirname(__FILE__) . "/../../../includes/util.php");
require_once(dirname(__FILE__) . "/../../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../../core/tender/tender_core.php");

error_reporting(E_ALL);

class generate_daily_finance
{
    public function Fetch()
    {

        $target_date   = date('Y-m-d', strtotime("-1 day"));
        DBConnection::getInstance();
        $fps = new FPS();
        $result = [];
        $tender_ids = [3, 11, 12, 13, 53];

        // title
        $result['_$_DAY_$_'] = $target_date;

        // مجموع المبالغ المدفوعة ومجموع المستفيدين
        $tender_ids_string = implode(', ', $tender_ids);

        // calculate average amount during current year from vouchers
        $avgQuery = " select avg(v.amount) as amount_avg , avg(v.count) count_avg from (
                        select 
                        sum(trx_template->>'$.amount') amount,
                        count(trx_template->>'$.amount') count
                        from voucher v where 
                            date(payment_date) >= '" . date("Y") . "-01-01'
                            and date(payment_date) < '" . date("Y-m-d") . "'
                            and status = 'COMPLETE'
                            and trx_template->>'$.tender_id' in (3,11,12,13)
                        and (system_code != 'payment_voucher' or system_code is null)
                            group by date(payment_date)
                    ) as v";
        $avgResult = DBConnection::runBindDatabaseQuery($avgQuery, []);

        // calculate average amount during current year from fps.vouchers
        $filter = ['payment_date_from' => date("Y") . "-01-01", 'status' => 'COMPLETE'];
        $data = new stdClass();
        $data->filter = json_encode($filter);
        $fpsVoucherResult = $fps->searchVouchers($data, 0);

        $fpsVoucherAmounts = [];
        $fpsVoucherCounts = [];
        foreach ($fpsVoucherResult['data'] as $fpsVoucher) {
            $currentDate = date_format(date_create($fpsVoucher['create_date']), 'Y-m-d');
            $fpsVoucherAmounts[$currentDate] += $fpsVoucher['amount'];
            $fpsVoucherCounts[$currentDate]++;
        }

        $fpsVoucherAmountAvg = array_sum(array_values($fpsVoucherAmounts)) / count($fpsVoucherAmounts);
        $fpsVoucherCountAvg = array_sum($fpsVoucherCounts) / count($fpsVoucherCounts);

        $voucher_amount_avg = ($avgResult[0]->amount_avg + $fpsVoucherAmountAvg) / 2;
        $voucher_count_avg = ($avgResult[0]->count_avg + $fpsVoucherCountAvg) / 2;


        $totalSqlQry = "select date(payment_date) payment_date, 
                sum(trx_template->>'$.amount') amount,
                count(id) as total_voucher
                from voucher where 
                date(payment_date) = ?
                and status = 'COMPLETE'
                and trx_template->>'$.tender_id' in ($tender_ids_string )
                and (system_code != 'payment_voucher' or system_code is null)
                group by date(payment_date)
         ";
        $totalResult = DBConnection::runBindDatabaseQuery($totalSqlQry, [$target_date]);

        // get the statiscts from fps also
        $filter = ['payment_date' => $target_date, 'status' => 'COMPLETE'];
        $data = new stdClass();
        $data->filter = json_encode($filter);
        $fpsVoucherResult2 = $fps->searchVouchers($data, 0);
        $fpsTotalAmount = 0;
        foreach ($fpsVoucherResult2['data'] as $fpsVoucher) {
            $fpsTotalAmount += $fpsVoucher['amount'];
        }
        $totalAmount = $totalResult[0]->amount + $fpsTotalAmount;
        $totalVouchers = $totalResult[0]->total_voucher + $fpsVoucherResult2['found_rows'];

        $result['_$_TOTAL_AMOUNT_$_'] = number_format($totalAmount, 0);
        $result['_$_TOTAL_AMOUNT_PERCENT_$_'] = $this->calculatePercentage($voucher_amount_avg, $totalAmount);
        $result['_$_TOTAL_AMOUNT_AVG_$_'] = number_format($voucher_amount_avg, 0);
        $result['_$_TOTAL_VOUCHERS_$_'] = $totalVouchers;
        $result['_$_TOTAL_VOUCHERS_PERCENT_$_'] = $this->calculatePercentage($voucher_count_avg, $totalVouchers);
        $result['_$_TOTAL_VOUCHERS_AVG_$_'] = number_format($voucher_count_avg, 0);




        // المبالغ المدفوعة حسب طريقة الدفع        
        $payment_methods = ['CASH', 'ZAIN_CASH', 'CHECK'];

        foreach ($payment_methods as $method) {
            $byPaymentMethodSqlQry = "SELECT 
                        date(payment_date) payment_date , payment_method, sum(trx_template->>'$.amount') amount
                    FROM
                        voucher v
                    WHERE
                        date(payment_date) = ?
                            AND status = 'COMPLETE'
                            and payment_method = ?
                            AND trx_template->>'$.tender_id' in ( $tender_ids_string )
                            and (system_code != 'payment_voucher' or system_code is null)
                    GROUP BY date(payment_date) , payment_method ";

            $byPaymentMethodResult = DBConnection::runBindDatabaseQuery($byPaymentMethodSqlQry, [$target_date, $method]);

            $byPaymentMethodAvgSqlQry =  "select avg(v.amount) as amount_avg , avg(v.count) count_avg from (
                    select 
                    sum(trx_template->>'$.amount') amount,
                    count(trx_template->>'$.amount') count
                    from voucher v where 
                    date(payment_date) >= '" . date("Y") . "-01-01'
                    and date(payment_date) < '" . date("Y-m-d") . "'
                    and status = 'COMPLETE'
                    and trx_template->>'$.tender_id' in ($tender_ids_string)
                    and payment_method = ?
                    and (system_code != 'payment_voucher' or system_code is null)
                    group by date(payment_date)
                    ) as v";

            $byPaymentMethodAvgResult = DBConnection::runBindDatabaseQuery($byPaymentMethodAvgSqlQry, [$method]);

            if (sizeof($byPaymentMethodResult) == 0) {
                $result['_$_' . $method . '_$_'] = 0;
            } else {
                $result['_$_' . $method . '_$_'] = number_format($byPaymentMethodResult[0]->amount, 0);
            }


            // inject data from fps
            $paymentMethodfpsVoucherAmounts = [];
            foreach ($fpsVoucherResult2['data'] as $fpsVoucher) {
                if ($fpsVoucher['payment_method_code'] == $method) {
                    if (sizeof($byPaymentMethodResult) == 0) {
                        $byPaymentMethodResult[] = new stdClass();
                    }
                    $byPaymentMethodResult[0]->amount += $fpsVoucher['amount'];
                    $result['_$_' . $method . '_$_'] += $fpsVoucher['amount'];
                    $paymentMethodfpsVoucherAmounts[] = $fpsVoucher['amount'];
                }
            }

            if (count($paymentMethodfpsVoucherAmounts)) {

                if (!$byPaymentMethodAvgResult[0]->amount_avg) $byPaymentMethodAvgResult[0]->amount_avg = 0;
                $byPaymentMethodAvgResult[0]->amount_avg = ($byPaymentMethodAvgResult[0]->amount_avg + array_sum($paymentMethodfpsVoucherAmounts) / count($paymentMethodfpsVoucherAmounts)) / 2;
            }

            $result['_$_' . $method . '_PERCENT_$_'] =  $this->calculatePercentage($byPaymentMethodAvgResult[0]->amount_avg, $byPaymentMethodResult[0]->amount);
            $result['_$_' . $method . '_AVG_$_'] =   number_format($byPaymentMethodAvgResult[0]->amount_avg, 0);
        }

        // generate bie chart
        $byMethodPieChartData = [
            "كاش" => str_replace(",", "", $result['_$_CASH_$_']),
            "زين_كاش" =>  str_replace(",", "", $result['_$_ZAIN_CASH_$_']),
            "شيكات" => str_replace(",", "", $result['_$_CHECK_$_'])
        ];
        $payment_method_url = "https://chartengine-beta-dot-waybill-project.uc.r.appspot.com/GeneratePieChart?data=" . json_encode($byMethodPieChartData);


        $response = $this->curl($payment_method_url, "", "POST");
        $result['_$_PAYMENT_METHOD_BASE64_$_'] = $response;

        // المبالغ المدفوعة حسب المشاريع        
        foreach ($tender_ids as $tender_id) {

            // calculate avg amount for each tender
            $tenderAvgQuery = " select avg(v.amount) as amount_avg from (
                            select 
                            sum(trx_template->>'$.amount') amount,
                            count(trx_template->>'$.amount') count
                            from voucher v where 
                                date(payment_date) >= '" . date("Y") . "-01-01'
                                and date(payment_date) < '" . date("Y-m-d") . "'
                            and status = 'COMPLETE'
                            and (system_code != 'payment_voucher' or system_code is null)
                            and trx_template->>'$.tender_id' = ?
                            group by date(payment_date)
                        ) as v";
            $tenderAvgResult = DBConnection::runBindDatabaseQuery($tenderAvgQuery, [$tender_id]);

            // calculate amount paid for the tender in target date
            $byTenderSqlQry = "SELECT 
                                date(payment_date) payment_date, t.manifest->>'$.name' tender_name, sum(trx_template->>'$.amount') amount
                                FROM
                                voucher v , tender_view t
                                WHERE
                                    date(payment_date) = ? 
                                    AND v.status = 'COMPLETE'
                                    AND trx_template->>'$.tender_id' = ?
                                    and trx_template->>'$.tender_id' = t.id
                and (system_code != 'payment_voucher' or system_code is null)
                                GROUP BY date(payment_date) , t.manifest->>'$.name';";

            $byTenderResult = DBConnection::runBindDatabaseQuery($byTenderSqlQry, [$target_date, $tender_id]);
            if (sizeof($byTenderResult) == 0) {
                $result['_$_tender_' . $tender_id . '_$_'] = 0;
            } else {
                $result['_$_tender_' . $tender_id . '_$_'] = number_format($byTenderResult[0]->amount, 0);
            }


            // المبالغ المدفوعة حسب tender_id in FPS
            $fpsVoucherAmounts = [];
            foreach ($fpsVoucherResult2['data'] as $fpsVoucher) {
                $details = json_decode($fpsVoucher['details']);
                $fps_tender_id = $details->tender_id;

                if ($fps_tender_id == $tender_id) {
                    $result['_$_tender_' . $tender_id . '_$_'] += $fpsVoucher['amount'];
                    $byTenderResult[0]->amount += $fpsVoucher['amount'];

                    $fpsVoucherAmounts[] = $fpsVoucher['amount'];
                }
            }

            if (count($fpsVoucherAmounts)) {
                $tenderAvgResult[0]->amount_avg += array_sum($fpsVoucherAmounts) / count($fpsVoucherAmounts);
            }

            $result['_$_tender_' . $tender_id . '_$_'] = number_format($result['_$_tender_' . $tender_id . '_$_'], 0);
            $result['_$_tender_' . $tender_id . '_PERCENT_$_'] = $this->calculatePercentage($tenderAvgResult[0]->amount_avg, $byTenderResult[0]->amount);
            $result['_$_tender_' . $tender_id . '_AVG_$_'] = number_format($tenderAvgResult[0]->amount_avg, 0);
        }


       
        // المبالغ المدفوعة حسب pa_projects
        $paProjectVoucher = [];
        foreach ($fpsVoucherResult2['data'] as $fpsVoucher) {
            $details = json_decode($fpsVoucher['details']);
            if ($details->pa_project_id) {
                $pa_project_id = $details->pa_project_id;
                $paProjectVoucher[$pa_project_id][] = $fpsVoucher['amount'];
            }
        }

        foreach ($paProjectVoucher as $pa_project_id => $paVouchers) {

            $filter = ['pa_project_id' => $pa_project_id, 'status' => 'COMPLETE'];
            $data = new stdClass();
            $data->filter = json_encode($filter);
            $pa_project_fpsVoucherResult = $fps->searchVouchers($data, 0);
           
            $pa_sum = 0;
            foreach ($pa_project_fpsVoucherResult['data'] as $pa_result) {
                $pa_sum += $pa_result['amount'];
            }

            $pa_avg_total = $pa_sum / $pa_project_fpsVoucherResult['found_rows'];

            $voucherSumForThisProject = array_sum($paVouchers);
            $result['_$_tender_' . $pa_project_id . '_$_'] = $voucherSumForThisProject;
            $result['_$_tender_' . $pa_project_id . '_PERCENT_$_'] = $this->calculatePercentage($pa_avg_total, $voucherSumForThisProject);  // percentage of how much this day from total for this pa_project
            $result['_$_tender_' . $pa_project_id . '_AVG_$_'] =  number_format($pa_avg_total,0);     // TODO
        }
 

        // المبالغ المدفوعة التي لا تتبع مشروع


        // generate bie chart  $tender_ids = [3,11,12,13];
        $byProjectPieChartData = [
            "البواخر" => str_replace(",", "", $result['_$_tender_3_$_']),
            "النفط_الخام" =>  str_replace(",", "", $result['_$_tender_11_$_']),
            "الفيول" => str_replace(",", "", $result['_$_tender_12_$_']),
            "التموين" => str_replace(",", "", $result['_$_tender_13_$_']),
            "نترات-الأمونيوم" => str_replace(",", "", $result['_$_tender_53_$_'])
        ];
        $project_method_url = "https://chartengine-beta-dot-waybill-project.uc.r.appspot.com/GeneratePieChart?data=" . json_encode($byProjectPieChartData);
        $response = $this->curl($project_method_url, "", "POST");
        $result['_$_TENDER_BASE64_$_'] = $response;
        dump($result);
        die;
        return $result;
    }

    public function calculatePercentage($amount1, $amount2)
    {

        $arrow_up =  "&#8679;";
        $arrow_down =  "&#8681;";

        if ($amount1 == 0 && $amount2 == 0) {
            $result = 0;
        } else if ($amount1 == 0 || $amount2 == 0) {
            $result = 100;
        } else {
            if ($amount1 <= $amount2) {
                $result = (1 - $amount1 / $amount2) * 100;
            } else {
                $result = (1 - $amount2 / $amount1) * 100;
            }
        }

        if ($amount2 <  $amount1)
            return '<p style="color:red;">' . $arrow_down . number_format($result, 0) . '%</p>';
        else
            return '<p style="color:green;">' . $arrow_up . number_format($result, 0) . '%</p>';
    }


    private function getIntegrationToken()
    {
        return 'zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg';
    }
    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields, $method)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: ' . $this->getIntegrationToken(),
            'Accept: application/json'
        ));
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            throw new Exception("Error Processing Request : " . $result, 1);
        }
        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }
}
