<?php
// echo !extension_loaded('openssl') ? "Not Available" : "Available";
// use PHPMailer\PHPMailer\PHPMailer;
// use PHPMailer\PHPMailer\SMTP;
// use PHPMailer\PHPMailer\Exception;

// use google\appengine\api\mail\Message;

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes

// include files

// require_once __DIR__ . '/../../../vendor/autoload.php';
require_once(dirname(__FILE__) . "/../../core/API.php");
require_once(dirname(__FILE__) . "/generate_script/generate_jo_petrol.php");
require_once(dirname(__FILE__) . "/generate_script/generate_daily_finance.php");
require_once(dirname(__FILE__) . "/generate_script/generate_monthly_finance.php");
require_once(dirname(__FILE__) . "/generate_script/generate_container_report.php");
require_once(dirname(__FILE__) . "/generate_script/generate_ca_email_single.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");


class Engine
{

    private $generate_jo_petrol;
    private $generate_daily_finance;
    private $generate_monthly_finance;
    private $generate_container_report;
    private $generate_ca_email_single;

    // ---------------------------------------------------------------- //
    // --------- prepare news letter and send the email --------------- //
    // ---------------------------------------------------------------- //
    public function prepareNewsLetter($newsletter_id, $details = null){

        $this->generate_jo_petrol = new generate_jo_petrol();
        $this->generate_daily_finance = new generate_daily_finance();
        $this->generate_monthly_finance = new generate_monthly_finance();
        $this->generate_container_report = new generate_container_report();
        $this->generate_ca_email_single = new generate_ca_email_single();

        // 1. call(search) db to get newsletter rec
        $SearchNewLetterQry = "
            SELECT
                id,
                html_template,
                CAST(`recipients` AS CHAR CHARSET UTF8) AS recipients,
                newsletter_subject,
                generate_script,
                notes,
                sender_email,
                sender_password
            FROM
                newsletter
            where
                status = 'ACTIVE'
                and id = ?";

        // get the data from db
        $SearchNewLetterCallQry = DBConnection::runBindDatabaseQuery($SearchNewLetterQry, [$newsletter_id]);
 
        // 2. loop over newsletter form step 1
        foreach ($SearchNewLetterCallQry as  $value1) {
            $recipients = json_decode($value1->recipients);
            $html_template = $value1->html_template;

            $text = $html_template;
            $script_name = $value1->generate_script;
            if($details){
                $fetchData = $this->$script_name->Fetch($details);
            }else{
                $fetchData = $this->$script_name->Fetch();
            }

            if($recipients[0] == "ca_mail"){
                $recipients = $details->email;
            }

            //inject fetched values
            foreach ($fetchData as $key => $value) {
                $text =  str_replace($key, $value, $text);
                $value1->newsletter_subject = str_replace($key, $value, $value1->newsletter_subject);
            }

            $sender_email = $value1->sender_email;
            $subject = $value1->newsletter_subject;

            dump($recipients);die;

        
            // $mail = new Message();

            // try {

            //     $mail->setSender($sender_email);
            //     $mail->addTo($recipients);
            //     $mail->setSubject($subject);
            //     $mail->setHtmlBody($text);
            //     $mail->send();

            //     echo 'Message has been sent';

            // } catch (Exception $e) {
            //     // echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
            //     dump($e);
            // }
        }
    }
}
