<?php
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once('../includes/util.php');
require_once(dirname(__FILE__) . "/../core/waybill/waybill_core.php");

DBConnection::getInstance();
$waybillCore = new WaybillCore();

$filePath = 'json/emeral_sheet.csv';
$startRow = 2;
$limit = $startRow + 200;
$csv = parseCsvFile($filePath, $startRow, $limit);
$result = [];

$file = 'result.txt';

foreach ($csv as $truck) {

    try {


        // ----------------------------- prepare data -----------------------------------        
        $create_date_original = str_replace("/", "-", $truck[0]);
        $create_date_original = preg_replace("/(\d+)\D+(\d+)\D+(\d+)/", "$3-$1-$2", $create_date_original);
        $create_date = date('Y-m-d', strtotime('-1 day', strtotime($create_date_original)));
        $create_date_to = date('Y-m-d', strtotime(strtotime($create_date_original)));

        $tn = str_replace("-", "", $truck[5]);
        $driver_name = $truck[6];
        $bond_number = $truck[3];
        $loading_weight = $truck[4];
        $shift = $truck[8];

        // search for waybill for this truck in the givven date
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => 3],
            ['key' => 'create_date', 'val' => $create_date, 'op' => 'date greater than'],
            ['key' => 'create_date', 'val' => $create_date_original, 'op' => 'date less than']
        ];
        $waybills = $waybillCore->searchWaybills($waybillFilter, 1, 0, 0);
 
        // check if the waybill has loading weight or not
        if ($waybills->found_rows > 0) {
            $waybillBean = $waybills->data[0];

            $doc = json_decode($waybillBean->document);
            $net_weight = $doc->cargo[0]->weights->loading->net_weight;

            if ($net_weight) {
                continue;
            }

            // in case no loading weight is found , push this record into result
            $hasError = new stdClass();
            file_put_contents($file, $tn . "," , FILE_APPEND);
            file_put_contents($file, $waybillBean->wn . ",", FILE_APPEND);
            file_put_contents($file, $create_date_original . ",", FILE_APPEND);
            file_put_contents($file, $loading_weight . ",", FILE_APPEND);
            file_put_contents($file, $bond_number . ",", FILE_APPEND);
            file_put_contents($file, $shift . ",", FILE_APPEND);
            file_put_contents($file, "\n", FILE_APPEND);
 
        }else{
            echo $tn . "-";
        }
    } catch (Exception $e) {
        dump($e);
        die;
    }
}
 