<?php
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once ('../includes/util.php');
DBConnection::getInstance();

$filePath = 'json/fuel_report.csv';
$startRow = 14009;
$limit = $startRow + 1000;
$result = parseCsvFile($filePath,$startRow,$limit);
$rows = [];
$insert_query = "INSERT INTO waybill.diesel_log(diesel_date, tn, station, unit_price, quantity, total) values ";
 
$insertResult = [];

foreach ($result as $truck) {

    try{        
        // ----------------------------- prepare data -----------------------------------        
        $diesel_date = $truck[0];
        $tn = str_replace("-","",$truck[1]);
        $station = $truck[4];        
        $unit_price = $truck[7];
        $quantity = $truck[8];
        $total = $truck[9];

        if(!$tn || !$total){
            continue;
        }

        // validate if the record is already saved in database
        $db_query = "select id from waybill.diesel_log where tn = ? and diesel_date=? and total=?";
        $param = [$tn, $diesel_date, $total];
        $res = DBConnection::runBindDatabaseQuery($db_query, $param);
        if(sizeof($res) > 0){
            continue;
        }

        $date = new DateTime($diesel_date);
        $diesel_date = $date->format("Y-m-d H:i:s");

        // prepare 100 rows

        if(sizeof($rows) >= 100){
            // insert into table            
            $insert_query = rtrim($insert_query,",");
            $res = DBConnection::runBindDatabaseQuery($insert_query, []);

            $insertResult[] = $insert_query;

            // reset it
            $rows = [];
            $insert_query = "INSERT INTO waybill.diesel_log(diesel_date, tn, station, unit_price, quantity, total) values ";

        }else{
            $rows[] = [$diesel_date, $tn, $station, $unit_price,$quantity,  $total];
            $insert_query .= " ('$diesel_date', $tn, '$station', $unit_price,$quantity,  $total),";
        }
    }
    catch (Exception $e){
    }
}


if(sizeof($rows) > 0){
    $insert_query = rtrim($insert_query,",");
    $insertResult[] = $insert_query;
}


dump($insertResult);

echo "finish";