<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once (dirname(__FILE__)."/../core/outgoing_integration/zain_cash.php");
require_once ('../includes/util.php');


// prepare Database connection
$host = '104.198.184.139'; 
$db   = 'zain_cash';
$user = 'zc';
$pass = 'BywVDQaYwGHZ6kpe';
$charset = 'utf8mb4';
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => true,
];
$dsn = "mysql:host=$host;port=3306;dbname=$db;charset=$charset";
$db = new PDO($dsn, $user, $pass, $options);

// init obj
$zain_cash = new Zain_cash();

// get user params
$from_time = "2020-10-01 00:00:00";
$fromTime = date_format(date_create($from_time),"Y-m-d");
$to_time = "2020-11-01 00:00:00";
$toTime = date_format(date_create($to_time),"Y-m-d");


// get zain trx
$wallet_id = 'fuel';
$transactions = $zain_cash->getCorpSOATrx($wallet_id, $fromTime,$toTime);
  
// insert into DB
foreach ($transactions['RESULT'] as $trx) {

    try{

        $old_date = DateTime::createFromFormat('m/d/Y h:i:s a', $trx['DateTime']);
        $trx_date =  $old_date->format('Y-m-d H:i:s');

        $query = "insert into zain_cash.zain_cash_log (Accname, BALANCE_After , BALANCE_Before , Credit , DateTime , Debit , OTHER_PARTY,  Receiverinfo, Transaction_Desc, Transaction_Type, Reference,Senderinfo,wallet_id) 
        values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        $param = [$trx['Accname'] ,
                  doubleval($trx['BALANCE_After']) , 
                  doubleval($trx['BALANCE_Before']) ,
                  doubleval($trx['Credit']), 
                  $trx_date , 
                  doubleval($trx['Debit']), 
                  $trx['OTHER_PARTY'], 
                  $trx['Receiverinfo'], 
                  $trx['Transaction_Desc'], 
                  $trx['Transaction_Type'],
                  $trx['Reference'], 
                  $trx['Senderinfo'],
                  $wallet_id];
 
            $stmt = $db->prepare($query);
            $stmt->execute($param);
            $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
               
    }
    catch(Exception $e){}
    

            
}
