<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once('../includes/util.php');
require_once('../includes/debug.php');
require_once(dirname(__FILE__) . "/../core/company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../core/account/account_core.php");

$clearingAgentCore = new ClearingAgentCore();
$accountCore = new AccountCore();

// parse json
$ca_json = file_get_contents("json/ca.json");
$ca_arr = json_decode($ca_json)->ca;

$index = 0;

foreach ($ca_arr as $ca_obj) {

    try {

        $index++;
 
            // check if ca is already exists
            $caFilter = [['key'=>'id','val' =>$ca_obj->id],
                        ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                        ];
            $clearing_agent_result = $clearingAgentCore->searchClearingAgent($caFilter,1,0,0);

            if($clearing_agent_result->found_rows > 0){
                continue;
            }
 
            DBConnection::startTransaction();

                // create company 
                $company_name = explode("-",$ca_obj->name)[1];

                $nn_sql = "select nn+1 as nn from company where nn != 201904301912 order by convert(nn,SIGNED) desc limit 1";
                $result = DBConnection::runDatabaseQuery($nn_sql);
                $nn = $result[0]->nn;
                $id_sql = "select id+1 as id from company where id != 999999 order by id desc limit 1";
                $id_result = DBConnection::runDatabaseQuery($id_sql);
                $company_id = $id_result[0]->id;
                //prepare sql
                $sql = "INSERT INTO `waybill`.`company` (`id`, `name`, `type`, `company_number`, `company_status`, `nn`, `sefat`, `registration_date`, `initial_capital`, `current_capital`, `city`, `share_holders`, `aims`, `status`, `update_by`) 
                            VALUES  (?   , ?     , ?     , ?               , ?               , ?   , ?      ,  ?                 ,  ?               , ?                ,  ?    ,  ?             , ?     , ?       ,  ?         )";

                $company_number = $company_id;
                $param = [$company_id, $company_name, "ذات مسؤولية محدودة", $company_number, "قائمة", $nn, "اعتيادية", date("Y-m-d"), 100000, 100000, 'AMMAN', '[]', '[]', 'NEW', 0];
                $result = DBConnection::runBindDatabaseQuery($sql, $param);

                // create ca record
                $clearingAgentBean = new stdClass();
                $clearingAgentBean->company_id = $company_id;
                $clearingAgentBean->id = $ca_obj->id;
                $clearingAgentBean->name = $company_name;
                $clearingAgentBean->photos = '[{"type":"logo","url":""}]';
                $ca_id = $clearingAgentCore->createClearingAgent($clearingAgentBean, 0);

                // activate it
                $clearingAgentCore->changeStatus($ca_id, "ACTIVE", 0);
            DBConnection::commitTransaction();
  
    } catch (Exception $e) {
        DBConnection::rollBackTransaction();
        dump($e);
    }
}
