<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ALL);

// import
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/route_wage/route_wage_core.php");
require_once (dirname(__FILE__)."/../core/payment/payment_core.php");
require_once (dirname(__FILE__)."/../core/tender_claim/tender_claim_core.php");

// init obj
session_start();

$waybillCore = new WaybillCore();
$routeWageCore = new RouteWageCore();
$paymentCore = new PaymentCore();
$tenderClaimCore = new TenderClaimCore();


// Get all tender claims
$tenderClaimItems = DBConnection::runBindDatabaseQuery(
    " select * from import_tender_claim where tender_claim_id is null and waybill_id is not null order by id limit 1
    ", []
);
 
foreach ($tenderClaimItems as $item){
    
   
       
    
    try{
        DBConnection::startTransaction();

    // get input
    $import_id = $item->id;
    $waybill_id = $item->waybill_id;
    $ref_id = $item->ref_num;
    $policy_num = $item->policy_num;
    $tn = $item->tn;
    $loading_date =  $item->loading_date;
    $loading_weight =  $item->loading_weight;
    $discharge_date =  $item->discharge_date;
    $discharge_weight =  $item->discharge_weight;
    $tender_company_id = $item->tender_company_id;

    // create tender claim if not exists
    // get tender claim
    $db_query = "SELECT id FROM tender_claim 
                 WHERE JSON_UNQUOTE(JSON_EXTRACT(claim_details, '$.ref')) = $ref_id
                 AND tender_company_id = $tender_company_id
                 and status != 'INACTIVE'";
    $tenderClaimQry =  DBConnection::runDatabaseQuery($db_query);

    if(sizeOf($tenderClaimQry) > 0 ){
        $tender_claim_id  = $tenderClaimQry[0]->id;
    }else{
        $tenderClaimBean = new stdClass();
        $tenderClaimBean->ref = $ref_id;
        $tenderClaimBean->waybills = null;
        $tenderClaimBean->tender_company_id = $tender_company_id;
        $tenderClaimBean->claim_type = 'waybill_claim';
        $tender_claim_id = $tenderClaimCore->createTenderClaim($tenderClaimBean, $_SESSION['user_id']);    
    } 
    
    // get route wage
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id,0);
    if($waybillBean->document->tender_claim->id){
        throw new Exception("locked");        
    }

    $routeWage = $waybillBean->document->freight->route_wage;
    if(!$routeWage) {
        $routeWageFilter = [['key'=>'destination_id','val' =>$waybillBean->destination_id],
        ['key'=>'tender_id','val' =>$waybillBean->tender_id],
        ['key'=>'cargo_id','val' =>$waybillBean->document->cargo[0]->cargo_id],
        ['key'=>'start_date','val' =>  $loading_date , 'op'=>'less than'],
        ['key'=>'end_date','val' =>  $loading_date, 'op'=>'greater than'],
        ['key'=>'status','val' => 'ACTIVE']];

        $routeWageInfo = $routeWageCore->searchRouteWage($routeWageFilter,1,0,0);
        if($routeWageInfo->found_rows == 0){
            throw new Exception("لا يمكن اضافة الأرسالية رقم $waybillBean->wn ، لا يوجد تسعيرة معرفة لموقع التفريغ ");
        }
        $routeWage = $routeWageInfo->data[0];
    }

    // append to claim
    $waybill_info = new stdClass();
    $waybill_info->waybill_id = $waybill_id ;
    $waybill_info->claim_loading_date = $loading_date ;
    $waybill_info->claim_discharge_date = $discharge_date ;
    $waybill_info->claim_loading_weight = $loading_weight ;
    $waybill_info->claim_discharge_weight = $discharge_weight ;
    $waybill_info->ref_num = $ref_id ;
    $freight = $paymentCore->calculateFreight($waybill_id, $discharge_weight, $loading_weight, $routeWage);
    $waybill_info->claim_amount = $freight->amount->net_amount;
    $waybill_info->freight = $freight;
    $waybill_info->freight->route_wage = $routeWage;

    $tenderClaimCore->appendWaybillToTenderClaim($tender_claim_id,$waybill_info, $_SESSION['u_id'], $_SESSION['user_id']);

    //update import record
    $db_query2 = "update import_tender_claim set tender_claim_id = ? where id = ?";
    DBConnection::runBindDatabaseQuery($db_query2,[$tender_claim_id,$import_id]);

    echo $tender_claim_id;
    echo "-";      
    
    DBConnection::commitTransaction();
    
    }
    catch(Exception $e){
        DBConnection::rollBackTransaction();
        dump($e);
        die;
 
    }
}
