<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ALL);

require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__).'/../core/outgoing_integration/mg_registrar.php');
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");

require_once ('../includes/util.php');

// init obj
$truckCore = new TruckCore();
$queueCore = new QueueCore();
$tenderCore = new TenderCore();
$mg_registrar = new MG_registrar();
$truckContractCore = new TruckContractCore();
session_start();

// get input params 
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

// read json
$string = file_get_contents("json/sayeb.json");
$trucks = json_decode($string, true);
$col = $trucks['QUERY']['COLUMNS'];
$trucks = array_slice($trucks['QUERY']['DATA'],$startRow,$limit);
$erros = [];
$created_by = 2;
$tender_id = 13;    //التموين
$q_id = 1;          //سائب
$activeTenderTrucks =  DBConnection::getActiveStatus('tender_truck');
$truck_owner_id = 410012;       //شركة سليمان المرايات وشركاه (الطفيلة لنقل البضائع).
$tender_company_id = 92;

$index = 0;
// loop on the trucks array
foreach ($trucks as $index => $truckData) {
    $index++;
    try{

        $ID = $truckData[0];
        $PN = $truckData[1];
        $TN = $truckData[2];
        $TRACKINGNO = $truckData[3];
        $CREATIONDATE = $truckData[4];
        $DESTINATIONADDRESSID = $truckData[5];
        $DRVR = $truckData[6];
        $COMPNAME = $truckData[7];        
        $SHIPMENTSTATUSCAPTION = $truckData[8];
        $SHIPMENTSTATUSCODE = $truckData[9];
        $COMPANYCODE = $truckData[10];

        if (strpos($COMPNAME, 'المرايات') !== false) {   
 
            // get the tender_truck of the truck
            $tenderFilter = [['key'=>'tn','val' => $TN],
                            ['key'=>'status', 'val' =>$activeTenderTrucks , 'op'=>'in'],
                            ['key'=>'tender_id','val' =>$tender_id]];
            $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,1, 0, $created_by);

            if($tenderTruck_qry->found_rows > 0){
                // add to queue
                $truck_id = $tenderTruck_qry->data[0]->truck_id;
                $trailer_id = $tenderTruck_qry->data[0]->trailer_id; 
                $addQueueId = $queueCore->addQueue($truck_id,null,$trailer_id, $q_id,$tender_id,$created_by);
                dump($addQueueId);

            }else{
 
                // try to search for truck
                $truckFilter= [['key'=>'tn','val' => $TN],['key'=>'status','val' =>'ACTIVE']];
                $truckInfo = $truckCore->searchTrucks($truckFilter, 1, 0, 0);
                if($truckInfo->found_rows > 0){
                    $truckBean = $truckInfo->data[0];
                }else{
                    // try to search in MG-REG
                    $result = $mg_registrar->getTruckData($TN, 'JOR', 'c395');
                    $autocompleteTruckBean = $result[0]['details'];
                    $truckBean = json_decode($autocompleteTruckBean,true);
                    if($truckBean){
                        $date = str_replace('/', '-', $truckBean['reg_expiry'] );
                        $truckBean['reg_expiry'] = date("Y-m-d", strtotime($date));
                        unset($truckBean['tc']);
                        unset($truckBean['truck_owner_name']);
                        $truckBean = ToObject($truckBean);
                        $truckBean->status = "NEW";
        
                        // create truck record
                        $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,1);
                        $truckBean->id = $truck_ID;

                        // activate it
                        $truckCore->changeStatus($truck_ID, 'ACTIVE',1);
                    }
                }


                //if no truck is found, insert empty record
                if(!$truckBean){

                    $truckBean = new stdClass();
                    $truckBean->tn = $TN;
                    $truckBean->nationality_code = 'JOR';
                    $truckBean->reg_num = 0;
                    $truckBean->tt = 920000;
                    $truckBean->minor_tt =  9;
                    $truckBean->cat =  "TRUCK";
                    $truckBean->status =  "NEW";
                    $truckBean->truck_owner_id =  $truck_owner_id;
                    $truckBean->update_by = 2;

                    $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,$_SESSION['user_id']);
                    $truckBean->id = $truck_ID;
       
                     // activate it
                    $truckCore->changeStatus($truck_ID, 'ACTIVE',$_SESSION['user_id']);
                }

                // try to get truck contract
                $contractFilter = [['key'=>'truck_id','val' =>$truckBean->id],
                                    ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                                    ['key'=>'truck_owner_id','val' => $truck_owner_id],
                                    ['key'=>'contract_type','val' =>'JOIN']];
                $companyFleet_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );

                if($companyFleet_qry->found_rows){
                    $createTruckContractResult = $companyFleet_qry->data[0]->id;
                }else{
                    $contract_type = 'JOIN';
                    $photos = [];
                    $sqlQuery = "INSERT INTO `waybill`.`truck_contract` (`truck_owner_id`, `truck_id`, `contract_type`, `photos`, `status`, `update_by`) 
                                 VALUES ($truck_owner_id,$truckBean->id,'$contract_type','[]','NEW',$created_by)";
                    $result = DBConnection::runBindDatabaseQuery($sqlQuery,[]);       
                }

                // create tender truck
                $tenderTruckBean = new stdClass();
                $tenderTruckBean->tender_id = $tender_id;
                $tenderTruckBean->q_id = null;
                $tenderTruckBean->tender_company_id = $tender_company_id;
                $tenderTruckBean->truck_id = $truckBean->id;
                $tenderTruckBean->photos = [];
                $tenderTruckBean->trailer_id = null;
                $tenderTruckBean->financial_details = new stdClass();
                $tenderTruckBean->financial_details->advance_payment_account = [];
                $tenderTruckBean->financial_details->waybill_beneficiary_account = "";    
                $tenderTruckBean->default_contact_user_id = null;   //TODO

                // start building the questionanaire
                $tenderTruckBean->questionnaire = [];

                $question1 = new stdClass();
                $question1->id = 1;
                $question1->val = 91000000;
                $tenderTruckBean->questionnaire[] = $question1;
                
                $question2 = new stdClass();
                $question2->id = 2;
                $question2->val = 91090000; // العقبة
                $tenderTruckBean->questionnaire[] = $question2;

                $question3 = new stdClass();
                $question3->id = 3;
                $question3->val = '_TRUCK_$_MINOR_TT_';
                $tenderTruckBean->questionnaire[] = $question3;

                // create the tender truck
                $tender_truck_id = $tenderCore->createTenderTruck($tenderTruckBean, $created_by);
                $tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', $created_by);

                 // add to queue
                $truck_id = $truckBean->id;
                $trailer_id = null; 
                $addQueueId = $queueCore->addQueue($truck_id,null,$trailer_id, $q_id,$tender_id,$created_by);
                dump($addQueueId);


            }



            
        }

  
    }catch(Exception $e){
        dump($TN);        
        dump($e);die;
    }
}


echo "finish";


function ToObject($Array) { 
      
    // Create new stdClass object 
    $object = new stdClass(); 
      
    // Use loop to convert array into 
    // stdClass object 
    foreach ($Array as $key => $value) { 
        if (is_array($value)) { 
            $value = ToObject($value); 
        } 
        $object->$key = $value; 
    } 
    return $object; 
}










