<?php

// include files
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ALL);

require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__).'/../core/outgoing_integration/mg_registrar.php');
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");

require_once ('../includes/util.php');

// init obj
$truckCore = new TruckCore();
$queueCore = new QueueCore();
$tenderCore = new TenderCore();
$mg_registrar = new MG_registrar();
$truckContractCore = new TruckContractCore();
session_start();

// get input params 
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

// get input params
$destinationsFilePath = 'json/fuel.csv';
$tenderTrucks = parseCsvFile($destinationsFilePath,$startRow,$limit);
$activeTenderTrucks =  DBConnection::getActiveStatus('tender_truck');

$erros = [];
$created_by = 2;
$tender_id = 12;    //فيول
$q_id = 1;          //فيول
$activeTenderTrucks =  DBConnection::getActiveStatus('tender_truck');
$truck_owner_id = 410031;
$tender_company_id = 147;
$_SESSION['user_id'] = "1578057879261505";

// loop on the trucks array
foreach ($tenderTrucks as $truck) {
    try{

        $TN = $truck[2];
        $TRN = $truck[3];     

        // get the tender_truck of the truck
        $tenderFilter = [['key'=>'tn','val' => $TN],
                        ['key'=>'status', 'val' =>$activeTenderTrucks , 'op'=>'in'],
                        ['key'=>'tender_id','val' =>$tender_id]];
        $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderFilter,1, 0, $created_by);

        if($tenderTruck_qry->found_rows > 0){
            // add to queue
            // $truck_id = $tenderTruck_qry->data[0]->truck_id;
            // $trailer_id = $tenderTruck_qry->data[0]->trailer_id; 
            // $addQueueId = $queueCore->addQueue($truck_id,null,$trailer_id, $q_id,$tender_id,$created_by);
            // dump($addQueueId);

        }else{

            // try to search for truck
            $truckFilter= [['key'=>'tn','val' => $TN],['key'=>'status','val' =>['ACTIVE','NEW'], 'op' => "in"]];
            $truckInfo = $truckCore->searchTrucks($truckFilter, 1, 0, 0);                
            if($truckInfo->found_rows > 0){
                $truckBean = $truckInfo->data[0];
            }else{
                // try to search in MG-REG
                $result = $mg_registrar->getTruckData($TN, 'JOR', 'c395');
                $autocompleteTruckBean = $result[0]['details'];
                $truckBean = json_decode($autocompleteTruckBean,true);
                if($truckBean){
                    $date = str_replace('/', '-', $truckBean['reg_expiry'] );
                    $truckBean['reg_expiry'] = date("Y-m-d", strtotime($date));
                    unset($truckBean['tc']);
                    unset($truckBean['truck_owner_name']);
                    $truckBean = ToObject($truckBean);
                    $truckBean->status = "NEW";
                    $truckBean->nationality_code = 'JOR';

                    // create truck record
                    $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,$_SESSION['user_id']);
                    $truckBean->id = $truck_ID;

                    // activate it
                    $truckCore->changeStatus($truck_ID, 'ACTIVE',$_SESSION['user_id']);
                }
            }

            //if no truck is found, insert empty record
            if(!$truckBean){
                
                $truckBean = new stdClass();
                $truckBean->tn = $TN;
                $truckBean->nationality_code = 'JOR';
                $truckBean->reg_num = 0;
                $truckBean->tt = 920000;
                $truckBean->minor_tt =  9;
                $truckBean->cat =  "TRUCK";
                $truckBean->status =  "NEW";
                $truckBean->truck_owner_id =  $truck_owner_id;
                $truckBean->update_by = 2;

                $truck_ID=$truckCore->createTruck($truckBean,$truck_owner_id,$_SESSION['user_id']);
                $truckBean->id = $truck_ID;
    
                 // activate it
                $truckCore->changeStatus($truck_ID, 'ACTIVE',$_SESSION['user_id']);
            }


            // try to search for trailer
            $trailerFilter= [['key'=>'tn','val' => $TRN],['key'=>'status','val' =>['ACTIVE','NEW']]];
            $trailerInfo = $truckCore->searchTrucks($trailerFilter, 1, 0, 0);                
            if($trailerInfo->found_rows > 0){
                $trailerBean = $trailerInfo->data[0];
            }else{
                // try to search in MG-REG
                $result = $mg_registrar->getTruckData($TRN, 'JOR', 'c395');
                $autocompleteTrailerBean = $result[0]['details'];
                $trailerBean = json_decode($autocompleteTrailerBean,true);
                if($trailerBean){
                    $date = str_replace('/', '-', $trailerBean['reg_expiry'] );
                    $trailerBean['reg_expiry'] = date("Y-m-d", strtotime($date));
                    unset($trailerBean['tc']);
                    unset($trailerBean['truck_owner_name']);
                    $trailerBean = ToObject($trailerBean);
                    $trailerBean->status = "NEW";
                    $trailerBean->nationality_code = 'JOR';

                    // create truck record
                    $trailer_ID=$truckCore->createTruck($trailerBean,$truck_owner_id,$_SESSION['user_id']);
                    $trailerBean->id = $trailer_ID;

                    // activate it
                    $truckCore->changeStatus($trailer_ID, 'ACTIVE',$_SESSION['user_id']);
                }
            }

            //if no truck is found, insert empty record
            if(!$trailerBean){
                
                $trailerBean = new stdClass();
                $trailerBean->tn = $TRN;
                $trailerBean->nationality_code = 'JOR';
                $trailerBean->reg_num = 0;
                $trailerBean->tt = 920300;
                $trailerBean->minor_tt =  303;
                $trailerBean->cat =  "TRAIL-HALF";
                $trailerBean->status =  "NEW";
                $trailerBean->truck_owner_id =  $truck_owner_id;
                $trailerBean->update_by = 2;

                $trailer_ID=$truckCore->createTruck($trailerBean,$truck_owner_id,$_SESSION['user_id']);
                $trailerBean->id = $trailer_ID;
    
                 // activate it
                $truckCore->changeStatus($trailer_ID, 'ACTIVE',$_SESSION['user_id']);
            }


            //get the default contact 
            $contractFilter = [['key'=>'truck_id','val' =>$truckBean->id],
                                ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                                ['key'=>'contract_type','val' =>'OWN']];
            $owner_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );
            $contact_truck_owner_id = $owner_qry->data[0]->truck_owner_id;

            // try to get truck contract
            $contractFilter = [['key'=>'truck_id','val' =>$truckBean->id],
                                ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                                ['key'=>'truck_owner_id','val' => $truck_owner_id],
                                ['key'=>'contract_type','val' =>'JOIN']];
            $companyFleet_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );


            $truckBean = ToObject($truckBean);
            $trailerBean = ToObject($trailerBean);

            if($companyFleet_qry->found_rows){
                $createTruckContractResult = $companyFleet_qry->data[0]->id;
            }else{
                $contract_type = 'JOIN';
                $photos = [];
                $sqlQuery = "INSERT INTO `waybill`.`truck_contract` (`truck_owner_id`, `truck_id`, `contract_type`, `photos`, `status`, `update_by`) 
                             VALUES ($truck_owner_id,$truckBean->id,'$contract_type','[]','NEW',$created_by)";
                $result = DBConnection::runBindDatabaseQuery($sqlQuery,[]);       
            }


            // try to get trailer contract
            $contractFilter = [['key'=>'truck_id','val' =>$trailerBean->id],
                                ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                                ['key'=>'truck_owner_id','val' => $truck_owner_id],
                                ['key'=>'contract_type','val' =>'JOIN']];
            $companyFleet_qry2 = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );
            if($companyFleet_qry2->found_rows){
                $createTruckContractResult = $companyFleet_qry2->data[0]->id;
            }else{
                $contract_type = 'JOIN';
                $photos = [];
                $sqlQuery = "INSERT INTO `waybill`.`truck_contract` (`truck_owner_id`, `truck_id`, `contract_type`, `photos`, `status`, `update_by`) 
                             VALUES ($truck_owner_id,$trailerBean->id,'$contract_type','[]','NEW',$created_by)";      
                $result = DBConnection::runBindDatabaseQuery($sqlQuery,[]);       
            }

            // create tender truck
            $tenderTruckBean = new stdClass();
            $tenderTruckBean->tender_id = $tender_id;
            $tenderTruckBean->q_id = null;
            $tenderTruckBean->tender_company_id = $tender_company_id;
            $tenderTruckBean->truck_id = $truckBean->id;
            $tenderTruckBean->photos = [];
            $tenderTruckBean->trailer_id = $trailerBean->id;
            $tenderTruckBean->financial_details = new stdClass();
            $tenderTruckBean->financial_details->advance_payment_account = [];
            $tenderTruckBean->financial_details->waybill_beneficiary_account = "";    
            $tenderTruckBean->default_contact_user_id = $contact_truck_owner_id;

            // start building the questionanaire
            $tenderTruckBean->questionnaire = [];

            $question3 = new stdClass();
            $question3->id = 1;
            $question3->val = '*';
            $tenderTruckBean->questionnaire[] = $question3;

            // create the tender truck
            $tender_truck_id = $tenderCore->createTenderTruck($tenderTruckBean, $created_by);
            $tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', $created_by);

            //  // add to queue
            // $truck_id = $truckBean->id;
            // $trailer_id = null; 
            // $addQueueId = $queueCore->addQueue($truck_id,null,$trailer_id, $q_id,$tender_id,$created_by);
            // dump($addQueueId);
            
        }

  
    }catch(Exception $e){
        dump($truckBean);
        dump($trailerBean);
        dump($e);die;
    }
}


echo "finish";


function ToObject($Array) { 
      
    // Create new stdClass object 
    $object = new stdClass(); 
      
    // Use loop to convert array into 
    // stdClass object 
    foreach ($Array as $key => $value) { 
        if (is_array($value)) { 
            $value = ToObject($value); 
        } 
        $object->$key = $value; 
    } 
    return $object; 
}










