<?php
ini_set('max_execution_time', 2400000); //600 seconds = 10 minutes

require_once (dirname(__FILE__)."/../includes/DBConnection.php");
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");

DBConnection::getInstance();
$waybillCore = new WaybillCore();

// fix ACTIVE Waybills
$scenarios = [];
$scenarios["status"] = "ACTIVE";
$scenarios["numberOfNodes"] = 1;
$scenarios["fix_title"] = "تعبئة ديزل";
$scenarios["fix_text"] = "تم تعبئة 100 دينار ديزل للشاحنة";
 
// get all waybill draft
$db_query = "select * from waybill  where tender_id = 11 and status = '" . $scenarios['status'] . "' limit 1000";
$result =  DBConnection::runDatabaseQuery($db_query);

$final = [];
foreach ($result as $wbl) {
    $doc = json_decode($wbl->document);
    $activity = $doc->activities;

    $dieselNode = [];
    foreach ($activity as $act) {
        if($act->activity_title == "تعبئة ديزل" || $act->activity_title  == "خطأ تعبئة ديزل"){
            $dieselNode[] = $act;
        }
    }
    $final[$wbl->id] = $dieselNode;
}

 
$error_count = 0;
foreach ($final as $waybill_id => &$nodes) {
    if(sizeof($nodes) < $scenarios["numberOfNodes"]){
        $error_count ++;

        // update in DB
        // $waybillCore->logActivity($waybill_id,
        //                           $scenarios["fix_title"] ,
        //                           $scenarios["fix_text"] ,
        //                           "WAYBILL_PAYMENT",0);

        echo $waybill_id;
    }
}
echo "error_count=" . $error_count . "\n";



// fix ACTIVE Waybills
$scenarios = [];
$scenarios["status"] = "ONROAD";
$scenarios["numberOfNodes"] = 2;
$scenarios["fix_title"] = "تعبئة ديزل";
$scenarios["fix_text"] = "تم تعبئة 83.75 دينار ديزل للشاحنة";
 
// get all waybill draft
$db_query = "select * from waybill  where tender_id = 11 and status = '" . $scenarios['status'] . "' limit 10";
$result =  DBConnection::runDatabaseQuery($db_query);

$final = [];
foreach ($result as $wbl) {
    $doc = json_decode($wbl->document);
    $activity = $doc->activities;

    $dieselNode = [];
    foreach ($activity as $act) {
        if($act->activity_title == "تعبئة ديزل" || $act->activity_title  == "خطأ تعبئة ديزل"){
            $dieselNode[] = $act;
        }
    }
    $final[$wbl->id] = $dieselNode;
}

 
$error_count = 0;
foreach ($final as $waybill_id => &$nodes) {
    if(sizeof($nodes) < $scenarios["numberOfNodes"]){       
        $error_count ++;

        // // update in DB
        // $waybillCore->logActivity($waybill_id,
        //                           $scenarios["fix_title"] ,
        //                           $scenarios["fix_text"] ,
        //                           "WAYBILL_PAYMENT",0);

        echo $waybill_id . "-";
    }
}
echo "error_count=" . $error_count . "\n";