<?php
ini_set('max_execution_time', 2400000); //600 seconds = 10 minutes

require_once (dirname(__FILE__)."/../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../core/payment/payment_core.php");
require_once (dirname(__FILE__)."/../core/waybill_draft/waybill_draft_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/voucher/voucher_core.php");


$db = DBConnection::getInstance();
$paymentCore = new PaymentCore();
$waybillDraftCore = new WaybillDraftCore();
$tenderCore = new TenderCore();
$voucherCore = new VoucherCore();

// get all waybill draft
$db_query = "select * from waybill_draft where status not in('INACTIVE','REJECTED') and id > 884 order by id";
$result =  DBConnection::runDatabaseQuery($db_query);

$man = $tenderCore->getTenderManifest(17, 0);
session_start();
$user_id = $_SESSION['user_id'];
 
// loop on drafts
foreach ($result as $draft) {

    try {
         
    DBConnection::startTransaction();
           
    // tagreesh the waybill again
    $waybillBean = $waybillDraftCore->getWaybillDraft($draft->id);
    $waybillBean->document= json_decode($waybillBean->document);
    $freight_node = $paymentCore->calculateFreight($waybillBean);
 
    // save the waybill payment info in waybill doc
    $waybillBean->document->freight->amount = $freight_node->amount;
    $waybillBean->document->freight->deductions = $freight_node->deductions;
    $sqlQuery = "UPDATE waybill_draft SET document=? WHERE id = ?;";
    $params = [];
    $params[] = json_encode($waybillBean->document);
    $params[] = $waybillBean->id;
    DBConnection::runBindDatabaseQuery($sqlQuery, $params);

    // create voucher
    $payment_account = $man['freight']['payment_accounts'][0]['account_id'] . "-" . $man['freight']['payment_accounts'][0]['account_sub_id'];
    $target_account = "777412-60001";
    $value = new stdClass();
    $advanced_payment = 0;
    if($waybillBean->document->freight && $waybillBean->document->freight->payments){
        foreach($waybillBean->document->freight->payments as $payment){
            if ($payment->name == 'PERSONAL_PAYMENT'){
                $advanced_payment =$payment->value->amount;
            }
        }
    }
    
    $remarks =  ' صرف مستحقات  للسائق '. $waybillBean->driver_name .
                        ' - رقم وطني '. $waybillBean->driver_nn .
                        ' - رقم هاتف '. $waybillBean->driver_phone .
                        ' - الشاحنة رقم : ' . $waybillBean->tn .
                        ' - رقم الارسالية : ' . $waybillBean->bond_number ;
    $value->amount = ($freight_node->amount->net_amount - $advanced_payment );
    $advancePaymentNode = (object) array("name"=>"PERSONAL_PAYMENT",
    "label"=>$remarks,
    "target_account"=>$target_account,
    "time_stamp" => DBConnection::getSystemDate(),
    "value"=>$value);

    $voucher_id = $waybillDraftCore->createVoucher(
        $payment_account,
        $target_account,
        $value->amount,           
        'CASH' ,
        $advancePaymentNode,
        null,
        'WAYBILL_DRAFT', 
        $waybillBean->id, 
        $remarks,
        $waybillBean->tender_id, 
        "PERSONAL"
    );
 
    // log trx
    $accounts = $man['freight']['accounts'];
    foreach ($accounts as $acc) {
        if($acc['code'] == 'ledger_account'){
            $ledger_account_id = $acc['account'];           
        }
    }

    $ledger_account_id = $ledger_account_id;
    $cash_account_id = "777412-19901";  // from UI
    $claim_account_id = "777412-20436"; //  hard coded
    $notes = $remarks;
    $amount = $freight_node->amount->base_amount;
    $discharge_date = $waybillBean->document->cargo[0]->weights->discharge->time_stamp;

    $total_deductions = 0;
    foreach ($freight_node->deductions as $d) {
        $total_deductions += $d['value']['amount'];
    }

    $remarks = "ارسالية رقم $waybillBean->bond_number , الشاحنة $waybillBean->tn ، السائق $waybillBean->driver_name ، رقم وطني $waybillBean->driver_nn";
    $jv_id = $paymentCore->logWaybillCompletePaymentTrx($amount ,$advanced_payment, $total_deductions,
                                                        $ledger_account_id , $cash_account_id , $claim_account_id,
                                                        $discharge_date , 
                                                        $remarks , 
                                                        $user_id);

    // complete it
    $voucherBean = $voucherCore->getVoucherBasic($voucher_id, 0);
    $voucherBean->jv_id = $jv_id;
    $voucherBean->payment_date = $discharge_date;
    $voucherBean->status = "COMPLETE";
    $voucherCore->updateVoucherInfo($voucherBean,$voucher_id, 0);

    echo $draft->id . " =================== ";

    DBConnection::commitTransaction();

    } catch (Exception $ex) {        
        dump($ex);
        die;
        DBConnection::rollBackTransaction();
    }

    
}