<?php

ini_set('max_execution_time', 2400000); //600 seconds = 10 minutes
error_reporting(E_ALL);
require_once ("../includes/DBConnection.php");
require_once ("../includes/debug.php");
require_once (dirname(__FILE__)."/../core/payment/payment_core.php");
require_once (dirname(__FILE__)."/../core/account/account_core.php");
require_once (dirname(__FILE__)."/../core/voucher/voucher_core.php");


$maximin_jv_id = 2050022719;
DBConnection::getInstance();
$payment_core = new PaymentCore();
$account_core = new accountCore();
$voucherCore = new VoucherCore();

// query vouchers
$query  = "SELECT 
*
FROM
voucher
WHERE
payment_method = 'zain_cash'
    AND integration_details IS NOT NULL
    AND status = 'COMPLETE'
    AND JSON_EXTRACT(integration_details,
        '$.payment.transaction_date') like '%null%' limit 1000";

$vouchers = DBConnection::runDatabaseQuery($query);
$result = [];
 
foreach ($vouchers as $voucher) {
    try{

        $voucherBean = $voucherCore->getVoucherBasic($voucher->id , 0);

        $integration_details = json_decode($voucher->integration_details);
        $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-1]->code)[1];
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-2]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-3]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-4]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-5]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-6]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-7]->code)[1];
        }
        if(!$zain_cash_ref_id){
            $zain_cash_ref_id = explode(":" , $integration_details->activity[sizeOf($integration_details->activity)-8]->code)[1];
        }

        $query  = "SELECT * FROM zain_cash_log where TransactionReference = $zain_cash_ref_id ";
        $zainCash = DBConnection::runDatabaseQuery($query);
 
        if(sizeOf($zainCash) == 0){
            foreach ($integration_details->activity as $int) {    
                if($int->code == "تمت عملية تأكيد الدفع من قبل البنك المركزي" ){
                    $trx_date = $int->time_stamp;
                    break;
                }                
            }
        }else{
            $trx_date = $zainCash[0]->TransactionDate;
        }
 
        if(!$trx_date){          
            throw new Exception("Error Processing Request", 1);            
        }
        
        $integration_details = $voucherBean->integration_details ;
        $integration_details->payment = new stdClass();
        $integration_details->payment->ref_id = $zain_cash_ref_id;
        $integration_details->payment->transaction_date = $trx_date;
        $voucherBean->integration_details = $integration_details;
        $voucherCore->updateVoucherInfo($voucherBean , $voucherBean->id, 0);
 
    }catch(Exception $e){
        dump($voucherBean);
        die;
    }
 
}