<?php

ini_set('max_execution_time', 600); //600 seconds = 10 minutes

error_reporting(E_ERROR | E_PARSE);
require_once('../includes/DBConnection.php');
require_once('../includes/util.php');
require_once(dirname(__FILE__) . "/../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../core/truck_contract/truck_contract_core.php");

DBConnection::getInstance();
$waybillCore = new WaybillCore();
$tenderCore = new TenderCore();
 $userCore = new UserCore();

$update_by = 2;
$tender_id = 11;

// get input params
$rawDataPath = 'json/finn.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];
$rawData = parseCsvFile($rawDataPath, $startRow, $limit);
 
foreach ($rawData as $data) {

    try {


        DBConnection::startTransaction();
                  
            $tn = $data[0];
            $fin_manager_name = $data[2];
            $contract_type = $data[1];


            
            // search for user
            $userSearchFilter = [
                ['key' => 'name', 'val' => $fin_manager_name],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
 
            $userInfo = $userCore->searchUser($userSearchFilter, 1, 0, $update_by);
            if ($userInfo->found_rows == 0) {
                throw new Exception("user does not exist");
            }

            // add truck_owner_id as Fin_manager  in tender truck
            $user_id = $userInfo->data[0]->id;
            $tenderCore->fixTruckContract($user_id,$tender_id, $tn, $contract_type , $update_by);

            echo $tn . ",";

        DBConnection::commitTransaction();

    } catch (Exception $e) {
        DBConnection::rollBackTransaction();
        echo $tn . "-";
        dump($e);
        
        
    }
}
