<?php
 
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

error_reporting(E_ERROR | E_PARSE);
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/route_wage/route_wage_core.php");

DBConnection::getInstance();
$waybillCore = new WaybillCore();
$routeWageCore = new routeWageCore();
$jo_petrol = new Jo_Petrol();
$update_by = 0;
 
$sql = 
"select *  
from waybill w 
where 
w.tender_id = 11 and 
w.status in('NEW','ACTIVE')
";

$result = DBConnection::runBindDatabaseQuery($sql,$param);
 

foreach ($result as $waybill) {

    $waybill_id = $waybill->id;
     
    // search for waybill bean
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id,$update_by);
    $document = $waybillBean->document;

    if(!$document->integeration_details){

        // old queue
        $tn = $waybillBean->document->carrier[0]->truck->tn;
        $old_queue_sql = "Select q1.id , q1.serial as serial 
                from queue_view q1
                where 
                q1.tender_id = 11 and
                q_id = 1 and 
                q1.tn = $tn and 
                rank is null 
                order by id desc limit 1";
        $old_queue_result = DBConnection::runBindDatabaseQuery($old_queue_sql,[]); 
        
        $new_queue_sql = "Select q1.id , q1.serial as serial , q1.rank
                from queue_view q1
                where 
                q1.tender_id = 11 and
                q_id = 1 and 
                q1.tn = $tn and 
                rank is not null
                order by id desc limit 1";
        $new_queue_result = DBConnection::runBindDatabaseQuery($new_queue_sql,[]); 

        $document->integeration_details = new stdClass();
        $document->integeration_details->queue = new stdClass();

        $document->integeration_details->queue->q_id = 1;
        $document->integeration_details->queue->entry_point_id = 91090032;
        
        // old
        $document->integeration_details->queue->serial = $old_queue_result[0]->serial;
        $document->integeration_details->queue->queue_id = $old_queue_result[0]->id;
        $document->integeration_details->queue->queue_rank = null;

        // new
        $document->integeration_details->queue->new_serial = $new_queue_result[0]->serial;
        $document->integeration_details->queue->new_queue_rank = $new_queue_result[0]->rank;

 
        $updatedWaybill = new stdClass();
        $updatedWaybill->id = $waybillBean->id;
        $updatedWaybill->document = $document;   
        DBConnection::updateDB("waybill",$updatedWaybill,$update_by);

 
    }

   
}
echo "done";
die;

 