
<?php

// init
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

// import needed files
require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/outgoing_integration/Jo_Petrol.php");

// init obj
$db = DBConnection::getInstance();
$jo_petrol = new Jo_Petrol();
$waybillCore = new WaybillCore();

// get the first waybill to be processed
$sqlQuery = " SELECT id from waybill where tender_id = 11
                and status not in ('INACTIVE','REVOKED')
                and document->>'$.integeration_details.jo_petrol.nf55doco' is null              
                order by id 
                limit 1";
$param = [];
$result = DBConnection::runDatabaseQuery($sqlQuery);

// get waybill bean
$waybillBean = $waybillCore->getWaybillBasic($result[0]->id, 0);

// get new info from jo_petrol
$jo_petrol_waybill_info = $jo_petrol->QueryOnWayBill($waybillBean->id, false);
unset($jo_petrol_waybill_info['@attributes']);

// save the new node
if(!$waybillBean->document->integeration_details->jo_petrol){
    $waybillBean->document->integeration_details->jo_petrol = new stdClass();
}
$waybillBean->document->integeration_details->jo_petrol = $jo_petrol_waybill_info;
$waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
