<?php

ini_set('max_execution_time', 6000); //6000 seconds = 1:35 minutes
require_once dirname(__FILE__)."/../core/waybill/waybill_core.php";
require_once dirname(__FILE__)."/../core/outgoing_integration/Jo_Petrol.php";

// prepare obj
$jo_petrol_integration = new Jo_Petrol();
$waybillCore = new WaybillCore();

$sqlQuery = " SELECT tn from waybill_view where tender_id = 11 and status in ('ACTIVE','ONROAD')  order by id  ";
$param = [];
$result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
foreach ($result as $wbl) {

    try {
    // get user input
    $tn = intval($wbl->tn);

        echo "tn=" . $tn . "\n";

    // get all the waybills on tender_id = 11 and not revoked or Inactive
    $waybillFilter = [
        ['key' => 'tender_id', 'val' => 11],
        ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
        ['key' => 'tn', 'val' => $tn]
    ];
    $waybillResult = $waybillCore->searchWaybills($waybillFilter, 10000, 0, 0);


    // loop on each waybill
    $total_diesel_amount = 0;
    foreach ($waybillResult->data as $wbl) {

        // calculate diesel amount of each waybill
        $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                         $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
                         $total_diesel_amount += doubleval($diesel_amount);
    }



    // get card balance and fix it
        $cardBalance = $jo_petrol_integration->checkCardBalance($tn);
        $cardBalance = doubleval($cardBalance['currentLimit']);
        $total_diesel_amount = doubleval($total_diesel_amount);

        if (abs($cardBalance - $total_diesel_amount) < 5) {
            throw new Exception("الشاحنة لديها رصيد كامل من الديزل");
        }

        // if the user has balance more than the correct , then remove from balance
        if ($cardBalance > $total_diesel_amount) {
            $charge_amount = -1 * ($cardBalance - $total_diesel_amount);
        }

        // if the user has less amount than the correct, add balance
        else {
            $charge_amount = $total_diesel_amount - $cardBalance;
        }

        // charge diesel card on jo petrol system
        $jo_petrol_integration->transferDeisil($tn, $charge_amount);


    // start fixing waybill document if it needs a fix
    foreach ($waybillResult->data as $wbl) {
        $doc = json_decode($wbl->document);
        $freight = $doc->freight;
        $payments = $freight->payments;
        $fixed_amount = 0;

        //look for DEISIL_PRE_LOAD node and DEISIL_POST_LOAD node
        $found_pre_node = false;
        $found_post_node = false;
        foreach ($payments as &$p) {
            if ($p->name == 'DEISIL_PRE_LOAD') {
                $found_pre_node = true;
                $p->value = new stdClass();
                $p->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
                if (!$p->time_stamp) {
                    $p->time_stamp = DBConnection::getSystemDate();
                }
                unset($p->status);
                $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
            }
            if ($p->name == 'DEISIL_POST_LOAD') {
                $found_post_node = true;
                $p->value = new stdClass();
                $p->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
                if (!$p->time_stamp) {
                    $p->time_stamp = DBConnection::getSystemDate();
                }
                unset($p->status);
                $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            }
        }
        $doc->freight = $freight;
        $wbl->document = $doc;
        $waybillCore->updateWaybill($wbl, $wbl->id, 0);

        // create pre and post node is case does not exist
        if (!$found_pre_node) {
            $newPayment = new stdClass();
            $newPayment->label = "DEISIL_PRE_LOAD";
            $newPayment->name = "DEISIL_PRE_LOAD";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
            $newPayment->time_stamp = DBConnection::getSystemDate();
            $waybillCore->addWaybillPaymentNode($wbl->id, $newPayment);
            $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD');
        }
        // create pre and post node is case does not exist
        if (!$found_post_node) {
            $newPayment = new stdClass();
            $newPayment->label = "DEISIL_POST_LOAD";
            $newPayment->name = "DEISIL_POST_LOAD";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
            $newPayment->time_stamp = DBConnection::getSystemDate();
            $waybillCore->addWaybillPaymentNode($wbl->id, $newPayment);
            $fixed_amount += $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
        }


        // calculate diesel amount of each waybill
        $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
            $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
        $correct_diesel_amount = doubleval($diesel_amount);

        if ($fixed_amount > $correct_diesel_amount) {
            $amount_to_log = $fixed_amount - $total_diesel_amount;

            $waybillCore->logActivity(
                $wbl->id,
                "شحن بطاقة الديزل",
                "تم اصلاح رصيد بطاقة الديزل واضافة مبلغ:  " . $amount_to_log . " دينار ",
                "check",
                0
            );
        } else if ($fixed_amount < $correct_diesel_amount) {

            $amount_to_log = $correct_diesel_amount - $fixed_amount;
            $waybillCore->logActivity(
                $wbl->id,
                "سحب رصيد من بطاقة الديزل",
                "تم اصلاح رصيد بطاقة الديزل وسحب مبلغ:  " . $amount_to_log . " دينار ",
                "check",
                0
            );
        }
    }

    } catch (Exception $e) {
        // skip
    }
}
