<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");


$waybillOrderCore = new WaybillOrderCore();
$queueCore = new QueueCore();
$waybillCore = new waybillCore();


$erros = [];
$user_id = 2;

$filePath = 'PendingAactivity.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

$result = parseCsvFile($filePath,$startRow,$limit);
$erros = [];
 
foreach ($result as $activity) {

    try{ 
        
        // create new waybill order for queue_id if not exist
        $order_id = $activity[8];
        $cargo_id = $activity[11];
        $queue_id = $activity[3];
        $searchFilter = [['key'=>'tender_order_id','val' => $order_id],
                         ['key'=>'cargo_id','val' => $cargo_id], 
                         ['key'=>'queue_id','val' => $queue_id],
                         ['key'=>'status','val' => ['REVOKED'] ,'op' => 'not in']];
        $activeWaybillOrders = $waybillOrderCore->searchWaybillOrder($searchFilter,1,0,$user_id);
 
        if($activeWaybillOrders->found_rows > 0){
            $waybill_order_id = $activeWaybillOrders->data[0]->id;
        }else{
            $create_date = $activity[4];
            $waybillOrderResult = $waybillOrderCore->createWaybillOrder($order_id,$cargo_id,$queue_id,$create_date, $user_id);
            $waybill_order_id = $waybillOrderResult[0]['@id'];
        }

        // change status of waybillOrder
        if($activity[5] == 'PENDING'){
            // change waybill order to REVOKED
            $waybillOrderCore->changeStatus($waybill_order_id, 'REVOKED', $user_id);
        }

        // change status of waybillOrder
        else if($activity[5] == 'INACTIVE'){
            // change waybill order to REVOKED
            $waybillOrderCore->changeStatus($waybill_order_id, 'REVOKED', $user_id);            
        }

        // change status of waybillOrder
        else if($activity[5] == 'CLOSED'){
            
            // connect the waybill to waybill order in case it is NEW
            if($activity[10] == 'NEW'){                

                // $waybill_id = $activity[9];

                // $waybillOrderCore->updateWaybillOrder($waybill_order_id, $waybill_id);
                 
                // // change waybill order to APPROVED
                // $waybillOrderCore->changeStatus($waybill_order_id, 'APPROVED', $user_id); 
                
                // // change status of queue to waiting
                // $queueCore->changeStatus($queue_id, 'WAITING',0);

                // // change status of queue to approved
                // $queueCore->changeStatus($queue_id, 'APPROVED',$user_id);

                // // change waybill to REVOKED
                // $waybillCore->changeStatus($waybill_id, "REVOKED", 0 );

            }else{
                // change waybill order to APPROVED
                $waybillOrderCore->changeStatus($waybill_order_id, 'APPROVED', $user_id); 

                // change waybill order to CLOSED
                $waybillOrderCore->changeStatus($waybill_order_id, 'CLOSED', $user_id); 
            }            
        }    

        die;

    
    }
    catch (Exception $e){
        $errorObj = new stdClass();
        $errorObj->tn = $tn;
        $errorObj->error = $e->getMessage();
        array_push($erros, $errorObj);
    }
}

 