<?php

error_reporting(E_ERROR | E_PARSE);
set_time_limit(0);
ini_set('max_execution_time', 240000);
require_once ('../includes/debug.php');
require __DIR__ . '/../vendor/autoload.php';
require_once dirname(__FILE__) . "/../core/user/user_core.php";

$userCore = new UserCore();
$searchFilter = [['key' => 'status', 'val' => "ACTIVE"]];
$searchResult = $userCore->searchUser($searchFilter, 10, 0, 0);

$searchResult = $searchResult->data;
foreach ($searchResult as $user) {
    $phoneArray=json_decode($user->phone_array);
    $phone=$phoneArray[0]->phone;

    $photos = json_decode($user->photos);
    if (isset($photos)) {
        foreach ($photos as $photo) {
            if (isset($photo) && $photo->type == "id_photo") {
                $thumb = str_replace(".pdf", "_thumb.jpg", $photo->url);
                $hasThumb = callCurl($thumb);
                if (strpos($hasThumb, 'key does not exist') !== false) {
                    $url = "https://us-central1-waybill-project.cloudfunctions.net/generateThumb?imageURL=$photo->url&resizeOriginal=false";
                    $response = json_decode(callCURL($url));
                    saveToDrive($phone.'-'.$user->name,$response->imageUrl);
                }
                else{
                    saveToDrive($phone.'-'.$user->name,$thumb);
                }
                $error = "$user->id,fixed";
                $file = fopen("result.csv","a");
                fputcsv($file,explode(',',$error));           
                fclose($file);

            }
        }
    }
}


function saveToDrive($name, $url)
{
    $client = getClient();
    $driveService = new Google_Service_Drive($client);
    $fileMetadata = new Google_Service_Drive_DriveFile(array(
        'name' => $name,
        'parents' => array("1o1NA2OZ0PeWpDMynQs-E5UnjBJ0MgIEr")

    ));
    $content = file_get_contents($url);
    $file = $driveService->files->create($fileMetadata, array(
        'data' => $content,
        'mimeType' => 'image/jpeg',
        'uploadType' => 'multipart',
        'fields' => 'id'));
}

function callCURL($url)
{
    $url = str_replace(' ', '', $url);

    $ch = curl_init();

    $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, false);

    $json = curl_exec($ch);
    curl_close($ch);

    return $json;
}

function getClient()
{
    $client = new Google_Client();
    $client->setApplicationName('Google Drive API PHP Quickstart');
    $client->setScopes(Google_Service_Drive::DRIVE, Google_Service_Sheets::SPREADSHEETS);

    $credintialPath = 'credentials.json';
    $credintial_json = file_get_contents($credintialPath);
    $client->setAuthConfig($credintialPath);

    $client->setAccessType('offline');
    $client->setPrompt('select_account consent');

    // Load previously authorized token from a file, if it exists.

    $tokenPath = 'token.json';
    if (file_exists($tokenPath)) {
        $accessToken = json_decode(file_get_contents($tokenPath), true);
        $client->setAccessToken($accessToken);
    }

    // If there is no previous token or it's expired.
    if ($client->isAccessTokenExpired()) {
        // Refresh the token if possible, else fetch a new one.
        if ($client->getRefreshToken()) {
            $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
        } else {
            // Request authorization from the user.
            $authUrl = $client->createAuthUrl();
            // print_r($authUrl);
            $authCode = trim(fgets(STDIN));

            // Exchange authorization code for an access token.
            $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
            $client->setAccessToken($accessToken);

            // Check to see if there was an error.
            if (array_key_exists('error', $accessToken)) {
                throw new Exception(join(', ', $accessToken));
            }
        }
        // Save the token to a file.
        file_put_contents($tokenPath, json_encode($client->getAccessToken()));
    }
    return $client;
}