<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
 
$erros = [];
$q_id = 1;
$tender_id = 3;
$created_by = 2;
$queueCore = new QueueCore();

$filePath = 'fixQueue.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

$result = parseCsvFile($filePath,$startRow,$limit);
$erros = [];

foreach ($result as $truck) {

    try{
        // ----------------------------- Prepare Data -----------------------------------
        $truck_id = $truck[2];
        $driver_id = $truck[7];
        $trailer_id = $truck[4];
        $new_status_code = $truck[8];
        $activation_date = $truck[9];

 
        // ------------------------ Add to Queue ----------------------------------------
        $addQueueId = $queueCore->addQueue($truck_id,null,$trailer_id, $q_id,$tender_id,$created_by);

        // ------------------------ change status to ACTIVE or PENDING ------------------
        $queueCore->changeStatus($addQueueId, $new_status_code, $created_by);

        // ----------------------- update activation date in case it is pending -------------------
        if($new_status_code == 'PENDING'){
            $updateBean = new stdClass();
            $updateBean->id = $addQueueId;
            $updateBean->activation_date = $activation_date;

            $queueCore->updateQueue($updateBean,$created_by);
 
        }
    }
    catch (Exception $e){
        $errorObj = new stdClass();
        $errorObj->tn = $tn;
        $errorObj->error = 'TRUCK.NOT.REGISTERED';
        array_push($erros, $errorObj);
    }     
}
 
