
<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__)."/../core/cargo/cargo_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");

$serveQueue = [6179];

$QueueCore = new QueueCore();
$CargoCore = new CargoCore();
$TenderCore = new TenderCore();
$waybillCore = new WaybillCore();

foreach ($serveQueue as $serve) {
    try{
 

        $tender_order_id = 413;
        $cargo_id = 1810000008;
        $queue_id = $serve;

        // prepare beans

        $queueBean = $QueueCore->getQueuebasic($queue_id,  0);
        $cargoBean = $CargoCore->getCargobasic($cargo_id,  1);
        $orderBean = $TenderCore->getTenderOrderBasic($tender_order_id,  1);         

        // prepare data for create waybill method
        $tender_id = $queueBean->tender_id;
        $queue_id = $queueBean->q_id;
        $order_id = $tender_order_id;
        $cargo_id = $cargo_id;
        $truck_id = $queueBean->truck_id;
        $trailer_id = $queueBean->trailer_id;
        $driver_id = $queueBean->driver_id;
        $truck_owner_id = $queueBean->truck_owner_id;
        $trailer_owner_id = $queueBean->truck_owner_id;
        $trucking_company_id = '327';  
        $ca_company_id = $cargoBean->waybill_template->cargo[0]->consigner->ca_id;
        $origin_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->origin, $cargoBean);
        $destination_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->destination, $cargoBean);
        $user_id =  1;

        // create waybill
        DBConnection::startTransaction();
        $waybill_result = $waybillCore->createWaybill($tender_id,$queue_id,$order_id,
                                                    $cargo_id,
                                                    $truck_id, $trailer_id, $driver_id,
                                                    $truck_owner_id,$trailer_owner_id,
                                                    $trucking_company_id,$ca_company_id,
                                                    $origin_id , $destination_id,
                                                    $user_id);


        DBConnection::commitTransaction();

        $Result['ERRORCODE'] = "0";
        $Result['waybill_id'] = $waybill_result->id;;
        $Result['wn'] = $waybill_result->wn;
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
    
        dump($Result);
        echo "CLOSE WAYBILL ORDER NOW";

    }catch(Exception $e){
        DBConnection::rollBackTransaction();
        dump($e);
    }

}
 