<?php
 
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

error_reporting(E_ERROR | E_PARSE);
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");

// prepare data
DBConnection::getInstance();
$tenderCore = new TenderCore();
$erros = [];
$created_by = 2;
$cargo = [1810000010];
$questionnaire = '[{"id": "1", "val": "91000000"}, {"id": "2", "val": "91090004"}, {"id": "3", "val": "*"}]';
$trucks = 10;
$order_date = '2018-09-03';

// search for all tender_companies
$tenderCompaniesFilter = [['key'=>'status','val' =>['INACTIVE'], 'op'=> 'not in']];      
$tender_company_qry = DBConnection::searchDB("tender_company",$tenderCompaniesFilter,1000,0,1)->data;
 
// create tender order for each company
foreach ($tender_company_qry as $company) {
   
    try{
        $tenderBean = new stdClass();
        $tenderBean->tender_id = $company->tender_id;
        $tenderBean->q_id = $company->q_id;
        $tenderBean->questionnaire = $questionnaire;
        $tenderBean->cargo = $cargo;
        $tenderBean->trucks = $trucks;
        $tenderBean->order_date = $order_date;
        $id = $tenderCore->createTenderOrder($tenderBean,$created_by);

        // activate tender order
        $tenderCore->changeOrderStatus($id, 'ACTIVE', $created_by);
    }
    catch (Exception $e){
        dump($e);
        dump($company);
    }
   
 
}
