
<?php
 
 // create buld recipient to certain poll


 ini_set('max_execution_time', 60000); //600 seconds = 10 minutes
 
 error_reporting(E_ERROR | E_PARSE);
 require_once ('../includes/DBConnection.php');
 require_once ('../includes/util.php');
 require_once (dirname(__FILE__)."/../core/user/user_core.php");
 require_once (dirname(__FILE__)."/../core/outgoing_integration/poll.php");

 // prepare data
DBConnection::getInstance();
$userCore = new UserCore();
$pollIntegration = new Poll();

// read xls
$filePath = 'json/rec_poll.csv';
$startRow =3;
$limit = 20000;
$result = parseCsvFile($filePath,$startRow,$limit);

$erros = [];
$poll_id = 109535;
$created_by = 2;
 
foreach ($result as $row) {
 
    try {
        // get need info for bind params
        $phone = $row[0];
        $user_id = $row[1];
        $tn = $row[2];
        $owner_id = $row[3];
        $owner_name = $row[4];

        // build bind params {"_$_NAME_$_": "name"}
        $bind_params = [];
        $bind_params['_$_OWNER_NAME_$_'] = $owner_name;
        $bind_params['_$_OWNER_ID_$_'] = $owner_id;
        $bind_params['_$_TN_$_'] = $tn;
        $bind_params['_$_PHONE_$_'] = $phone;

        // get user hb
        $userBean = $userCore->getUserBasic($user_id,0);
        $userHB = $userCore->getUserHeartBeatObject($userBean->id);
 
        // add recipient
        $recipients =[];
        $rec['user_id'] = $userBean->id;
        $rec['bind_params'] = json_encode($bind_params,JSON_UNESCAPED_UNICODE);
 
        if($userHB->app_version && intval($userHB->app_version) > 55){
            $rec['communication_channels'] = [
                ['channel' => 'FCM' , 'details' => ['fcm_registration_id'=>$userBean->notification_token] , 'status' => 'ACTIVE', 'priority'=> 1]        
            ];
        }else{
            $rec['communication_channels'] = [ 
                ['channel' => 'SMS' , 'details' => ['phone_number'=>$userBean->phone] , 'status' => 'ACTIVE', 'priority'=> 1]
            ];
        }
        $recipients[] = $rec;

        $pollIntegration->appendRecipientToPoll($poll_id,$recipients);
 

    } catch (Exception $th) {
        dump($th);
    }
}
 
 