<?php
 
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

error_reporting(E_ALL);
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/outgoing_integration/customer_care.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");

// prepare data
DBConnection::getInstance();
$customerCare = new CustomerCare();
$waybillCore = new WaybillCore();


// run query
$db_query = "
            SELECT 
            w.id,
            wn,
            w.create_date,
            tn,
            trn,
            document->>'$.carrier[0].driver.name' driver_name,
            document->>'$.carrier[0].driver.nn' driver_nn,
            document->>'$.carrier[0].driver.phone' driver_phone,
            document->>'$.tender.name' tender_name,
            w.tender_id,
            a.activity_date as enter_loading_location_time
            FROM
            waybill_view w left join activity a on a.action_code = 'CHANGE_STATUS' and a.waybill_id = w.id and a.object_new_status_code = 'PENDING'
            WHERE
            status NOT IN ('COMPLETE' , 'CLOSED', 'INACTIVE', 'REVOKED')
            AND loading_date IS NULL
            AND w.tender_id IN (3 , 11, 12, 13)
            AND create_date > '2020-10-05'
            AND (time_to_sec(timediff(now(),create_date )) / 3600) > 48
            and document->>'$.integeration_details.ticket[*].ticket_type_code' is null ";
        
$result =  DBConnection::runDatabaseQuery($db_query);

if(sizeof($result) > 0){

    // loop on result to seperate waybill by tender
    foreach ($result as $waybill) {
        $wbl = [];
        $wbl['id'] = $waybill->id;
        $wbl['wn'] = $waybill->wn;
        $wbl['tn'] = $waybill->tn;
        $wbl['trn'] = $waybill->trn;
        $wbl['driver_name'] = $waybill->driver_name;
        $wbl['driver_nn'] = $waybill->driver_nn;
        $wbl['driver_phone'] = $waybill->driver_phone;
        $wbl['tender_name'] = $waybill->tender_name;
        $wbl['loading_weight'] = null;
        $wbl['create_date'] = $waybill->create_date;
        $wbl['enter_loading_location_time'] = $waybill->enter_loading_location_time;

        $tenders[$waybill->tender_id][] = $wbl;
                    
    }

    foreach ($tenders as $ticket_body) {
        // Create Ticket
        $ticketData = [
            "type_code" => "BULK_WAYBILL_LOADING_DELAY",
            "priority" => 5,
            "title" => " معاملة تأخر عن التحميل - " . $ticket_body[0]['tender_name'],
            "senderName" => 'مدارج للخدمات اللوجستية',
            "user_id" => null,
            "company_id" => 266770,
            "body" =>  $ticket_body
        ];

        $ticketFilters = new stdClass();
        $ticketFilters->ticket_type = "object";
        $ticketFilters->type_code = "BULK_WAYBILL_LOADING_DELAY";

        try {
        
            DBConnection::startTransaction();

            // Convert to stdClass objects
            $ticketData = json_decode(json_encode($ticketData,JSON_UNESCAPED_UNICODE));
            $ticket = $customerCare->createTicket($ticketData, $ticketFilters);

            // write ticket id in integration_details 
            foreach ($ticket_body as $wbl) {        
                $waybillBean = $waybillCore->getWaybillBasic($wbl['id'] , 0);
                $waybillBean->document = $waybillCore->appendTicketToDocument($waybillBean->document, $ticket['id'], $ticket['type'], $ticket['type_code'] );
                $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
            }    

            DBConnection::commitTransaction();

        } catch (\Throwable $th) {
            DBConnection::rollBackTransaction();
        }

        
    }
}