<?php
 
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

error_reporting(E_ERROR | E_PARSE);
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/truck_owner/truck_owner_core.php");
require_once (dirname(__FILE__)."/../core/account/account_core.php");

// prepare data
DBConnection::getInstance();
$truckOwnerCore = new TruckOwnerCore();
$accountCore = new AccountCore();
$erros = [];
$created_by = 0;


// users
$db_query = "
    select  DISTINCT (u.id + 530000) id, u.name,
    u.id as user_id  from user u where not exists (select id from account a where a.user_id = u.id) and name is not null and id not in (0)
  ";

// companies
 $db_query2 = "
            SELECT 
            DISTINCT (t.id + 500000) id, t.name,
            t.company_id as company_id
            FROM
            trucking_company_view t
            where id != 999999
            
            ";

$result =  DBConnection::runDatabaseQuery($db_query);

foreach ($result as $users) {
 
    try{

        $account_id = $users->id;
 
        // search if account already exist, skip
        $truckOwnerFilter = [['key'=>"id",'val' => $account_id]];
        $account_qry = $accountCore->searchAccount($truckOwnerFilter, 1, 0, $created_by  );    
        if($account_qry->found_rows >= 1){
            continue;
        }

        // prepare account data
        $account->id = $account_id;
        $account->name = $users->name;
        $account->user_id = $users->user_id;
        //$account->company_id = $users->company_id;
        $account->balance = 0;
        $account->minimum_balance = 0;
        $account->currency = 'JOD';
        $account->status = 'NEW';

        // create record
        $createAccountResult = DBConnection::insertDB("account",$account,$created_by);

        // activate it
        $updateStruct = new stdClass();
        $updateStruct->id = $account_id;
        $updateStruct->status = 'ACTIVE';

        DBConnection::updateDB("account",$updateStruct,$created_by);
    }catch(Exception $e){
        dump($e);
    }
}
