<?php

require_once("../includes/DBConnection.php");
require_once("../includes/debug.php");
require_once("../core/outgoing_integration/container.php");
require_once("../core/notification/notification_core.php");
$notificationCore = new NotificationCore();
DBConnection::getInstance();

$sqlQuery = "SELECT
    u.notification_token
    FROM
    user_hb hb,
    user_view u,
    waybill w
    WHERE
    JSON_UNQUOTE(JSON_EXTRACT(hb.hb, '$[0].app_version')) >= 55
        AND u.id = hb.user_id
    AND u.notification_token IS NOT NULL
    AND u.notification_token != ''
    AND u.driver_id = w.driver_id
    and w.status in ('NEW','APPROVED','ACTIVE','PENDING','ONROAD')
    union
    select u.notification_token from user u where id  in (2 , 10338)
";
$result =  DBConnection::runDatabaseQuery($sqlQuery);

$registration_ids = [];
foreach ($result as $t) {
    if ($t->notification_token != '') {
        $registration_ids[] = $t->notification_token;

        if (sizeof($registration_ids) >= 1000) {
            sendDataMessage($registration_ids);
            $registration_ids = [];
        }
    }
}
if (sizeof($registration_ids) > 0) {
    sendDataMessage($registration_ids);
}




// collect data from land trips drivers
$con = new Container();

$data = new stdClass();
$data->limit = 5000;
$data->filter = [];
$data->filter[] = [];
$data->method = "getLandTripsDriverNotificanTocken";
$end_point = '/landtrip';
$landTripResult = $con->callContainer($end_point, $data, 0);

$registration_ids2 = [];
foreach ($landTripResult['data'] as $t2) {
    if ($t2['notification_token'] != '') {
        $registration_ids2[] = $t2['notification_token'];

        if (sizeof($registration_ids2) >= 1000) {

            echo "send to land_trip_drivers, count: " . sizeof($registration_ids2);echo "  -  ";

            sendDataMessage($registration_ids2);
            $registration_ids2 = [];
        }
    }
}

if (sizeof($registration_ids2) > 0) {
    sendDataMessage($registration_ids2);
}




function sendDataMessage($registration_ids)
{
    $payload = new stdClass();
    $payload->type = "sendLocationsToServer";
    $payload->id = rand(0, 1000);
    $payload->callback_url = "https://api.minagate.com/saveLocations";

    $json_data = [
        "registration_ids" => $registration_ids,
        "data" => $payload
    ];
    $data = json_encode($json_data);
    //FCM API end-point
    $url = 'https://fcm.googleapis.com/fcm/send';
    //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
    $server_key = 'AAAA9frkPno:APA91bG21Duxxl7WAYqOfAfCsDbrn3R3rsg4ZMk7xkWu5hBYSOt9UiJgMBYCWRpjJWaPOZ9ijO-_8XkSOxtOHUP6IKIl5aM3irAQzsDrFlNTI_xYHqezrr2W9OD25k2n3dd9MSEN_peL';

    //header with content_type api key
    $headers = array(
        'Content-Type:application/json',
        'Authorization:key=' . $server_key
    );
    //CURL request to route notification to FCM connection server (provided by Google)
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    if ($result === FALSE) {
        echo ("sending notification is failed");
    }
    curl_close($ch);

    dump($result);
}
