<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");


$waybillOrderCore = new WaybillOrderCore();
$queueCore = new QueueCore();
$waybillCore = new waybillCore();


$erros = [];
$user_id = 2;

$filePath = 'waybill_7.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

$result = parseCsvFile($filePath,$startRow,$limit);
$erros = [];

foreach ($result as $waybill) {

  
    try{ 
        
        // create new waybill order for queue_id if not exist
        $tn = '60' . $waybill[3];
        $weight = $waybill[5];
     
        $searchFilter = [['key'=>'tn','val' => $tn],
                         ['key'=>'status','val' => 'ACTIVE']
                        ];
        $activeWaybill = $waybillCore->searchWaybills($searchFilter,1,0,$user_id);

        if($activeWaybill->data[0]->id){
            $waybillBean = $waybillCore->getWaybillBasic($activeWaybill->data[0]->id,$user_id);

            $weightBean = new stdClass();
            $weightBean->weight = $weight;
            $weightBean->location_id = 910001;                              // TODO
            $weightBean->timestamp = DBConnection::getSystemDate();
            $weightBean->weighbridge_id = 5000;                             // TODO
    
            $cargoBean = $waybillBean->document->cargo[0];
            $cargoBean->weights->loading->net_weight = $weight;
            $cargoBean->weights->timestamp = DBConnection::getSystemDate();
                            
            $waybillBean->document->cargo[0] = $cargoBean;
    

            $waybillCore->updateWeight($waybillBean,$waybillBean->id,$user_id);
            $updateBean = new stdClass();
            $updateBean->id = $waybillBean->id;
            $updateBean->status = "ONROAD";
            DBConnection::updateDB("waybill",$updateBean,$user_id);

            
            $updateBean = new stdClass();
            $updateBean->id = $waybillBean->id;
            $updateBean->status = "CLOSED";
            DBConnection::updateDB("waybill",$updateBean,$user_id);
    
    
            dump($waybillBean->wn);
            dump($tn);
        }    
    }
    catch (Exception $e){
        dump($e);die;
        $errorObj = new stdClass();
        $errorObj->tn = $tn;
        $errorObj->error = $e->getMessage();
        array_push($erros, $errorObj);
    }
 
}

 