<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');

// init 
DBConnection::getInstance();
$userCore = new UserCore();
$created_by =2;

// get all users with notification token
$searchFilter = [['key'=>'notification_token','val'=>[''], 'op' => 'not in']];
$userInfo = $userCore->searchUser($searchFilter,500,0,$created_by);
 
foreach ($userInfo->data as $user) {

    // clean notification token from all users
    $phone_array = json_decode($user->phone_array)[0];
    $new_phone_array = [];
    $phone_info = new stdClass();
    $phone_info->sim = $phone_array->sim;
    $phone_info->imei = $phone_array->imei;
    $phone_info->email = $phone_array->email?$phone_array->email:"";
    $phone_info->phone = $phone_array->phone;
    $phone_info->verification_method = $phone_array->verification_method;
    $new_phone_array[0]=$phone_info;

    $newUser = new stdClass();
    $newUser->id = $user->id;
    $newUser->phone_array =  json_decode(json_encode($new_phone_array)) ;

    DBConnection::updateDB("user", $newUser, $created_by);
}