<?php

ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
error_reporting(E_ERROR | E_PARSE);

require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");

$erros = [];
$output = [];

$created_by = 2;
$userCore = new UserCore();
$truckCore = new TruckCore();
$truckContractCore = new TruckContractCore();
$tenderCore = new TenderCore();

$filePath = 'auth.csv';
$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

$result = parseCsvFile($filePath,$startRow,$limit);
$erros = [];

DBConnection::getInstance();

foreach ($result as $truck) {

    try{

        // ----------------------------- prepare data -----------------------------------
        $tn = $truck[0];
        $auth_phone = $truck[1];

        
        // search for user    
        $auth_phone = convertToInternational($auth_phone);
        $searchFilter = [['key'=>'phone_array','val' =>$auth_phone ,'op' => 'json','node'=>'phone']];
        $userInfo = $userCore->searchUser($searchFilter,1,0,$created_by);       
        if($userInfo->found_rows == 0){
            $error = "$tn,$auth_phone,رقم الهاتف غير صحيح";       
            $file = fopen("result.csv","a");
            fputcsv($file,explode(',',$error));
            fclose($file);
            continue;
        }
       
        // search for truck 
        $searchFilter2 = [['key'=>'tn','val' =>$tn]];
        $truckInfo = $truckCore->searchTrucks($searchFilter2,1,0,$created_by);       
        if($truckInfo->found_rows == 0){
            $error = "$tn,$auth_phone,رقم الشاحنة غير صحيح";       
            $file = fopen("result.csv","a");
            fputcsv($file,explode(',',$error));
            fclose($file);
            continue;
        }

        // search for truck contract
        $searchFilter3 = [['key'=>'truck_id','val' =>$truckInfo->data[0]->id],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=> 'truck_owner_id' , 'val' => $userInfo->data[0]->truck_owner_id],
                           ['key'=>'contract_type','val' =>['AUTH','OWN'] , 'op' => 'in']];
        // get the truck_owner_id
        $contract_qry = $truckContractCore->searchTruckContracts($searchFilter3,1, 0, $created_by );
        if($contract_qry->found_rows == 0){
            $error = "$tn,$auth_phone,لا يوجد لصاحب الرقم المعتمد عقد وكالة او ملك";
 
            $file = fopen("result.csv","a");
            fputcsv($file,explode(',',$error));           
            fclose($file);
            continue;
        }

        // SEARCH FOR TENDER TRUCK
        $searchFilter4 = [['key'=>'tender_id','val' => 3],
                            ['key'=>'truck_id','val' => $truckInfo->data[0]->id],
                            ['key'=>'status','val' => ['ACTIVE','NEW'] , 'op'=>'in']
                        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($searchFilter4,1,0, $created_by );

        // update the tender truck
        $default_contact_user_id = $userInfo->data[0]->truck_owner_id;
        $tender_truck_id = $tenderTrucks->data[0]->id;

        $truckBean = new stdClass();
        $truckBean->id = $tender_truck_id;
        $truckBean->default_contact_user_id = $default_contact_user_id;
 
        DBConnection::updateDB("tender_truck",$truckBean,$created_by);
         
        $error = "$tn,$auth_phone,تمت";
        $file = fopen("result.csv","a");
        fputcsv($file,explode(',',$error));
        fclose($file);

        
    }
    catch (Exception $e){
        dump($e);
    }     
}

 