<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;


require_once(dirname(__FILE__) . "/../core/API.php");
require_once(dirname(__FILE__) . "/../includes/config.php");
require_once(dirname(__FILE__) . "/../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../includes/container_DBConnection.php");
require_once(dirname(__FILE__) . "/../includes/util.php");
require_once(dirname(__FILE__) . "/../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/customer_care.php");
require_once(dirname(__FILE__) . "/../core/social/social_core.php");
require_once(dirname(__FILE__) . "/../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../core/taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../core/tender_claim/tender_claim_core.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/Robot_agent.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/ACT.php");
require_once(dirname(__FILE__) . "/../core/outgoing_integration/mg_registrar.php");
require_once(dirname(__FILE__) . "/newsletter/engine.php");

class _jobs_interface extends API
{

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        DBConnection::getInstance();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ------------------------------------------------------------------------ //
    // ----------------- Send Happy Birthday SMS ------------------------------ //
    // ------------------------------------------------------------------------ //
    public function send_happy_birthday()
    {

        // read query
        $sqlQuery = "select phone from user where date_format(birth_date,'%m-%d')=date_format(now(),'%m-%d')";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, []);

        // loop on users and send SMS
        foreach ($result as $user) {
            $messageRecipient = convertToInternational($user->phone);
            $messageBody = "أسرة مدارج تتمنى لك عيد ميلاد سعيد مع أطيب تمنياتنا بالصحة";
            $result = sendSMS($messageRecipient, $messageBody);
        }
    }

    // -------------------------------------------------------------------------- //
    // ----------------- Send phosphate cash box balance to abu zaid ------------ //
    // -------------------------------------------------------------------------- //
    public function send_phophat_balance()
    {
        $accountCore = new AccountCore();

        // get account
        $accountBean = $accountCore->getAccountBasic("777412,19901", 0);

        // send SMS
        $messageBody = "الرصيد الحالي في الصندوق : $accountBean->balance";
        $messageRecipient = "0795780054";
        $r = sendSMS($messageRecipient, $messageBody);

        $messageRecipient = "0791233491";
        $r = sendSMS($messageRecipient, $messageBody);
    }


    // ------------------------------------------------------------------------ //
    // --------------- refresh jo petrol dashboard 1 each 30 minutes ---------- //
    // ------------------------------------------------------------------------ //
    public function refresh_jo_petrol_dashboard()
    {

        $waybillCore = new WaybillCore();
        $jo_petrol = new Jo_Petrol();
        $queueCore = new QueueCore();
        $tender_id = 11;

        // get fresh result from Jo_petrol + waybill
        $waybillFilter = [];
        $waybillFilter[] = ['key' => "tender_id", 'val' => $tender_id];
        $waybillFilter[] = ['key' => "status", 'val' => 'ACTIVE'];
        $waybillResult = $waybillCore->searchWaybills($waybillFilter, 1000, 0, 0);
        $result['ACTIVE'] = intval($waybillResult->found_rows);

        $pending_yard = $jo_petrol->fetchWaybills(2);

        if ($pending_yard['data']) {
            foreach ($pending_yard['data'] as $wbl) {
                if ($wbl['nf55nitm'] == 77) {
                    $result['PENDING']++;
                }
            }
        } else {
            $result['PENDING'] = 0;
        }


        // ------------------- على الطريق باتجاه التفريغ ---------------- 
        $waybillFilter = [];
        $waybillFilter[] = ['key' => "tender_id", 'val' => $tender_id];
        $waybillFilter[] = ['key' => "status", 'val' => 'ONROAD'];
        $waybillResult = $waybillCore->searchWaybills($waybillFilter, 1, 0, 0);
        $result['ONROAD'] = intval($waybillResult->found_rows);
        // $onroad_yard = $jo_petrol->fetchWaybills(3);
        // if($onroad_yard['data']){
        //     foreach ($onroad_yard['data'] as $wbl) {
        //         if ($wbl['nf55nitm'] == 77) {
        //             $result['ONROAD']++;
        //         }
        //     }
        // }else{
        //     $result['ONROAD'] = 0;
        // }

        // --------------------- Inside Shwaier ---------------------------
        $queueFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'q_id', 'val' => 2],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $in_shwaire_yard  = $queueCore->searchQueue($queueFilter, 10000, 0, 0);
        $result['IN_YARD'] = intval($in_shwaire_yard->found_rows);

        $after_yard = $jo_petrol->fetchWaybills(4);
        if ($after_yard['data']) {
            foreach ($after_yard['data'] as $wbl) {
                if ($wbl['nf55nitm'] == 77) {
                    $result['AFTER_YARD']++;
                }
            }
        } else {
            $result['AFTER_YARD'] = 0;
        }

        $in_discharge = $jo_petrol->fetchWaybills(5);
        if ($in_discharge['data']) {
            foreach ($in_discharge['data'] as $wbl) {
                if ($wbl['nf55nitm'] == 77) {
                    $result['IN_DISCHARGE']++;
                }
            }
        } else {
            $result['IN_DISCHARGE'] = 0;
        }

        // convert result
        $final_resut = [];
        $final_resut[] = ['على الطريق باتجاه التحميل', $result['ACTIVE'] ? $result['ACTIVE'] : 0];
        $final_resut[] = ['داخل موقع التحميل', $result['PENDING'] ? $result['PENDING'] : 0];
        $final_resut[] = ['على الطريق باتجاه التفريغ', $result['ONROAD'] ? $result['ONROAD'] : 0];
        $final_resut[] = ['داخل ساحة شويعر', $result['IN_YARD'] ? $result['IN_YARD'] : 0];
        $final_resut[] = ['على الطريق باتجاه المصفاة ', $result['AFTER_YARD'] ? $result['AFTER_YARD'] : 0];
        $final_resut[] = ['داخل المصفاة ', $result['IN_DISCHARGE'] ? $result['IN_DISCHARGE'] : 0];

        // save the result in database
        $sqlQuery = "insert into jo_petrol_dashboard_1
                        (details)
                        values (?)";
        $param = [json_encode($final_resut, JSON_UNESCAPED_UNICODE)];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
    }

    // -------------------------------------------------------------------------------- //
    // --------------- get a copy from zain cash server and insert it localy ---------- //
    // -------------------------------------------------------------------------------- //
    public function transferZainCashTrx()
    {

        $zain_cash = new Zain_Cash();
        $currentDate = DBConnection::getSystemDate();
        $fromTime = date('Y-m-d', strtotime($currentDate . "-1 days")) . " 00:00:00";
        $toTime = date('Y-m-d', strtotime($currentDate)) . " 00:00:00";

        // ------------------------------------- crude_oil Trx ------------------------------------------------

        $wallet_id = 'crude_oil';
        $transactions = $zain_cash->getTransactions($wallet_id, $fromTime, $toTime, null, null, "transferZainCashTrx", 0);
        foreach (array_reverse($transactions['RESULT']) as $trx) {

            //validate the trx is already logged
            $sql = "select * from waybill.zain_cash_log
            where DestinationMSISDN = ? and TransactionAmount = ? and TransactionDate = ?";
            $param = [$trx['DestinationMSISDN'], $trx['TransactionAmount'], $trx['TransactionDate']];
            $result = DBConnection::runBindDatabaseQuery($sql, $param);
            if (sizeof($result) > 0) {
                continue;
            }

            // insert the trx
            $sql = "insert into waybill.zain_cash_log (Comment, Description , DestinationMSISDN , Status , TransactionAmount , TransactionDate , TransactionReference, Wallet_id)
            values (?,?,?,?,?,?,?,?)";
            $param = [$trx['Comment'], $trx['Description'], $trx['DestinationMSISDN'], $trx['Status'], $trx['TransactionAmount'], $trx['TransactionDate'], $trx['TransactionReference'], $wallet_id];
            $result = DBConnection::runBindDatabaseQuery($sql, $param);
        }


        // ------------------------------------- Fuel Trx ------------------------------------------------

        $wallet_id = 'fuel';
        $transactions = $zain_cash->getTransactions($wallet_id, $fromTime, $toTime, null, null, "transferZainCashTrx", 0);
        foreach (array_reverse($transactions['RESULT']) as $trx) {

            //validate the trx is already logged
            $sql = "select * from waybill.zain_cash_log
            where DestinationMSISDN = ? and TransactionAmount = ? and TransactionDate = ?";
            $param = [$trx['DestinationMSISDN'], $trx['TransactionAmount'], $trx['TransactionDate']];
            $result = DBConnection::runBindDatabaseQuery($sql, $param);
            if (sizeof($result) > 0) {
                continue;
            }

            // insert the trx
            $sql = "insert into waybill.zain_cash_log (Comment, Description , DestinationMSISDN , Status , TransactionAmount , TransactionDate , TransactionReference,  Wallet_id)
            values (?,?,?,?,?,?,?,?)";
            $param = [$trx['Comment'], $trx['Description'], $trx['DestinationMSISDN'], $trx['Status'], $trx['TransactionAmount'], $trx['TransactionDate'], $trx['TransactionReference'], $wallet_id];
            $result = DBConnection::runBindDatabaseQuery($sql, $param);
        }
    }

    // -------------------------------------------------------------------------------- //
    // --------- create bulk loading delay ticket each morning at 8 am ---------------- //
    // -------------------------------------------------------------------------------- //
    public function createBulkLoadingDelay()
    {
        $customerCare = new CustomerCare();
        $waybillCore = new WaybillCore();

        // run query
        $db_query = "
            SELECT
            w.id,
            wn,
            w.create_date,
            tn,
            trn,
            document->>'$.carrier[0].driver.name' driver_name,
            document->>'$.carrier[0].driver.nn' driver_nn,
            document->>'$.carrier[0].driver.phone' driver_phone,
            document->>'$.tender.name' tender_name,
            w.tender_id,
            a.activity_date as enter_loading_location_time
            FROM
            waybill_view w left join activity a on a.action_code = 'CHANGE_STATUS' and a.waybill_id = w.id and a.object_new_status_code = 'PENDING'
            WHERE
            status NOT IN ('COMPLETE' , 'CLOSED', 'INACTIVE', 'REVOKED')
            AND loading_date IS NULL
            AND w.tender_id IN (3 , 11, 12, 13)
            AND create_date > '2020-10-05'
            AND (time_to_sec(timediff(now(),create_date )) / 3600) > 48
            and document->>'$.integeration_details.ticket[*].ticket_type_code' is null ";

        $result =  DBConnection::runDatabaseQuery($db_query);

        if (sizeof($result) > 0) {

            // loop on result to seperate waybill by tender
            foreach ($result as $waybill) {
                $wbl = [];
                $wbl['id'] = $waybill->id;
                $wbl['wn'] = $waybill->wn;
                $wbl['tn'] = $waybill->tn;
                $wbl['trn'] = $waybill->trn;
                $wbl['driver_name'] = $waybill->driver_name;
                $wbl['driver_nn'] = $waybill->driver_nn;
                $wbl['driver_phone'] = $waybill->driver_phone;
                $wbl['tender_name'] = $waybill->tender_name;
                $wbl['loading_weight'] = null;
                $wbl['create_date'] = $waybill->create_date;
                $wbl['enter_loading_location_time'] = $waybill->enter_loading_location_time;

                $tenders[$waybill->tender_id][] = $wbl;
            }

            foreach ($tenders as $ticket_body) {
                // Create Ticket
                $ticketData = [
                    "type_code" => "BULK_WAYBILL_LOADING_DELAY",
                    "priority" => 5,
                    "title" => " معاملة تأخر عن التحميل - " . $ticket_body[0]['tender_name'],
                    "senderName" => 'مدارج للخدمات اللوجستية',
                    "user_id" => null,
                    "company_id" => 266770,
                    "body" =>  $ticket_body
                ];

                $ticketFilters = new stdClass();
                $ticketFilters->ticket_type = "object";
                $ticketFilters->tender_id = $ticket_body[0]['tender_id'];

                try {

                    DBConnection::startTransaction();

                    // Convert to stdClass objects
                    $ticketData = json_decode(json_encode($ticketData, JSON_UNESCAPED_UNICODE));
                    $ticket = $customerCare->createTicket($ticketData, $ticketFilters);

                    // write ticket id in integration_details
                    foreach ($ticket_body as $wbl) {
                        $waybillBean = $waybillCore->getWaybillBasic($wbl['id'], 0);
                        $waybillBean->document = $waybillCore->appendTicketToDocument($waybillBean->document, $ticket['id'], $ticket['type'], $ticket['type_code']);
                        $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
                    }

                    DBConnection::commitTransaction();
                } catch (\Throwable $th) {
                    DBConnection::rollBackTransaction();
                }
            }
        }
    }

    // ------------------------------------------------------- //
    // --------- Archive closed tender orders ---------------- //
    // ------------------------------------------------------- //
    public function archive_tender_orders()
    {
        // read query
        $sqlQuery = "update tender_order set status = 'COMPLETE' , update_by=0 where
                     status = 'CLOSED' and order_date < date_format(now(),'%y-%m-%d')";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, []);
    }

    // ------------------------------------------------------------------------------------------------- //
    // -------------------- activate pending trucks on queue if activation date < now ------------------ //
    // ------------------------------------------------------------------------------------------------- //
    public function activate_pending_queues()
    {

        $db_query = " select id from queue
                      where status in('PENDING','HELD')
                      and activation_date<now()
                      and tender_id not in (11) ";
        $result =  DBConnection::runDatabaseQuery($db_query);

        if (sizeof($result) > 0) {
            $query = "call waybill.activate_pending_queues()";
            DBConnection::runDatabaseQuery($query);
        }

        if (!empty($result) && sizeof($result) > 0) {
            // send notification to fadi and tawfeeq about this
            $socialCore = new SocialCore();
            $size = sizeof($result);
            $wall_message = "تم فك شاحنات بعدد $size من التأجيل على جميع المشاريع";
            $notification_message = "تم فك شاحنات بعدد $size من التأجيل على جميع المشاريع";
            $socialCore->informSupervisor('فك التأجيل', $wall_message, $notification_message);

            // inform tawfeeq
            $socialCore->informSupervisor('فك التأجيل', $wall_message, $notification_message, 477);

            // inform Hamzeh
            $socialCore->informSupervisor('فك التأجيل', $wall_message, $notification_message, 2);
        }
    }

    public function sendEmailContainers()
    {
        $username = 'reports@minagate.com';
        $password = '?j@MBzLwp@7Q!bkW';
        $data = $this->_request->data;
        $emailText = $this->_request->emailText;
        $mail = new PHPMailer(true);
        $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      // Enable verbose debug output
        $mail->isSMTP();
        $mail->Host = "ssl://smtp.gmail.com";                       // Set the SMTP server to send through
        $mail->SMTPAuth = true;                                   // Enable SMTP authentication
        $mail->Username = $username;                              // SMTP username
        $mail->Password = $password;                              // SMTP password
        $mail->Port = 465;
        foreach ($data as $i => $ca_data) {
            if (isset($ca_data->email))
                try {
                    $mail->setFrom($username, 'Minagate');
                    $mail->addAddress($ca_data->email);     // Add a recipient
                    $mail->addReplyTo($username, 'Minagate');
                    // Content
                    $mail->CharSet = 'UTF-8';
                    $mail->isHTML(true);                                  // Set email format to HTML
                    $mail->Subject = 'فك حاويات';
                    $company_name = $ca_data->name;
                    $containers = implode('<br/>', array_unique($ca_data->containers));
                    $mail->Body = "<b>السادة $company_name المحترمون</b>";
                    $mail->Body .= '<br>';
                    $mail->Body .= $emailText;
                    $mail->Body .= '<br>';
                    $mail->Body .= $containers;
                    $mail->Body .= '<br/>';
                    $mail->Body .= '______________________________';
                    $mail->Body .= '<br/>';
                    $mail->Body .= 'شركة النصر للخدمات اللوجستية';
                    $mail->send();
                    echo 'Message has been sent';
                } catch (Exception $e) {
                    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                }
        }
    }

    // get the tender truck if the truck has multiple loads from the Jo petrol system
    public function getTenderTrucksBasedOnDuplicateLoads()
    {

        $jo_petrol = new Jo_Petrol();
        $waybill = $jo_petrol->getLoadsData();
    }

    // stop the tender truck if the truck has multiple loads from the Jo petrol system
    public function stopTenderTrucksBasedOnDuplicateLoads()
    {
        $jo_petrol = new Jo_Petrol();
        $waybill = $jo_petrol->applyPunishmentOnTrucks();
    }


    // unfreeze tender truck
    public function unfreezeTenderTruck()
    {

        $tender_truck_id = $this->_request->tender_truck_id;

        $tenderCore = new TenderCore();
        $tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', 0);
    }


    // --------------------------------------------------------------------------- //
    // ----------- generate the monthley news letter for jo petrol --------------- //
    // --------------------------------------------------------------------------- //
    public function generateJoPetrolMonthlyNewsletter()
    {

        try {
            $newsletter_id = 1;
            $newLetterEngine = new Engine();
            $newLetterEngine->prepareNewsLetter($newsletter_id);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
            logHamzeh("error in newsletter", $e->getMessage());
        }
    }

    // ----------------------------------------------------------------- //
    // ----------- generate the daily fainancial letter  --------------- //
    // ----------------------------------------------------------------- //
    public function generateDailyFainancialNewsletter()
    {
        try {
            $newsletter_id = 2;
            $newLetterEngine = new Engine();
            $newLetterEngine->prepareNewsLetter($newsletter_id);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
            //logHamzeh("error in newsletter" , $e->getMessage());
        }
    }


    // ----------------------------------------------------------------- //
    // ----------- generate the monthly fainancial letter  --------------- //
    // ----------------------------------------------------------------- //
    public function generateMonthlyFainancialNewsletter()
    {
        try {
            $newsletter_id = 3;
            $newLetterEngine = new Engine();
            $newLetterEngine->prepareNewsLetter($newsletter_id);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
            //logHamzeh("error in newsletter" , $e->getMessage());
        }
    }

    // ----------------------------------------------------------------- //
    // ----------- generate the monthly fainancial letter  --------------- //
    // ----------------------------------------------------------------- //
    public function send_email()
    {

        $email_title = $this->_request->email_title;
        $email_text = $this->_request->email_text;
        $email = $this->_request->email;

        try {
            sendEmail($email_title, $email_text, $email);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
            //logHamzeh("error in newsletter" , $e->getMessage());
        }
    }

    // ----------------------------------------------------------------- //
    // ----------- retry Process Downpayment Answer ------------ //
    // ----------------------------------------------------------------- //
    public function retryProcessDownpaymentAnswer()
    {

        $poll_id = $this->_request->poll_id;
        $recipient_user_id = $this->_request->recipient_user_id;
        $u_id = 14064;

        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->createProcessDownpaymentPollAnswerTask($poll_id, $recipient_user_id, $u_id, 0);
    }


    // ----------------------------------------------------------------- //
    // ----------- create JCB task ------------ //
    // ----------------------------------------------------------------- //
    public function jcb_check()
    {

        $voucher_id = $this->_request->voucher_id;
        $ref_id = $this->_request->ref_id;

        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->createCompleteZainCashTask($voucher_id, $ref_id, 1, 10);
    }


    // ----------------------------------------------------------------- //
    // ----------- create JCB task ------------ //
    // ----------------------------------------------------------------- //
    public function processVoucher()
    {

        $fps = new FPS();

        $voucher_id = $this->_request->voucher_id;

        // process voucher to start the payment process
        $processData = new stdClass();
        $processData->voucher_id = $voucher_id;
        $fps->processVoucherTrx($processData, $_SESSION['user_id']);
    }



    // ----------------------------------------------------------------- //
    // ----------- send down payment poll reminder --------------- //
    // ----------------------------------------------------------------- //
    public function sendDownPaymentPollReminder()
    {

        $notificationCore = new NotificationCore();
        $pollIntegration = new Poll();
        $userCore = new UserCore();

        // get inputs
        $attempts = $this->_request->attempts;
        $user_id = $this->_request->user_id;
        $poll_id = $this->_request->poll_id;
        $userBean = $userCore->getUserBasic($user_id, 0);

        // get recipients object
        $pollBean = $pollIntegration->getPoll($poll_id);
        $recipients = $pollBean["recipients"];
        foreach ($recipients as $key => $value) {
            if ($value['remote_user_id'] == $user_id  && $value['poll_id'] == $poll_id) {
                $rec = $value;
            }
        }
        $user_id = $rec["remote_user_id"];

        // if the user does not answer the poll
        if ($rec["answers"] == null) {
            switch ($attempts) {
                case 1:
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = rand();
                    $payload->message =  "لديك دفعة مقدمة جاهزة بانتظار المتابعة";
                    $notificationCore->sendDataMessage($user_id, $payload);

                    $payload2 = new stdClass();
                    $payload2->type = "check_waybill_order";
                    $payload2->id = rand(1, 1000);
                    $notificationCore->sendDataMessage($user_id, $payload2);

                    // $notification3 = new stdClass();
                    // $notification3->type = "set_notification";
                    // $notification3->id = rand(1, 1000);
                    // $notification3->title = "لديك دفعة مقدمة جاهزة بانتظار المتابعة";
                    // $payload3 = new stdClass();
                    // $payload3->type = "open_uri";
                    // $payload3->uri = "minagate://poll/" . $poll_id;
                    // $result = $notificationCore->sendDataMessage($user_id, $payload3, $notification3);

                    // send SMS
                    $messageRecipient = $userBean->phone;
                    $messageRecipient = convertToInternational($messageRecipient);
                    $messageBody = "لديك دفعة مقدمة جاهزة بانتظار المتابعة عبر تطبيق مدارج";
                    sendSMS($messageRecipient, $messageBody);

                    break;
                case 2:
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = rand();
                    $payload->message =  "لديك دفعة مقدمة جاهزة بانتظار المتابعة";
                    $notificationCore->sendDataMessage($user_id, $payload);

                    $payload2 = new stdClass();
                    $payload2->type = "check_waybill_order";
                    $payload2->id = rand(1, 1000);
                    $notificationCore->sendDataMessage($user_id, $payload2);

                    break;
                case 3:
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = rand();
                    $payload->message =  "لديك دفعة مقدمة جاهزة بانتظار المتابعة";
                    $notificationCore->sendDataMessage($user_id, $payload);

                    $payload2 = new stdClass();
                    $payload2->type = "check_waybill_order";
                    $payload2->id = rand(1, 1000);
                    $notificationCore->sendDataMessage($user_id, $payload2);

                    break;
                default:
                    break;
            }

            if ($attempts < 3) {
                $attempts++;
                $delay_in_seconds = 5 * 60; // 5 min
                $taskQueuesCore = new TaskQueuesCore();
                $taskQueuesCore->createDownpaymentPollReminderTask($attempts, $user_id, $poll_id, $delay_in_seconds);
            }
        }
    }


    public function submitLtrcCrudeOilWaybill()
    {

        $tn = $this->_request->tn;
        $trn = $this->_request->trn;
        $driver_nn = $this->_request->driver_nn;
        $tc_id = $this->_request->tc_id;
        $waybill_id = $this->_request->waybill_id;
        $waybillCore = new WaybillCore();
        $robot_agent = new Robot_agent();

        try {
            $ltrc_result = $robot_agent->submitLtrcCrudeOilWaybill($tn, $trn, $driver_nn, $tc_id);

            // write log in waybill about the result of the LTRC permit
            if ($ltrc_result->CODE == "SUCCESSFUL.OPERATION") {

                if ($ltrc_result->MESSAGE == "SUCCESS") {
                    $waybillCore->logActivity(
                        $waybill_id,
                        "تقديم وثيقة الهيئة",
                        "تم تقديم وثيقة الهيئة بنجاح",
                        "ADD_NOTES",
                        0
                    );
                } else {
                    $waybillCore->logActivity(
                        $waybill_id,
                        "خطأ في  تقديم وثيقة الهيئة",
                        $ltrc_result->MESSAGE,
                        "ADD_NOTES",
                        0
                    );
                }

                $result = [];
                $result['data'] = "SUCCESSFULT.OPERATION";
                parent::response($result);
            } else {
                $result = [];
                $result['data'] = $ltrc_result->CODE;
                parent::response($result);
            }
        } catch (Exception $e) {
            //insert failure task
            // $taskQueuesCore = new TaskQueuesCore();
            // $taskQueuesCore->createRobotFailurTask($tn, $trn, $driver_nn, $tc_id, $waybill_id);
        }
    }


    // --------------------------------------------------------------- //
    // ----------------- Send SMS  message to certain user------------ //
    // --------------------------------------------------------------- //
    public function send_SMS_to_target()
    {
        $recipient_phone = $this->_request->recipient_phone;
        $sms_body = $this->_request->sms_body;

        // send SMS
        sendSMS($recipient_phone, $sms_body);
    }


    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------------- Run each day at 12 PM to add flag to any delayed claim ----------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function handelFpsClaimsDueDate()
    {

        $fps = new FPS();

        // search for active claims
        $data = new stdClass();
        $data->filter = new stdClass();
        $data->filter->payee_reference_code = "TRUCK_OWNER";
        $data->filter->status_in = ["ACTIVE"];
        $data->limit = 1000;
        $claimsReuslt =  $fps->searchClaims($data, 0);

        // loop on all active claims
        foreach ($claimsReuslt['data'] as &$claim) {

            // compare it with now
            $formated_due_date  =  date_create($claim['due_date']);
            $formated_now_date  = date_create(DBConnection::getSystemDate());
            $dateDiff = date_diff($formated_now_date, $formated_due_date);

            // if due date < now , then add the flag
            if ($dateDiff->invert == 1) {
                $claim_details = json_decode($claim['claim_details']);
                if (!$claim_details->is_delayed) {

                    // update the record
                    $claim_details->is_delayed = 'true';
                    $data = new stdClass;
                    $data->claim_id = $claim['id'];
                    $data->details = $claim_details;
                    $claimsReuslt =  $fps->updateClaimDetails($data, 0);
                }
            }
        }
    }


    // ----------------------------------------------------------------------------------------- //
    // --------------------------- check on ACT system to fetch new data ----------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function LoadActContainerInfo()
    {

        $ACTCore = new ACT();

        // run the following query
        Con_DBConnection::getInstance();
        $sql = "select p.cid , p.declarationNumber, p.num
        from raw_jcd_permit p
            left join land_trip t on t.cid=p.cid
        where t.id is null
            and documentNumber like '%2022'
            and p.cid is not null
            and p.cid = 'SEGU2743998' ";
        $result = Con_DBConnection::runBindDatabaseQuery($sql, []);

        // loop on each record nad fetch from ACT
        foreach ($result as $container) {
            $data = $ACTCore->getActContainerInfo($container->cid);

            // insert new data into act_import
            $insert_sql = "INSERT INTO `container`.`raw_import` (`bl`, `cid`, `iso`, `line`, `category`, `kind`, `timein`)
                                                         VALUES (?, ?, ?, ?, 'Import', 'FCL', ?)";

            foreach ($data['ContainerAvailabilityResults'] as $act_con) {

                $insert_data = [];
                $insert_data[] = $act_con['BillOfLading'][0];
                $insert_data[] = $act_con['ContainerId'];
                $insert_data[] = $act_con['SizeTypeHeight'];

                $date = date_create($act_con['DischargedDate']);
                $temp_date = date_format($date, "Y-M-d H:i");;
                dump($temp_date);
                die;

                $insert_data[] = $temp_date;       //22-Jul-2021 02:54

                dump($data);
                die;
                $result = Con_DBConnection::runBindDatabaseQuery($insert_sql, $data);
            }
        }
    }



    // ----------------------------------------------------------------------------------------------------- //
    // --------------------- Send Advance Payment Reminder by sms and mobile app --------------------------- //
    // ----------------------------------------------------------------------------------------------------- //
    public function sendAdvancePaymentReminder()
    {
        $mg_registrar = new MG_registrar();
        $waybillCore = new WaybillCore();
        $userCore = new UserCore();
        $jormall_SMS_Gateway = new Jormall_SMS_Gateway();
        $socialCore = new SocialCore();
        $taskQueuesCore = new TaskQueuesCore();

        // prepare data
        $msg_title =  "سلف الديزل قبل التحميل";
        $sms_message = "احصل على سلفة ديزل قبل التحميل. للتفاصيل https://bit.ly/37qtios";
        $url = 'https://fcm.googleapis.com/fcm/send';
        $app_message = "تقدم شركة مدارج بالتعاون مع الشركة الوطنية للمحروقات خدمة صرف مستحقات الارسالية بالاضافة لخدمة صرف سلفة ديزل, حيث تستطيع الاستفادة من هذه الخدمة عن طريق ارسال طلب سلفة ديزل عبر التطبيق";

        // Call Nafith system to get permits on queue

        $strJsonFileContents = $mg_registrar->getGrnsBulkWbls();

        //---------- get data from json file
        $listOfTns = [];
        if (gettype($strJsonFileContents) == "string") {
            $records = json_decode($strJsonFileContents);
        } else {
            $records = $strJsonFileContents;
        }


        foreach ($records as $key => $value) {
            $listOfTns[] = $value['TN'];
        }

        //-------------
        // get waybill data
        $date_from = new DateTime(DBConnection::getSystemDate());
        $date_from = $date_from->format('Y-m-d');
        $date_from_week = date('Y-m-d', strtotime($date_from . ' - 60 days'));
        $searchFilter = [
            ['key' => 'create_date', 'val' => $date_from_week, 'op' => 'date greater than'],
            ['key' => 'status', 'val' => ['REVOKED', 'INACTIVE'], 'op' => 'not in'],
            ['key' => 'tn', 'val' => $listOfTns, 'op' => 'in'],
        ];
        $res = $waybillCore->searchWaybills($searchFilter, 1000, 0, 0);

        //------------

        //get list of phone numbers
        $listOfPhoneNumbers = [];
        foreach ($res->data as $key => $value) {
            $phone = json_decode($value->document)->carrier[0]->truck_owner->phone;
            if (!in_array($phone, $listOfPhoneNumbers)) {
                $listOfPhoneNumbers[] = $phone;
            }
        }

        //search users  in order to sort them
        $usersFilter = [
            ['key' => 'phone', 'val' => $listOfPhoneNumbers, 'op' => 'in']
        ];
        $users = $userCore->searchUser($usersFilter, 1000, 0, 0);
        $listOfUserIds = [];
        $smsReciepients = [];
        $appReciepients = [];

        foreach ($users->data as $user) {
            $listOfUserIds[] = $user->id;
            $notificationToken = json_decode($user->phone_array)[0]->notification_token;

            if (strlen($notificationToken) > 3) {
                $appReciepients[] = $user->id;
            } else {
                $smsReciepients[] = convertToInternational($user->phone);
            }
        }

        // start by sending SMS
        foreach (array_chunk($smsReciepients, 120) as $value) {
            $jormall_SMS_Gateway->sendBulkMessage($value, $sms_message);
        }

        // inform the user about this using app
        $sender_id = 266770;
        $sender_name = "شركة مدارج للخدمات اللوجستية ";
        $image = "https://storage.googleapis.com/waybill_system_config/MG_logo.png";
        $body = $socialCore->createPostBody($msg_title, $app_message, $image, $sender_id, $sender_name);

        foreach ($appReciepients as $user_id) {
            $taskQueuesCore->createPostOnWallTask($user_id, $body, $msg_title, true);
        }
        echo "App count: " . sizeof($appReciepients);
    }


    // ----------------------------------------------------------------------------------------------------- //
    // --------------------- Send Advance Payment Reminder by sms and mobile app --------------------------- //
    // ----------------------------------------------------------------------------------------------------- //
    public function act_imprt_data()
    {
        try {
            $con = new Container();

            $data = new stdClass();
            $data->method = "act_imprt_data";
            $end_point = '/declaration';

            $imprt_result = $con->callContainer($end_point, $data, $_SESSION['user_id']);

            if (strpos($imprt_result, 'SQLSTATE') !== false) {
                throw new Exception($imprt_result, 1);
            } else {
                parent::response("success");
            }
        } catch (Exception $e) {
            //sendSMS("0791233491",$e->getMessage);
            dump($e);
        }
    }


    // ---------------------------------------------------------------------------------------------------------------- //
    // ------------------ Run every hour to check the intege=ration status with nafith and JCD system ----------------- //
    // ---------------------------------------------------------------------------------------------------------------- //
    public function validateContainerDataIntegeration()
    {

        // run the following query to check nafith integeration
        Reg_DBConnection::getInstance();
        $customerCare = new CustomerCare();
        $con = new Container();

        $naf_permit_sql = "SELECT `create` FROM reg.naf_permits order by `create` desc limit 1";
        $nafith_result = Reg_DBConnection::runBindDatabaseQuery($naf_permit_sql, []);
        $last_nafith_permit = $nafith_result[0]->create;

        $formated_nafith_date   =  date_create($last_nafith_permit);
        $formated_now_date  =  date_create(DBConnection::getSystemDate());
        $dateDiff = date_diff($formated_nafith_date, $formated_now_date);

        // in case the last nafith permit is larger than 3 hours , create ticket for sys_admin
        // in case the ticket is already exist with status != COMPLETE send a reminder only
        if ($dateDiff->h >= 3) {

            // search for ticket
            $filter = array();
            $filter['type_code'] = 'FIX_NAFITH_INTEGRATION';
            $filter['status'] = ['NEW', 'ASSIGNED'];
            $tickets = $customerCare->searchTickets($filter, null, null, null);
            if (sizeof($tickets['data'])) {
                // send SMS reminder only every 3 hours
                if (fmod($dateDiff->h, 3) == 0) {
                    sendSMS("0791233491", "الربط الالكتروني بنظام نافذ لا يعمل منذ $dateDiff->h ساعة");
                }
            } else {
                $ticket = new stdClass();
                $ticket->title = "اصلاح الربط الالكتروني";
                $ticket->senderName = "مدارج للخدمات اللوجستية";
                $ticket->type_code = "FIX_NAFITH_INTEGRATION";
                $ticket->priority = 3;
                $ticket->company_id = 266770;
                $ticket->type = "CLIENT";
                $ticket->body = [
                    "last_permit" => $last_nafith_permit
                ];
                $customerCare->createTicket($ticket);
                sendSMS("0791233491", "الربط الالكتروني بنظام نافذ لا يعمل منذ $dateDiff->h ساعة");
            }
        } else {
            echo "Nafith check passed! ..... ";
        }


        // run the following query to check JCD integration
        $data = new stdClass();
        $data->method = "validateJCDIntegration";
        $end_point = '/declaration';
        $JCD_result = $con->callContainer($end_point, $data, 0);

        $lastJcdDec = $JCD_result[0]['lastJcdDec'];
        $formated_lastJcdDec   =  date_create($lastJcdDec);
        $dateDiff_1 = date_diff($formated_lastJcdDec, $formated_now_date);

        $lastJcdPerm = $JCD_result[0]['lastJcdPerm'];
        $formated_lastJcdPerm   =  date_create($lastJcdPerm);
        $dateDiff_2 = date_diff($formated_lastJcdPerm, $formated_now_date);

        $lastActImport = $JCD_result[0]['lastActImport'];
        $formated_lastActImport   =  date_create($lastActImport);
        $dateDiff_3 = date_diff($formated_lastActImport, $formated_now_date);


        if ($dateDiff_1->h >= 3 || $dateDiff_2->h >= 3 || $dateDiff_3->h >= 3) {
            //  search for ticket
            $filter = array();
            $filter['type_code'] = 'FIX_JCD_INTEGRATION';
            $filter['status'] = ['NEW', 'ASSIGNED'];
            $tickets = $customerCare->searchTickets($filter, null, null, null);
            if (sizeof($tickets['data'])) {
                // send SMS reminder only every 3 hours
                if (fmod($dateDiff_1->h, 3) == 0) {
                    sendSMS("0791233491", "الربط الالكتروني بنظام الجمارك لا يعمل منذ $dateDiff_1->h ساعة");
                }
            } else {
                $ticket = new stdClass();
                $ticket->title = "اصلاح الربط الالكتروني";
                $ticket->senderName = "مدارج للخدمات اللوجستية";
                $ticket->type_code = "FIX_JCD_INTEGRATION";
                $ticket->priority = 3;
                $ticket->company_id = 266770;
                $ticket->type = "CLIENT";
                $ticket->body = [
                    "lastJcdDec" => $lastJcdDec,
                    "lastJcdPerm" => $lastJcdPerm,
                    "lastActImport" => $lastActImport
                ];
                $customerCare->createTicket($ticket);
                sendSMS("0791233491", "الربط الالكتروني بنظام الجمارك لا يعمل منذ $dateDiff_1->h ساعة");
            }
        } else {
            echo "JCD check passed!";
        }
    }

    /* get check notification settings for clearing agent to whether send
       email, sms or phone notification */
    public function notifyCa()
    {
        // init objects
        $companyEmployeeCore = new CompanyEmployeeCore();
        $userCore = new UserCore();
        $clearingAgentCore = new ClearingAgentCore();
        $notificationCore = new NotificationCore();

        $cid = $this->_request->cid;
        $ca_id = $this->_request->ca_id;
        $tender_id = $this->_request->tender_id;
        $trigger = $this->_request->trigger;

        //search for the record
        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'ca_id', 'val' => $ca_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $service = $clearingAgentCore->searchTenderClearingAgent($serviceFilter, 100, 0, 0);

        if (!$service) {
            return;
        }

        // extract notification setting
        $serviceBean = $service->data[0];
        $details = json_decode($serviceBean->details);
        if ($details) {
            $settings   = $details->notificationSettings;
            if ($settings) {
                foreach ($settings as $setting) {
                    if (strtoupper($setting->trigger) == strtoupper($trigger)) {
                        $notificationSettings = $setting->frequency;
                    }
                }
            }
        }

        // in case no notification setting is defined , do nothing
        if (!$notificationSettings) {
            return;
        }

        // get ca info
        $companyInfo = $clearingAgentCore->getClearingAgentBasic($ca_id, 0);
        // get ca employee
        $employeeSearchFilter = [
            ['key' => 'company_id', 'val' => $companyInfo->company_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'user_id', 'val' => ['1', '2', '475'], 'op' => 'not in']            
        ];
        $employeeInfo = $companyEmployeeCore->searchCompanyEmployee($employeeSearchFilter, 100, 0, 0);


        foreach ($notificationSettings as $value) {

            if ($value->code == "every_service") {
                foreach ($value->chanel as $channel) {
                    if (strtoupper($channel) == 'APP') {

                        foreach ($employeeInfo->data as $employee) {
                            $user_id = $employee->user_id;
                            // send notification
                            $notification = new stdClass();
                            $notification->type = "set_notification";
                            $notification->id = rand(1, 1000);
                            $notification->title = "تم تسليم بون للحاوية رقم $cid";
                            $payload = new stdClass();
                            $payload->type = "open_uri";
                            $payload->uri = "";
                            $result = $notificationCore->sendDataMessage($user_id, $payload, $notification);
                        }
                    } elseif (strtoupper($channel) == "EMAIL") {

                        // send single container template

                        $email = $companyInfo->email;                        

                        $details = new stdClass();
                        $details->ca_id = $ca_id;
                        $details->cid = $cid;
                        $details->email = $email;
                        $newLetterEngine = new Engine();
                        $newLetterEngine->prepareNewsLetter(5, $details);
                    } elseif (strtoupper($channel) == "SMS") {

                        foreach ($employeeInfo->data as $employee) {
                            $user_id = $employee->user_id;
                            $userBean = $userCore->getUserBasic($user_id, 0);
                            $r = sendSMS($userBean->phone, "تم تسليم بون للحاوية رقم $cid");
                        }
                    }
                }
            }
        }
    }



    // -------------------------------------------------------- //
    // -------------- Send Daily Newsletter for ca ------------ //
    // -------------------------------------------------------- //
    public function sendDailyCaNewsletter()
    {

        // init objects
        $companyEmployeeCore = new CompanyEmployeeCore();
        $userCore = new UserCore();
        $clearingAgentCore = new ClearingAgentCore();
        $notificationCore = new NotificationCore();
        $con = new Container();

        // get all tender ca on tender 21 to see who activaed the service
        $tender_id = 21;
        $trigger = "bond_delivery";

        $serviceFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $tenderClearingAgents = $clearingAgentCore->searchTenderClearingAgent($serviceFilter, 1000, 0, 0);


        foreach ($tenderClearingAgents->data as $tender_ca) {

            $ca_id = $tender_ca->ca_id;

            $details = json_decode($tender_ca->details);

            if ($details) {
                $settings   = $details->notificationSettings;
                if ($settings) {
                    $notificationSettings = null;
                    foreach ($settings as $setting) {
                        if (strtoupper($setting->trigger) == strtoupper($trigger)) {
                            $notificationSettings = $setting->frequency;
                            break;
                        }
                    }

                    if ($notificationSettings) {

                        // get ca info
                        $companyInfo = $clearingAgentCore->getClearingAgentBasic($ca_id, 0);
                        // get ca employee
                        $employeeSearchFilter = [
                            ['key' => 'company_id', 'val' => $companyInfo->company_id],
                            ['key' => 'status', 'val' => 'ACTIVE'],
                            ['key' => 'user_id', 'val' => ['1', '2', '475'], 'op' => 'not in']                            
                        ];
                        $employeeInfo = $companyEmployeeCore->searchCompanyEmployee($employeeSearchFilter, 100, 0, 0);

                        // see total number of bond delivery for current day for each ca
                        $land_trip_data = new stdClass();
                        $land_trip_data->method = "generateContaienerReport";
                        $land_trip_data->ca_id = $tender_ca->ca_id;
                        $end_point = "/landtrip_service";
                        $res = $con->callContainer($end_point, $land_trip_data, 0);

                        $total = $res['total_number'];
                        $send_message = "تم تسليم بونات بعدد : $total حاوية";

                        // send based on channel
                        foreach ($notificationSettings as $value) {
                            if ($value->code == "daily") {
                                foreach ($value->chanel as $channel) {
                                    if (strtoupper($channel) == 'APP') {

                                        foreach ($employeeInfo->data as $employee) {
                                            $user_id = $employee->user_id;
                                            // send notification
                                            $notification = new stdClass();
                                            $notification->type = "set_notification";
                                            $notification->id = rand(1, 1000);
                                            $notification->title = $send_message;
                                            $payload = new stdClass();
                                            $payload->type = "open_uri";
                                            $payload->uri = "";
                                            $notificationCore->sendDataMessage($user_id, $payload, $notification);
                                        }
                                    } elseif (strtoupper($channel) == "EMAIL") {

                                        // $email = $companyInfo->email;
                                        $email = "hhirzallah@minagate.com";

                                        $details = new stdClass();
                                        $details->ca_id = $ca_id;
                                        $details->email = $email;
                                        $newLetterEngine = new Engine();
                                        $newLetterEngine->prepareNewsLetter(4, $details);
                                    } elseif (strtoupper($channel) == "SMS") {

                                        foreach ($employeeInfo->data as $employee) {
                                            $user_id = $employee->user_id;
                                            $userBean = $userCore->getUserBasic($user_id, 0);
                                            $r = sendSMS($userBean->phone, $send_message);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

new _jobs_interface();
