<?php

require_once ('../includes/DBConnection.php');

DBConnection::getInstance();

$start_date = $_GET["date"];
$date = new DateTime($start_date);
$end_date = $date->add(new DateInterval('P1D'))->format('Y-m-d');

$sql = "SELECT ".
" COUNT(wo.id) cnt, ".
" CASE ".
"     WHEN q.trail_minor_tt = '203' THEN 'تريلا' ".
"     WHEN q.trail_minor_tt = '201' THEN 'قلاب' ".
"     else 'الكل' ".
" END tt,   ".
" CASE ".
"     WHEN wo.status = 'APPROVED' THEN 'موافق عليه' ".
"     WHEN wo.status = 'CLOSED' THEN 'أكد وصول شاحنة' ".
" END status,  ".
" wo.cargo_name ".
" FROM ".
" waybill_order_view wo, ".
" truck_view t, ".
" queue_view q ".
" WHERE ".
" wo.truck_id = t.id ".
" and wo.queue_id = q.id ".
" AND wo.create_date >= '$start_date' ".
" AND wo.create_date < '$end_date' ".
" and wo.status in ('APPROVED','CLOSED') " .
" GROUP BY q.trail_minor_tt , wo.status,  wo.cargo_name ";

$trx_query = DBConnection::runDatabaseQuery($sql);

$result = [];
foreach ($trx_query as $row) {
    $temp = new stdClass();
    $temp->count = $row->cnt;
    $temp->status = $row->status;
    $temp->cargo_name = $row->cargo_name;
    $temp->tt = $row->tt;

    echo($row->cargo_name . "=> " .  $row->cnt  . " : " . $row->status ." " .  $row->tt . "<br/>");
}
 