<?php

// init page
ini_set('max_execution_time', 24000); //24000 seconds = 6.6 hours
error_reporting(E_ERROR | E_ALL);

// import required files
require_once ('../../includes/util.php');
require_once ('../../core/truck/truck_core.php');
require_once ('../../core/account/account_core.php');
require_once ('../../core/truck_owner/truck_owner_core.php');
require_once ('../../core/truck_contract/truck_contract_core.php');
require_once ('../../core/tender/tender_core.php');
require_once ('../../core/queue/queue_core.php');


// init required objects
$created_by = 1;
DBConnection::getInstance();
$truckCore = new TruckCore();
$accountCore = new AccountCore();
$truckOwnerCore = new TruckOwnerCore();
$truckContractCore = new TruckContractCore();
$tenderCore= new TenderCore();
$queueCore = new QueueCore();

 
// ------------------------------ search for a number of trucks ---------------------------------
$truckFilter = [['key'=>"status",'val' => 'ACTIVE'],['key'=>"minor_tt",'val' => '9'],['key'=>"cat",'val' => 'TRUCK']];
$truckOwnerQuery = $truckCore->searchTrucks($truckFilter,20,1010,$created_by);
 
// loop on all trucks
foreach ($truckOwnerQuery->data as $truck) {
    
    try{
        // ------------------------------ create account if not exist --------------------------------------
        $truckOwnerFilter = [['key'=>"id",'val' => $truck->truck_owner_id]];
        $truckOwnerQuery = $truckOwnerCore->searchTruckOwner($truckOwnerFilter,5000,0,$created_by);

        $truckOwner = $truckOwnerQuery->data[0];
        $account_id = $truckOwner->id + 100000;

        // search if account already exist, skip
        $accountFilter = [['key'=>"id",'val' => $account_id]];
        $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, $created_by);    
        if($account_qry->found_rows  == 0){
            // prepare account data
            $account = new stdClass();
            $account->id = $account_id;
            $account->name = $truckOwner->name;
            $account->user_id = $truckOwner->user_id;
            $account->company_id = $truckOwner->company_id;
            $account->balance = 0;
            $account->minimum_balance = 0;
            $account->currency = 'JOD';
            $account->status = 'NEW';

            // create record
            DBConnection::insertDB("account",$account,$created_by);

            // activate it
            $updateStruct = new stdClass();
            $updateStruct->id = $account_id;
            $updateStruct->status = 'ACTIVE';

            DBConnection::updateDB("account",$updateStruct,$created_by);
        }

        // --------------------------------------- create tender_trucks -------------------------------------------

        // if the tender_truck is already exist, skip
        $tenderSearchFilter = [['key'=>'truck_id','val' =>$truck->id],
                                ['key'=>'tender_id','val' =>4],
                                ['key'=>'status','val' =>['ACTIVE','NEW'] , 'op'=> 'in']];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderSearchFilter,1,0,0) ;
        if($tenderTruckResult->found_rows > 0){
            echo "skip-";
            continue;
            //skip this truck
        }
 
        // prepare questionare
        $questionare = [];
        $question1 = new stdClass();
        $question1->id = 1;    
        $question1->val = ["91010018"];
        array_push($questionare,$question1);
        $question2 = new stdClass();
        $question2->id = 2;
        $question2->val = ["91090000"];
        array_push($questionare,$question2);
        $question3 = new stdClass();
        $question3->id = 3;
        $question3->val = '_TRUCK_$_MINOR_TT_';
        array_push($questionare,$question3);

        // prepare financial details
        $financial = new stdClass();
        $financial->waybill_beneficiary_account = $account_id;
        $financial->advance_payment_account = [];
        $advance_payment = new stdClass();
        $advance_payment->id = 1;
        $advance_payment->name = "deisil";
        $advance_payment->status = "active";
        $advance_payment->has_warning = false;
        $advance_payment->target_account = null;
        array_push($financial->advance_payment_account,$advance_payment);

        // prepare photo
        $photo = new stdClass();
        $photo->url = "";
        $photos = [];
        array_push($photos,$photo);

        //prepare the trailer_id
        $truckContractsFilter = [['key'=>'truck_owner_id','val' =>$truck->truck_owner_id],
                                ['key' => 'cat', 'val' => ['TRAIL-HALF'], 'op' => 'in'],
                                ['key' => 'status', 'val' => ['ACTIVE','NEW'], 'op' => 'in'],
                                ['key'=>'contract_type','val' =>['OWN','AUTH'] , 'op' => 'in']];
        $contract_qry = $truckContractCore->searchTruckContracts($truckContractsFilter,null, 0, $created_by);
        if($contract_qry->found_rows > 0)
            $trailer_id = $contract_qry->data[0]->truck_id;
        else
            $trailer_id = null;

        // fill the bean
        $tender_truck_bean = new stdClass();
        $tender_truck_bean->tender_id = 4;
        $tender_truck_bean->q_id = null;
        $tender_truck_bean->truck_id = $truck->id;
        $tender_truck_bean->tender_company_id = 52;
        $tender_truck_bean->trailer_id = $trailer_id;
        $tender_truck_bean->questionnaire = $questionare;
        $tender_truck_bean->financial_details = $financial;
        $tender_truck_bean->photos = $photos;
        $tender_truck_bean->default_contact_user_id = $truck->truck_owner_id;
        $tender_truck_bean->status = 'NEW';
        $tender_truck_bean->created_by = $created_by;

        // create record
        $insertResult = DBConnection::insertDB("tender_truck",$tender_truck_bean,$created_by);
        

        // remove it from Adel queue
        $queueFilter = [['key'=>'q_id','val' =>1],
                                ['key'=>'tender_id','val' =>3],
                                ['key'=>'status','val' =>['ACTIVE','PENDING','HELD'] , 'op'=> 'in']];
        $queueResult = $queueCore->searchQueue($queueFilter,1,0,0) ;

        if($queueResult->found_rows > 0){
            $queue_id = $queueResult->data[0]->id;
            $queueCore->changeStatus($queue_id,'INACTIVE',0);
            echo "done";
        }       

        // insert it into queue 
        if($trailer_id){
            $addQueueId = $queueCore->addQueue($truck->id,null,$trailer_id, 1,4,$created_by);
        }


        // accept it in tender truck       
        $tenderCore->changeTruckStatus($insertResult[0]['@id'],'ACTIVE',$created_by);
       
    }
    catch(Exception $e){
        dump($e);
    }
 
}



// --------------------------- DB Query ------------------------- //
/*

#remove trucks from tender
update tender_truck set status = 'INACTIVE', update_by=2 where id in (
SELECT 
    id
FROM
    tender_truck
WHERE
    tender_id = 4
    and status = 'NEW'
)
 
# fix minor tt
 update truck set tt = 920300, minor_tt = 301 , update_by=2 where id in (
 select id from truck where id in (
 select trailer_id from queue WHERE
    tender_id = 4
    and status = 'ACTIVE'
    )
)

#update join contract
update truck_owner set truck_owner_id = 410048 where id in (
select id from truck_contract where truck_id in (
 select truck_id from queue WHERE
    tender_id = 4
    and status = 'ACTIVE'
    )
    and contract_type = 'JOIN'
    and status in( 'ACTIVE','NEW')
    )

    */