<?php
require_once (dirname(__FILE__)."/API.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);

class MRZ extends API{
    // the request of each call
    private $_request = array();

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------- //
    // ----------------- Process Image -------------------------------- //
    // ---------------------------------------------------------------- //
    public function processImage(){

        // validate request
        $HTTP_PUBLIC_KEY = $_SERVER['HTTP_PUBLIC_KEY'];

        $this->validatePublicKey($_SERVER['HTTP_PUBLIC_KEY']);

        // define the output image name
        $image_name = dirname(__FILE__) . '/images/temp_' . rand() . '.jpg';
        if($this->_request->image_64){
            $base64_string = $this->_request->image_64;
            $data = explode(',', $base64_string);
            $content = base64_decode($data[1]);
            $file = fopen($image_name, "wb");
            fwrite($file, $content);
            fclose($file);
            $url = "1";
        }

        if(!$url){
            echo "INVALID IMAGE";die;
        }

        // run the mrz python script
        $mrzResult = json_decode(file_get_contents("http://127.0.0.1:5000/?i=" . $image_name));        
        foreach ($mrzResult as $item) {
            $item = trim($item, "<");
        }
        $mrzResult->{"names"} = ucwords(strtolower($mrzResult->{"names"}));
        $mrzResult->{"surname"} = ucwords(strtolower($mrzResult->{"surname"}));                      
        
        // Return formatted MRZ result
        echo JsonResponse::create($mrzResult);
             
    }


    private function validatePublicKey($key){
        switch ($key) {
            //MRZ APP
            case 'kKGUqh6YfextZ4pnEgh9Zub6dcvNrDyHcqJJfGD5qQDGYSGCbnAfyduYX5dZcJq2':
                return true;
                break;
            
            default:
                echo("INVALID TOKEN");
                die;
                break;
        }
    }


}

new MRZ();