<?php
require_once(dirname(__FILE__) . "/../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../core/social/social_core.php");

require_once(dirname(__FILE__) . "/Jormall_sms_gateway.php");
require_once(dirname(__FILE__) . "/Javna_sms_gateway.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// ---------------------------------------------------------------------------------- //
// ------- convert any given number to the international form (+962 xxxxxxxxx) ------ //
// ---------------------------------------------------------------------------------- //
function convertToInternational($mobile)
{
    if (substr($mobile, 0, 4) === "+962" && strlen($mobile) === 14) {
        return $mobile;
    }

    if (substr($mobile, 0, 4) === "962" && strlen($mobile) === 13) {
        return "+" . $mobile;
    }

    if (substr($mobile, 0, 3) === "962" && strlen($mobile) === 12) {
        return "+" . $mobile;
    }

    if (strlen($mobile) === 10) {
        return "+962" . substr($mobile, 1);
    }

    if (strlen($mobile) === 9) {
        return "+962" . $mobile;
    }

    return $mobile;
}

// ------------------------------------------------------------- //
// ------- clean any string to be safe updated in Database------ //
// ------------------------------------------------------------- //
function cleanName($name)
{
    $contact_name = str_replace("\\t", "", $name);
    $contact_name = trim(preg_replace('/\t+/', '',  $contact_name));
    $contact_name = stripcslashes($contact_name);
    $contact_name = str_replace("'", "", $name);

    return $contact_name;
}

// ------------------------------------------------------------------------------------ //
// --------- compare if there is any difference between user bean and DB bean --------- //
// ------------------------------------------------------------------------------------ //
function compareObject($formBean, $DBBean)
{
    foreach ($DBBean as $key => $value) {

        if ($formBean->$key) {

            if ($formBean->$key != $value) {
                return false;
            }
        }
    }
    return true;
}


// --------------------------------------------------------------------------------------- //
// ------------------------------ validation rules --------------------------------------- //
// --------------------------------------------------------------------------------------- //
function validateInput($value, $rules, $status)
{

    $validationResult = new stdClass();

    foreach ($rules as $rule) {

        // continue only of the validation status is * or equal to object status
        $validationStatus = explode(',', $rule['details']['status']);
        if ($validationStatus == "*" || in_array($status, $validationStatus)) {

            switch ($rule[type]) {
                case 'isRequried': {
                        if (trim(strlen($value)) == 0 || $value == NULL) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.MISSING.MANDATORY.FIELD';
                            return $validationResult;
                        }
                        break;
                    }
                case 'maxLength': {
                        if (trim(strlen($value)) > $rule['details']['maxLen']) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.FIELD.EXCEEDED.MAXLENGTH';
                            return $validationResult;
                        }
                        break;
                    }
                case 'minValue': {
                        if (trim(intval($value)) < $rule['details']['minLen']) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.FIELD.LESS.MINLENGTH';
                            return $validationResult;
                        }
                        break;
                    }
                case 'minMaxValue': {
                        if (trim(intval($value)) < $rule['details']['minVal'] || trim(intval($value)) > $rule['details']['maxVal']) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.FIELD.NOT.IN.RANGE';
                            return $validationResult;
                        }
                        break;
                    }

                case 'isNumber': {
                        if (!trim(is_numeric($value))) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.INCORRECT.FIELD';
                            return $validationResult;
                        }
                        break;
                    }
                case 'isArabic': {
                        if (!preg_match('/[أ-ي]/ui', $value)) {
                            $validationResult->error_message = $rule['details']['error_message'] ? $rule['details']['error_message'] : 'VALIDATION.INCORRECT.FIELD';
                            return $validationResult;
                        }
                        break;
                    }
            }
        }
    }

    // in case no error is found
    return new stdClass();
}


// --------------------------------------------------------------------------------------------------- //
// --------------- map the new values in the user input bean into DB Bean and then return it --------- //
// --------------------------------------------------------------------------------------------------- //
function mapBeanToDBBean($userBean, $DB_Bean)
{

    foreach ($userBean as $key => $value) {
        $DB_Bean->$key = $value;
    }
    return $DB_Bean;
}



// ---------------------------------------------------------------------------------------------------- //
// ----------------------- Get auto actions for a certain object -------------------------------------- //
// ---------------------------------------------------------------------------------------------------- //
function getAutoAction($object_code, $object_status, $object_new_status, $user_id, $u_id)
{

    // get the roles for this user
    $userCore = new UserCore();
    $user_profile = $userCore->getUserProfile($user_id, $u_id);

    // loop on the roles
    $user_roles = explode(",", $user_profile['USER_ROLES']);
    foreach ($user_roles as $userRole) {
        // get the wf for each role that has ('CHANGE_STATUS', OBJECT, ROLE_STATUS,auto_action=1)
        foreach ($user_profile['WF'] as $WF_node) {
            if ($WF_node->object_code == $object_code) {
                if (
                    $WF_node->object_status_code == $object_status &&
                    $WF_node->action_code == 'CHANGE_STATUS' &&
                    $WF_node->object_new_status == $object_new_status &&
                    $WF_node->auto_action == 1
                ) {

                    return $WF_node;
                }
            }
        }
    }
    return null;
}


// ----------------------------------------------------------------------- //
// ----------------------- Has Auth  ------------------------------------- //
// ----------------------------------------------------------------------- //
function hasAuth($object_code, $action_code, $object_status, $object_new_status, $role_code)
{

    $sqlQuery = "select id from wf where object_code = ? and action_code = ? and object_status_code = ? and object_new_status_code = ?
                 and status = 'ACTIVE' and role_code = ?";
    $param = [$object_code, $action_code, $object_status, $object_new_status, $role_code];
    $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

    if (sizeof($result) > 0) return true;
    return false;
}





// ---------------------------------------------------------------------------------------------------- //
// ----------------------- get the page content as DOM Element ---------------------------------------- //
// ---------------------------------------------------------------------------------------------------- //
function getPage($url)
{

    $useragent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36';
    $timeout = 10;
    $dir            = dirname(__FILE__);
    $cookie_file    = $dir . '/cookies/' . md5($_SERVER['REMOTE_ADDR']) . '.txt';

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_FAILONERROR, true);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_ENCODING, "");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
    curl_setopt($ch, CURLOPT_REFERER, 'http://www.google.com/');
    $content = curl_exec($ch);
    if (curl_errno($ch)) {
        return curl_error($ch);
    } else {
        return $content;
    }

    curl_close($ch);
}


// ---------------------------------------------------------------------------------------------------- //
// ----------------------- get the platform (OS) from any given request ------------------------------- //
// ---------------------------------------------------------------------------------------------------- //
function getOS($user_agent)
{

    $os_platform  = "Unknown OS Platform";

    $os_array     = array(
        '/windows nt 10/i'      =>  'Windows 10',
        '/windows nt 6.3/i'     =>  'Windows 8.1',
        '/windows nt 6.2/i'     =>  'Windows 8',
        '/windows nt 6.1/i'     =>  'Windows 7',
        '/windows nt 6.0/i'     =>  'Windows Vista',
        '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
        '/windows nt 5.1/i'     =>  'Windows XP',
        '/windows xp/i'         =>  'Windows XP',
        '/windows nt 5.0/i'     =>  'Windows 2000',
        '/windows me/i'         =>  'Windows ME',
        '/win98/i'              =>  'Windows 98',
        '/win95/i'              =>  'Windows 95',
        '/win16/i'              =>  'Windows 3.11',
        '/macintosh|mac os x/i' =>  'Mac OS X',
        '/mac_powerpc/i'        =>  'Mac OS 9',
        '/linux/i'              =>  'Linux',
        '/ubuntu/i'             =>  'Ubuntu',
        '/iphone/i'             =>  'iPhone',
        '/ipod/i'               =>  'iPod',
        '/ipad/i'               =>  'iPad',
        '/android/i'            =>  'Android',
        '/blackberry/i'         =>  'BlackBerry',
        '/webos/i'              =>  'Mobile'
    );

    foreach ($os_array as $regex => $value)
        if (preg_match($regex, $user_agent))
            $os_platform = $value;

    return $os_platform;
}


// ---------------------------------------------------------------------------------------------- //
// ----------------------- get the browser from any given request ------------------------------- //
// ---------------------------------------------------------------------------------------------- //
function getBrowser($user_agent)
{

    $browser = "Unknown Browser";

    $browser_array = array(
        '/msie/i'      => 'Internet Explorer',
        '/firefox/i'   => 'Firefox',
        '/safari/i'    => 'Safari',
        '/chrome/i'    => 'Chrome',
        '/edge/i'      => 'Edge',
        '/opera/i'     => 'Opera',
        '/netscape/i'  => 'Netscape',
        '/maxthon/i'   => 'Maxthon',
        '/konqueror/i' => 'Konqueror',
        '/mobile/i'    => 'Handheld Browser'
    );

    foreach ($browser_array as $regex => $value)
        if (preg_match($regex, $user_agent))
            $browser = $value;

    return $browser;
}


// ---------------------------------------------------------------------------- //
// ------------------ Extract the phone out of its JSON node ----------------- //
// --------------------------------------------------------------------------- //
function extractPhone($phoneArr)
{
    $phoneJSON = json_decode($phoneArr);
    return $phoneJSON[0]->phone;
}

// ------------------------------------------------------------------- //
// ------------------ Extract the logo out of its JSON node  ----------------- //
// ------------------------------------------------------------------- //
function extractlogo($phoneArr)
{
    $PhotoJSON = json_decode($phoneArr);

    if ($PhotoJSON) {
        foreach ($PhotoJSON as $photo) {
            if ($photo->type == 'logo') {
                return $photo->url;
            }
        }
    }
    return null;
}

// ------------------------------------------------------------------- //
// ------------------ replace first occurence  ----------------- //
// ------------------------------------------------------------------- //
function str_replace_first($from, $to, $content)
{
    $from = '/' . preg_quote($from, '/') . '/';
    return preg_replace($from, $to, $content, 1);
}


// --------------------------------------------------------- //
// ------------------ get web page content ----------------- //
// --------------------------------------------------------- //
function getWebPage($url, $cookiesIn = '', $timeout = 30)
{
    $options = array(
        CURLOPT_RETURNTRANSFER => true,     // return web page
        CURLOPT_HEADER         => true,     //return headers in addition to content
        CURLOPT_FOLLOWLOCATION => true,     // follow redirects
        CURLOPT_ENCODING       => "",       // handle all encodings
        CURLOPT_AUTOREFERER    => true,     // set referer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
        CURLOPT_TIMEOUT        => $timeout, // timeout on response
        CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
        CURLINFO_HEADER_OUT    => true,
        CURLOPT_SSL_VERIFYPEER => true,     // Validate SSL Certificates
        CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.89 Safari/537.36',
        CURLOPT_COOKIE         => $cookiesIn
    );

    $ch      = curl_init($url);
    curl_setopt_array($ch, $options);
    $rough_content = curl_exec($ch);
    $err     = curl_errno($ch);
    $errmsg  = curl_error($ch);
    $header  = curl_getinfo($ch);
    curl_close($ch);

    $header_content = substr($rough_content, 0, $header['header_size']);
    $body_content = trim(str_replace($header_content, '', $rough_content));
    $pattern = "#Set-Cookie:\\s+(?<cookie>[^=]+=[^;]+)#m";
    preg_match_all($pattern, $header_content, $matches);
    $cookiesOut = implode("; ", $matches['cookie']);

    $header['errno']   = $err;
    $header['errmsg']  = $errmsg;
    $header['headers']  = $header_content;
    $header['content'] = $body_content;
    $header['cookies'] = $cookiesOut;
    return $header;
}

// -------------------------------------------------------------- //
// ----------------------- Parse CSV file ----------------------- //
// -------------------------------------------------------------- //
function parseCsvFile($filePath, $startRow, $limit)
{
    $result = [];
    $row = 0;
    $processedRows = 0;

    if (($handle = fopen($filePath, "r")) !== FALSE) {
        while (($data = fgetcsv($handle, 10000, ",")) !== FALSE) {

            $row++;
            if ($row < $startRow) {
                continue;
            }

            array_push($result, $data);

            $processedRows++;
            if ($processedRows >= $limit) {
                break;
            }
        }
    }

    fclose($handle);

    return $result;
}

// ------------------------------------------------------------------------------- //
// ------------------- prepare location values ----------------------------------- //
// ------------------------------------------------------------------------------- //
function prepareLocationValue($input, $cargoBean)
{

    if (preg_match('/_*[a-z]_\$_*[a-z]_*/', $input)) {
        $source = explode("$", $input)[0];    // split by $ and take the first part
        $source = trim($source, '_');       // remove first and last _
        $val = explode("$", $input)[1];       // split by $ and take the second part
        $val = trim($val, '_');             // remove first and last _

        if ($source == 'cargo') {
            return $cargoBean->$val;
        } else if ($source == 'system') {
            //TODO
        }
    } else {
        return $input;
    }
}



// ------------------------------------------------------------------------------- //
// ------------------- prepare date array to dateInt function --------------------- //
// ------------------------------------------------------------------------------- //
function dateArray($date, $trim = true)
{
    $result = array();
    $result['day'] = ($trim == true) ? ltrim(substr($date, 8, 2), '0') : substr($date, 8, 2);
    $result['month'] = ($trim == true) ? ltrim(substr($date, 5, 2), '0') : substr($date, 5, 2);
    $result['year'] = substr($date, 0, 4);
    $result['hour'] = substr($date, 11, 2);
    $result['minutes'] = substr($date, 14, 2);
    $result['seconds'] = substr($date, 17, 2);
    return $result;
}
// ------------------------------------------------------------------------------- //
// ------------------- this function return  date as UNIX timestamp -------------- //
// ------------------------------------------------------------------------------- //
function dateInt($date)
{
    $date = dateArray($date);
    return mktime($date['hour'], $date['minutes'],  $date['seconds'], $date['month'], $date['day'], $date['year']);
}

// ------------------------------------------------------------------------------- //
// --this function return the difference between tow  date in milliseconds  ------ //
// ------------------------------------------------------------------------------- //
function difference($dateStart, $dateEnd)
{
    $start =  dateInt($dateStart);
    $end =  dateInt($dateEnd);
    $difference = $end - $start;
    return   number_format($difference * 1000, 0, '.', '');
}

// ------------------------------------------------------------------------------- //
// ------------------- convert any given string to hex --------------------------- //
// ------------------------------------------------------------------------------- //
function strToHex($string)
{
    $hex = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $ord = ord($string[$i]);
        $hexCode = dechex($ord);
        $hex .= substr('0' . $hexCode, -2);
    }
    return strToUpper($hex);
}

// ------------------------------------------------------------------------------- //
// ------------------- get the client IP address --------------------------------- //
// ------------------------------------------------------------------------------- //
function get_client_ip()
{
    $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if (getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if (getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if (getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if (getenv('HTTP_FORWARDED'))
        $ipaddress = getenv('HTTP_FORWARDED');
    else if (getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}


function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) === $date;
}

function array_has_dupes($array)
{
    return count($array) !== count(array_unique($array));
}

function isArrayOfType($inputArray, $inputType)
{
    if (gettype($inputArray) != 'array') return false;
    foreach ($inputArray as $i) {
        if (gettype($i) != $inputType) return false;
    }
    return true;
}


// ------------------------------------------------------------------------------------------ //
// ------------------- Call External API using cURL ----------------------------------------- //
// ------------------------------------------------------------------------------------------ //
function callCurl($url, $fields, $headers = false)
{

    //url-ify the data for the POST
    $fields_string = "";
    foreach ($fields as $key => $value) {
        $fields_string .= $key . '=' . $value . '&';
    }
    rtrim($fields_string, '&');

    $url = str_replace(' ', '', $url);
    $ch = curl_init();

    $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, $headers);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POST, count($fields));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);

    $json = curl_exec($ch);
    curl_close($ch);

    return $json;
}


// ------------------------------------------------------------------------------------------ //
// ------------------- Call External API using cURL ----------------------------------------- //
// ------------------------------------------------------------------------------------------ //
function callAPI($method, $url, $data)
{
    $curl = curl_init();

    switch ($method) {
        case "POST":
            curl_setopt($curl, CURLOPT_POST, 1);
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        default:
            if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
    }


    // OPTIONS:
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);


    // EXECUTE:
    $result = curl_exec($curl);
    if (!$result) {
        die("Connection Failure");
    }
    curl_close($curl);

    return $result;
}


function sendEmail($emailTitle, $emailText, $email)
{

    $username = 'reports@minagate.com';
    $password = '?j@MBzLwp@7Q!bkW';

    $emailText = $emailText;
    $mail = new PHPMailer(true);
    $mail->isSMTP();                                            // Send using SMTP
    $mail->Host = "ssl://smtp.gmail.com";                       // Set the SMTP server to send through
    $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
    $mail->Username   = $username;                              // SMTP username
    $mail->Password   = $password;                              // SMTP password
    $mail->Port       = 465;                                    // TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above

    $mail->setFrom($username, 'Minagate');
    $mail->addAddress($email);     // Add a recipient
    $mail->addReplyTo($username, 'Minagate');

    // Content
    $mail->CharSet = 'UTF-8';
    $mail->isHTML(true);                                  // Set email format to HTML
    $mail->Subject = $emailTitle;
    $mail->Body = $emailText;
    $mail->send();
}

// ---------------------------------------------------------------------------------------- //
// -------------------------- Send SMS using SMS Gateway ---------------------------------- //
// ---------------------------------------------------------------------------------------- //
function sendSMS($MessageRecipients, $MessageBody)
{

    $jormall_SMS_Gateway = new Jormall_SMS_Gateway();
    $result = $jormall_SMS_Gateway->sendMessage($MessageRecipients, $MessageBody);
    return $result;

    // // $javna_sms_gateway = new Javna_sms_gateway();
    // // $result = $javna_sms_gateway->sendMessage($MessageRecipients,$MessageBody);

    // if (strpos($result, 'Error=0') !== false) {
    //     return $result;
    // }
    // else if (strpos($result, 'MsgID') !== false) {
    //     return $result;
    // }
    // else{
    //     // send notification to Hamzeh
    //     $socialCore = new SocialCore();
    //     $socialCore->informSupervisor('خطأ في ارسال SMS','خطأ في ارسال SMS', "خطأ في ارسال SMS", 2);
    // }
}


// ----------------------------------------------------------------------------------------- //
// ---------------- Retrun the caption value of a certain minot tt ------------------------- //
// ----------------------------------------------------------------------------------------- //
function get_tt_caption($tt)
{

    $label = $tt;
    switch ($tt) {
        case '201':
            $label = "قلاب";
            break;
        case '203':
            $label = "تريلا";
            break;
        case '204':
            $label = "سطحة مع رافعة";
            break;
        case '205':
            $label = "نقل بضائع مزودة بونش";
            break;
        case '206':
            $label = "صهريج أعلاف";
            break;
        case '207':
            $label = "صهريج مواد أولية";
            break;
        case '208':
            $label = "سايلو اسمنت";
            break;
        case '209':
            $label = "اسمنت";
            break;
        case '210':
            $label = "مذوبات سائبة";
            break;
        case '211':
            $label = "مواد كيميائية";
            break;
        case '212':
            $label = "اسفلت";
            break;

        case '9':
            $label = "رأس قاطر";
            break;

        case '101':
            $label = "سطحة حاويات";
            break;
        case '102':
            $label = "نقل حاويات";
            break;
        case '103':
            $label = "مجهز لنقل الحاويات";
            break;

        case '301':
            $label = "صهريج";
            break;
        case '302':
            $label = "صهريج غاز مسال";
            break;
        case '303':
            $label = "صهريج مواد نفطية";
            break;

        default:
            break;
    }

    return $label;
}


// -------------------------------------------------------------------------------------- //
// ------------- return true if the user_id has the role "Operation_Manager" ------------ //
// -------------------------------------------------------------------------------------- //
function isMinagateOperation($user_id)
{

    $userCore = new UserCore();
    $u_id = DBConnection::getUserIdFromSession($user_id);

    $isMinagateOperation = false;
    $userBean = $userCore->getUserBasic($u_id, $user_id);
    $userRolesArray = explode(",", $userBean->role_code);
    foreach ($userRolesArray as $role) {
        if ($role == 'OPERATION_MANAGER') {
            $isMinagateOperation = true;
        }
    }
    return $isMinagateOperation;
}

// ---------------------------------------------------------------------------------------- //
// ------------------------- get a list of Jordan cities ---------------------------------- //
// ---------------------------------------------------------------------------------------- //
function getJordanCities()
{
    return "91010000,91020000,91030000,91040000,91050000,91060000,91070000,91080000,91090000,91100000,91110000,91120000";
}


// -------------------------------------------------------- //
// ----------- search for a certain value in array -------- //
// -------------------------------------------------------- //
function findInArray($value, $arr, $key = 'name')
{
    foreach ($arr as $temp) {
        if ($temp->$key == $value) {
            return 1;
        }
    }
    return 0;
}

// -------------------------------------------------------------------------------------------- //
// --------------------- convert location id to name ------------------------------------------ //
// -------------------------------------------------------------------------------------------- //
function getLocationName($location_id)
{
    $locationCore = new LocationCore();
    return $locationCore->getLocationBasic($location_id, 0)->name;
}


// convert arabic numbers to englis
function convertArabicNumbers($string)
{
    return strtr($string, array("٠" => 0, "١" => 1, "٢" => 2, "٣" => 3, "٤" => 4, "٥" => 5, "٦" => 6, "٧" => 7, "٨" => 8, "٩" => 9));
}


function escapeJsonString($value)
{ # list from www.json.org: (\b backspace, \f formfeed)
    $escapers = array("\\", "/", "\"", "\n", "\r", "\t", "\x08", "\x0c");
    $replacements = array("\\\\", "\\/", "\\\"", "\\n", "\\r", "\\t", "\\f", "\\b");
    $result = str_replace($escapers, $replacements, $value);
    return $result;
}

function logHamzeh($message1, $message2)
{
}
