<?php

class Con_DBConnection
{

    protected static $db;
    private function __construct()
    {
        try {

            /*LIVE*/
            // live = 34.134.70.8
            $host = '34.134.70.8';
            $db   = 'container';
            $user = 'container';
            $pass = 'Unt9jEqLjwSDhRS8';
            $charset = 'utf8mb4';
            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => true
            ];
            $dsn = "mysql:host=$host;port=3306;dbname=$db;charset=$charset";
            self::$db = new PDO($dsn, $user, $pass, $options);
        } catch (PDOException $e) {
            echo "Connection Error: " . $e->getMessage();
        }
    }

    // -------------------------------------------------------------------------------------------------------- //
    // ---------------------- Singelton method to make 1 DB instance for the whole application ---------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public static function getInstance()
    {
        if (!self::$db) {
            new Con_DBConnection();
        }

        return self::$db;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------------- Destruct the DB instance ------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function __destruct()
    {
        $db = NULL;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------------- Start DB Transaction   --------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public static function startTransaction()
    {
        self::$db->beginTransaction();
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------------- Roll back DB Transaction  ---------------------------- //
    // -------------------------------------------------------------------------------- //
    public static function rollBackTransaction()
    {
        try {
            self::$db->rollBack();
        } catch (Exception $e) {
        }
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------------- Commit DB Transaction   --------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public static function commitTransaction()
    {
        self::$db->commit();
    }
 
    // ------------------------------------------------------------------------------------- //
    // -------------------- Generate a random number from 19 digits ------------------------ //
    // ------------------------------------------------------------------------------------- //
    private static function random19()
    {
        $number = "";
        for ($i = 0; $i < 19; $i++) {
            $min = ($i == 0) ? 1 : 0;
            $number .= mt_rand($min, 9);
        }
        return $number;
    }
 

    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runDatabaseQuery($query)
    {
        $db_query = $query;

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
        $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $tempResult;
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runBindDatabaseQuery($query, $param)
    {

        $stmt = self::$db->prepare($query);
        $stmt->execute($param);
        try {
            $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
            return $tempResult;
        } catch (Exception $e) {
        }
    }
 
}
