<?php

class Reg_DBConnection{

  protected static $db;
  private function __construct() {
    try {

        /*LIVE*/
        $host = '34.134.70.8'; 
        $db   = 'reg';
        $user = 'system';
        $pass = '35DcDw9M7B2nD3f';
        $charset = 'utf8mb4';
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => true
        ];
        $dsn = "mysql:host=$host;port=3306;dbname=$db;charset=$charset";
        self::$db = new PDO($dsn, $user, $pass, $options);

    }
    catch (PDOException $e) {
        echo "Connection Error: " . $e->getMessage() ;
    }
  }

  // -------------------------------------------------------------------------------------------------------- //
  // ---------------------- Singelton method to make 1 DB instance for the whole application ---------------- //
  // -------------------------------------------------------------------------------------------------------- //
  public static function getInstance() {
    if (!self::$db) {
        new Reg_DBConnection();
    }

    return self::$db;
  }

  // ---------------------------------------------------------------------------------- //
  // ------------------------- Destruct the DB instance ------------------------------- //
  // ---------------------------------------------------------------------------------- //
  public function __destruct() {
      $db=NULL;
  }

  // ---------------------------------------------------------------------------------- //
  // ------------------------- Start DB Transaction   --------------------------------- //
  // ---------------------------------------------------------------------------------- //
  public static function startTransaction(){
      self::$db->beginTransaction();
  }

// ---------------------------------------------------------------------------------- //
  // ------------------------- Roll back DB Transaction  ---------------------------- //
  // -------------------------------------------------------------------------------- //
  public static function rollBackTransaction(){
    try{
    self::$db->rollBack();
    }
    catch(Exception $e){}
 }

  // ---------------------------------------------------------------------------------- //
  // ------------------------- Commit DB Transaction   --------------------------------- //
  // ---------------------------------------------------------------------------------- //
  public static function commitTransaction(){
    self::$db->commit();
 }


  // ------------------------------------------------------------------------------------ //
  // ------------------------- General Method to select data from DB Table -------------- //
  // ------------------------------------------------------------------------------------ //
  public static function searchDB($tableName, $searchFilter, $limit , $offset , $userID, $ordeBy=null){

    $limit = (is_null($limit)?15:$limit);
    $offset = (is_null($offset)?0:$offset);
    $search_query = "call get_object_qry(:tableName , :searchQuery , :limit , :offset , :ordeBy, :userID)";
    $searchQuery = self::prepareSqlWhere($searchFilter,$tableName);     
    
    // echo("call get_object_qry( '" .addslashes($tableName) . "','" . addslashes($searchQuery) ."' , $limit , $offset , $ordeBy,  $userID)");
    // die;

    $stmt = self::$db->prepare($search_query);
    $stmt->bindParam(':tableName', $tableName , PDO::PARAM_STR);
    $stmt->bindParam(':searchQuery', $searchQuery , PDO::PARAM_STR);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindParam(':ordeBy', $ordeBy, PDO::PARAM_STR);
    $stmt->bindParam(':userID', $userID, PDO::PARAM_INT);
    

    //echo sprintf("call get_object_qry('%s','%s',%s,%s,%s);", $tableName, $searchQuery , $limit , $offset ,$ordeBy ,  $userID);die;

    /* Now we're ready to execute */
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_OBJ);

    $resultset['data'] = $result;
    $stmt->nextRowset();
    $result = $stmt->fetchAll();
    $resultset['found_rows'] = $result[0]['found_rows'];

    $decodeJson = json_decode(json_encode($resultset));

    return $decodeJson;

  }

  // ------------------------------------------------------------------------------------ //
  // ------------------------- General Method to search reporting views DB -------------- //
  // ------------------------------------------------------------------------------------ //
  public static function searchReport($tableName, $reportNumber , $searchFilter, $limit , $offset , $userID, $ordeBy=null){

    $limit = (is_null($limit)?15:$limit);
    $offset = (is_null($offset)?0:$offset);
    $search_query = "call get_object_rpt(:tableName ,:reportNumber ,:searchQuery , :limit , :offset , :ordeBy, :userID)";

    $searchQuery = self::prepareSqlWhere($searchFilter,$tableName);

    //$search_query = "call get_object_rpt('$tableName' ,'$reportNumber' , '" . addslashes($searchQuery) . "' , $limit , $offset , '$ordeBy' , $userID)";
    //echo $search_query;die;

    $stmt = self::$db->prepare($search_query);
    $stmt->bindParam(':tableName', $tableName , PDO::PARAM_STR);
    $stmt->bindParam(':reportNumber', $reportNumber , PDO::PARAM_STR);
    $stmt->bindParam(':searchQuery', $searchQuery , PDO::PARAM_STR);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindParam(':ordeBy', $ordeBy, PDO::PARAM_STR);
    $stmt->bindParam(':userID', $userID, PDO::PARAM_INT);
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_OBJ);
    $resultset['data'] = $result;
    $stmt->nextRowset();
    $result = $stmt->fetchAll();
    $resultset['found_rows'] = $result[0]['found_rows'];

    $decodeJson = json_decode(json_encode($resultset));

    return $decodeJson;

  }

  private static function prepareSqlWhere ($searchFilter,$tableName){
     // prepare the searchFilter as convert it to string
     $searchFilter = (is_null($searchFilter)?[]:$searchFilter);
     $searchFilter = (gettype($searchFilter)==='array'?json_decode(json_encode($searchFilter)):json_decode($searchFilter));
      $searchQuery = '';
 
      foreach ($searchFilter as $i) {
          $op=(array_key_exists('op',$i)?$i->op:'=');

          switch(strtolower($op)){
              case "=":
                  $searchQuery .= " AND " .$i->key ." = '" .$i->val ."' ";
                  break;
              case "like":
                  if($tableName == 'waybill' || $tableName == 'waybill_order') {
                    $searchQuery .= " AND MATCH (search_index) AGAINST ( '$i->val' IN BOOLEAN MODE)";
                  }
                  else{
                    $searchQuery .= " AND " .$i->key ." like '%" .$i->val ."%' ";
                  }
                  break;
              case "in":
                  $searchQuery .= " AND " .$i->key ." in('" .implode("','",$i->val)."') ";
                  break;
              case "not in":              
                  $searchQuery .= " AND " .$i->key ." not in('" .implode("','",$i->val)."') ";                 
                  break;
              case "json":
                  $searchQuery .= " AND JSON_CONTAINS(" .$i->key .",'" .$i->val ."','" .$i->node ."')" ;
                  break;
              case "json unquote":
                  $searchQuery .= " AND JSON_UNQUOTE(JSON_EXTRACT(" .$i->key . ", '$i->node')) = " . $i->val;
                  break;
              case "json in":
                  $searchQuery .= " AND JSON_UNQUOTE(JSON_EXTRACT(" .$i->key. ",'" .$i->node . "')) in('".implode("','",$i->val)."') ";
                  break;
              case "is null":
                  $searchQuery .= " AND " .$i->key ." is null ";
                  break;
              case "is not null":
                  $searchQuery .= " AND " .$i->key ." is not null ";
                  break;
              case "greater than":
                  $searchQuery .= " AND " .$i->key ." >= " . "'" .$i->val ."'";
                  break;
              case "less than":
                  $searchQuery .= " AND " .$i->key ." <= " . "'" .$i->val ."'";
                  break;
              case "date greater than":
                  $searchQuery .= " AND " .$i->key ." >= " . "'" .$i->val ."'";
                  break;
              case "date less than":
              {
                  $parsed_date_arr = date_parse($i->val);
                  $filtered_date_arr = array_filter($parsed_date_arr);

                  if (!array_key_exists('hour', $filtered_date_arr))
                      $date_str = $i->val . ' 23:59:59';
                  else
                    $date_str = $i->val;

                  $searchQuery .= " AND " . $i->key . " < " . "'" . $date_str . "'";
                  break;
              }
              case "startswith":
                  $searchQuery .= " AND " .$i->key ." like '" .$i->val ."%' ";
                  break;
          }
      }
      
      return $searchQuery;
  }

  // ------------------------------------------------------------------------------------------------------ //
  // ------------------------- get JSON bean from Database for certain id without activities--------------- //
  // ------------------------------------------------------------------------------------------------------ //
  public static function getBasicObjectBean($tableName, $id, $userID){

        $search_query = "call get_object_bean_basic('".$tableName."',".$id.",".$userID.", @bean)";

        $stmt = self::$db->prepare($search_query);

        /* Now we're ready to execute */
        $stmt->execute();

        // get the bean
        $search_query = "select @bean";
        $stmt = self::$db->prepare($search_query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        return json_decode($result[0]['@bean']);
    }


    // ------------------------------------------------------------------------------------------------------ //
    // ------------------------- get JSON bean from Database for certain id without activities--------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public static function call_add_jv($account_id, $jv_date, $trx_json,$notes, $user_id){

        $db_query = "call add_jv( $account_id , '$jv_date' , '$trx_json' , '$notes' , $user_id , @result)";

        $stmt = self::$db->prepare($db_query);
 

        /* Now we're ready to execute */
        $stmt->execute();
 
        // get the bean
        $search_query = "select @result";
        $stmt = self::$db->prepare($search_query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        $r = json_decode($result[0]['@result']);
        if(!$r || $r == null){
            throw new Exception("Error Processing Request, Cant complete add JV");            
        }
        return json_decode($result[0]['@result']);
    }


  // ------------------------------------------------------------------------------------ //
  // ------------------------- get JSON bean from Database for certain id --------------- //
  // ------------------------------------------------------------------------------------ //
  public static function getObjectBean($tableName, $id, $userID){

        $search_query = "call get_object_bean('".$tableName."',".$id.",".$userID.", @bean)";
        $stmt = self::$db->prepare($search_query);

        /* Now we're ready to execute */
        $stmt->execute();

        // get the bean
        $search_query = "select @bean";
        $stmt = self::$db->prepare($search_query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        return $result[0]['@bean'];
  }


  // ------------------------------------------------------------------------------------ //
  // ------------------------- General Method to insert data into DB Table -------------- //
  // ------------------------------------------------------------------------------------ //
  public static function insertDB($tableName, $insertStruct, $userID){

    foreach ($insertStruct as $key => &$value) {
        try{
            if($value && gettype($value)==='string'){
                $value = trim($value);
            }
        }catch(Exception $e){}
    }

    $insertStruct = json_decode(json_encode($insertStruct));


    // get the initial status for this record
    $insertStruct->status = self::get_init_Status($tableName,$userID);

    // fill the userid which creates the record
    $insertStruct->update_by = $userID;

    // remove the id column, because it is generated in the DB
    //unset($insertStruct->id);

    // convert the insert params to JSON and convert unicode to arabic
    $insertQuery = json_encode($insertStruct,JSON_UNESCAPED_UNICODE);
    // prepare the SQL statment

    $rand = "@id_" . self::random19();
    $insert_query = "call insert_record(:tableName , :insertQuery , $rand )";
    
    //echo "call insert_record('" . addslashes($tableName) . "' , '" . $insertQuery . "' , $rand )";die;

    $stmt = self::$db->prepare($insert_query);
    $stmt->bindParam(':tableName', $tableName , PDO::PARAM_STR);
    $stmt->bindParam(':insertQuery', $insertQuery , PDO::PARAM_STR);
    /* Now we're ready to execute */
    $stmt->execute();

    // get the newly created resultd
    $search_query = "select $rand";
    $stmt = self::$db->prepare($search_query);
    $result = $stmt->execute();
    $result = $stmt->fetchAll();
    $result[0]['@id'] = $result[0][$rand];

    return $result;
  }



  // ----------------------------------------------------------------------------- //
  // -----------------------Add note to a certain object in database-------------- //
  // ----------------------------------------------------------------------------- //
  public static function addNotes($tableName, $objectID, $notes, $userID){

    $insert_query = "call add_notes(:tableName , :objectID , :notes , :userID )";

    $stmt = self::$db->prepare($insert_query);
    $stmt->bindParam(':tableName', $tableName , PDO::PARAM_STR);
    $stmt->bindParam(':objectID', $objectID , PDO::PARAM_STR);
    $stmt->bindParam(':notes', $notes , PDO::PARAM_STR);
    $stmt->bindParam(':userID', $userID , PDO::PARAM_STR);
    /* Now we're ready to execute */
    $stmt->execute();

  }


  // ------------------------------------------------------------------------------------- //
  // -------------------- Generate a random number from 19 digits ------------------------ //
  // ------------------------------------------------------------------------------------- //
  private static function random19() {
    $number = "";
    for($i=0; $i<19; $i++) {
      $min = ($i == 0) ? 1:0;
      $number .= mt_rand($min,9);
    }
    return $number;
  }

  // ------------------------------------------------------------------------------------ //
  // ------------------------- General Method to update data from DB Table -------------- //
  // ------------------------------------------------------------------------------------ //
  public static function updateDB($tableName, $updateStruct, $userID){

    // add the user_id to the statment
    $updateStruct->update_by = $userID;

    //convert the object to JSON and convert unicode to arabic
    $updateQuery = json_encode($updateStruct,JSON_UNESCAPED_UNICODE);

    // prepare the statment
    $rand = "@id_" . self::random19();
    $update_query = "call update_record(:tableName , :updateQuery , $rand )";

 
    $stmt = self::$db->prepare($update_query);
    $stmt->bindParam(':tableName', $tableName , PDO::PARAM_STR);
    $stmt->bindParam(':updateQuery', $updateQuery , PDO::PARAM_STR);
    /* Now we're ready to execute */
    $stmt->execute();



  }

   // ------------------------------------------------------------------------------------ //
   // ------------------------- General Method to update data from DB Table -------------- //
   // ------------------------------------------------------------------------------------ //
   public static function updateQueueRank($queueId, $new_status){

        // prepare the statment
        $db_query = "call waybill.set_queue_rank(".$queueId.",'$new_status')";

        $stmt = self::$db->prepare($db_query);

        /* Now we're ready to execute */
        $stmt->execute();
   }


    // ------------------------------------------------------------------------------------ //
    // ------------------------- get the initial status for any object -------------------- //
    // ------------------------------------------------------------------------------------ //
    public static function get_init_Status($objectName){

        $search_query = "call get_lookup('object','')";
        $stmt = self::$db->prepare($search_query);

        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        foreach($result as $row) {
            if ($row['code'] == strtoupper($objectName)){
                return $row['default_status'];
            }
        }
    }

    // ------------------------------------------------------------- //
    // --------------------- get the user work flow  --------------- //
    // ------------------------------------------------------------- //
    public static function getUserWF($user_id){

        $search_query = "call waybill.get_lookup('user_wf', 'where user_id = ".$user_id."');";
        $stmt = self::$db->prepare($search_query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result;
    }

     // -------------------------------------------------------------------- //
    // --------------------- get company employee work flow  --------------- //
    // --------------------------------------------------------------------- //
    public static function getCompanyEmployeeWF($company_employee_id){

        $search_query = "call waybill.get_lookup('company_employee_wf', 'where company_employee_id = ".$company_employee_id."');";
        $stmt = self::$db->prepare($search_query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result;
    }


    // ------------------------------------------------------------- //
    // --------------------- get the look up for view--------------- //
    // ------------------------------------------------------------- //
    public static function getLookup($viewName, $searchQuery){

        $query = "call waybill.get_lookup('$viewName' , '$searchQuery');";

        $stmt = self::$db->prepare($query);

        $result = $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result;
    }


    // ------------------------------------------------------------- //
    // -------------- get system current date and time ------------- //
    // ------------------------------------------------------------- //
    public static function getSystemDate(){

        $query = "call waybill.get_system_date();";

        $stmt = self::$db->prepare($query);
        $result = $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result[0]->sysdate;
    }



    // ------------------------------------------------------------------------------------- //
    // ------------------------  Check if user has action ---------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public static function has_authority($userid, $object , $action, $currentStatus, $newStatus){

        $search_query = "select has_authority('".$userid."','".$object."','".$action."','".$currentStatus."','".$newStatus."' ) as auth";
        $stmt = self::$db->prepare($search_query);

        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        if (count($result) == 0){
            throw new Exception("NO_AUTHORITY",0);throw new Exception("NO_AUTHORITY",0);
        }

        if ($result[0]['auth'] == 0){
            throw new Exception("NO_AUTHORITY",0);throw new Exception("NO_AUTHORITY",0);
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------------  generate new waybill number ------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public static function generateWaybillNumber(){

        $db_query =  'SELECT ifnull(max(wn)+1,(YEAR(CURDATE())-2000)*100000000+20000001) as wn  '.
                        'from waybill '.
                    'where wn like concat((YEAR(CURDATE())-2000),\'%\') ';

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
        $waybillResult = $stmt->fetchAll();

        return $waybillResult[0]['wn'];
    }


    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runDatabaseQuery($query){
        $db_query = $query;

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
        $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $tempResult;
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runBindDatabaseQuery($query, $param){

        $stmt = self::$db->prepare($query);
        $stmt->execute($param);
        try{
            $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
            return $tempResult;
        }catch(Exception $e){           
        }
        

    }

    // ----------------------------------------------------------------------------- //
    // -----------------------Add note to a certain object in database-------------- //
    // ----------------------------------------------------------------------------- //
    public static function search_woq($tableNames, $search_query, $search_filter,
                                      $tender_id, $q_id,
                                      $from_date, $to_date, $object_status,
                                      $limit, $offset,  $userID,$tender_ids){

        $limit = (is_null($limit)?15:$limit);
        $offset = (is_null($offset)?0:$offset);
        $search_query = trim((is_null($search_query)?"":$search_query));
        $from_date = trim((is_null($from_date)?"":$from_date));
        $to_date = trim((is_null($to_date)?"":$to_date));

        $start = microtime(false);

        $search_term = "";
        if($search_query != "") {
            $search_term .= $search_query;
        }

        $search_sql = "select ";
        if(sizeof(explode(",",$tableNames))==1) $search_sql .= "SQL_CALC_FOUND_ROWS ";

        $search_sql .= "
            id,
            object_code,
            object_id,
            CAST(object_record AS CHAR CHARSET UTF8) AS object_record,
            object_status,
            object_keys,
            create_date,
            search_text

            FROM
            search_waybill_order_queue woq
            WHERE EXISTS( SELECT
            id
            FROM
            wf
            WHERE
            object_code = woq.object_code
            AND IFNULL(wf.object_status_code, woq.object_status) = woq.object_status
            AND action_code = 'VIEW'
            AND status = 'ACTIVE'
            AND role_code IN (SELECT
            role_code
            FROM
            user_role
            WHERE
            user_id = :userID
            AND status = wf.role_status_code)) ";

            if($object_status != "") $search_sql .= " AND object_status in ('" . implode ( "', '", explode(",",$object_status) ) . "') ";
            if($tableNames != "") $search_sql .= " AND object_code in ('" . implode ( "', '", explode(",",$tableNames) ) . "') ";

            if($from_date != "") $search_sql .= " and create_date >= :from_date ";
            if($to_date != "") $search_sql .= " and create_date <= :to_date ";
            if($search_term != "") $search_sql .= " and MATCH (search_text) AGAINST (:search_term IN BOOLEAN MODE) ";
            if($tender_id != "") $search_sql .= " and tender_id = :tender_id ";
            if($q_id != "") $search_sql .= " and q_id = :q_id ";
            if($tender_ids) $search_sql .= " and tender_id in ($tender_ids) ";
            $search_sql .= "ORDER BY create_date ";

            if($tableNames != "QUEUE") $search_sql .= " DESC ";
            $search_sql .= "limit $limit  offset $offset";
 

        $stmt = self::$db->prepare($search_sql);

        if($search_term != "") $stmt->bindParam(':search_term', $search_term , PDO::PARAM_STR);
        if($from_date != "") $stmt->bindParam(':from_date', $from_date , PDO::PARAM_STR);
        if($to_date != "") $stmt->bindParam(':to_date', $to_date , PDO::PARAM_STR);
        if($tender_id != "") $stmt->bindParam(':tender_id', $tender_id , PDO::PARAM_STR);
        if($q_id != "") $stmt->bindParam(':q_id', $q_id , PDO::PARAM_STR);

        $stmt->bindParam(':userID', $userID, PDO::PARAM_INT);

        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        $resultset['data'] = $result;

        if($tableNames != "" && sizeof(explode(",",$tableNames))==1){
            $stmt = self::$db->prepare("SELECT FOUND_ROWS() as `found_rows`;");
            $stmt->execute();
            $found_rows = $stmt->fetchAll(PDO::FETCH_OBJ);
            $resultset['found_rows'] =$found_rows[0]->found_rows;
        }else{
            $resultset['found_rows'] = null;
        }

        $time_elapsed = microtime(false) - $start;
        $time_elapsed = intval($time_elapsed*1000);
        $time_elapsed = abs($time_elapsed);

        $json_filter = json_encode($search_filter);
        $insert_log_sql = "insert into searchLog (`sql`,user_id, execution_time ,v_name,fltr,lmt,ofst) values('',$userID , $time_elapsed ,'woq' ,'$json_filter',$limit,$offset)";
        $stmt = self::$db->prepare($insert_log_sql);
        $stmt->execute();

        $decodeJson = json_decode(json_encode($resultset));

        return $decodeJson;
    }

    // -------------------------------------------------------------------------------- //
    // ------------------ get user id for certain session ----------------------------- //
    // -------------------------------------------------------------------------------- //
    public static function getUserIdFromSession($session_id){

        $sqlQuery = " SELECT
                        JSON_UNQUOTE(JSON_EXTRACT(details,'$.id')) user_id
                      FROM
                        session
                      WHERE 
                        id = ?";

        $param = [$session_id];
        $result = Reg_DBConnection::runBindDatabaseQuery($sqlQuery,$param);

        return $result[0]->user_id;

    }

    public static function getTenderTrucksDestination($tender_id , $tn , $questionnaire, $q_id){

        $param = [];
        $sqlQuery = " 
            SELECT 
                q.rank , q.queue_name , q.tn , q.trn ,
                    q.trail_minor_tt,
                    q.contact_name , q.contact_phone , q.status , t.questionnaire,  t.status as tt_status
            FROM
                queue_view q
                    JOIN
                tender_truck_view t ON t.truck_id = q.truck_id and t.status != 'INACTIVE'
            WHERE
                q.tender_id = ?
                    AND t.tender_id = q.tender_id
                    AND q.rank IS NOT NULL
                    and q.status = 'ACTIVE'
                    ";
                    $param[] = $tender_id;
                    if($tn){
                        $sqlQuery .= " and q.tn = ? ";
                        $param[] = $tn;
                    }
                    if($q_id){
                        $sqlQuery .= " and q.q_id = ? ";
                        $param[] = $q_id;
                    }

            $sqlQuery .= "and 1=1 ";
                    if($questionnaire){          
                    foreach ($questionnaire as $q) {
                        $sqlQuery .= " AND questionnaire LIKE '%$q%' ";
                    }}
            $sqlQuery .= " ORDER BY q.rank";

            $result = Reg_DBConnection::runBindDatabaseQuery($sqlQuery,$param);
        return $result;
    }


    //----------------get the destinations of trucks--------------------///
     public static function getTodayTenderOrderDetails($tender_id , $q_id , $order_date){

        $param = [];

        $queue_query = "1=1";
        $tender_queue_query = "1=1";

        if($q_id){
            $queue_query = "q_id=$q_id";
            $tender_queue_query = "o.q_id=$q_id";
        }

        $order_date_tommorow =  date('Y-m-d',strtotime($order_date. "+1 days"));

        $sql_query = "SELECT t.id as tender_order_id,
                            t.order_date,
                            CAST(t.questionnaire AS CHAR CHARSET UTF8) AS questionnaire,
                            ifnull(queue_name,'شركات') queue_name,
                            t.trucks as total_trucks,
                            json_unquote(json_extract(t.order_notes,'$.extra_note')) extra_note, 
                            w.id,
                            (select name from cargo where id = w.cargo_id) cargo_name,
                            w.queue_id,
                            t.tender_id,
                            q.q_id,
                            q.serial ,
                            q.create_date,
                            q.id latest_queue_id

                            from (SELECT MAX(wo.id) id, wo.tender_order_id order_id FROM waybill_order wo
                            WHERE wo.tender_order_id IN (SELECT id
                                    FROM tender_order o
                                  WHERE o.status in ('PENDING','CLOSED')
                                        AND o.q_id != 48
                                            AND o.tender_id = $tender_id
                                            AND $tender_queue_query
                                        And queue_id is not null
                                        and o.id != 5242)
                            GROUP BY wo.tender_order_id) o
                            join tender_order t on t.id=o.order_id
                            left join waybill_order w on w.id=o.id
                            left join queue_view q on q.id=w.queue_id

                            union all
                            select t.id , t.order_date, t.questionnaire  , 'دور المحفوظ' , t.trucks ,'', '','قمح سائب','',t.tender_id , 'other' , '' , '' , ''
                            from tender_order t 
                            where t.tender_id = $tender_id and q_id = 3
                            and t.status in ('ACTIVE','PENDING','CLOSED')
                            and order_date in ('$order_date')";

        $result = Reg_DBConnection::runBindDatabaseQuery($sql_query,$param);
        return $result;
    }


    //----------------get the Jo petrol policy_num--------------------///
    public static function searchJoPetrolPolicy($date_from,$date_to,$tender_id){

        $param = [];
        $sql_query = "SELECT
        v.id,
        v.status,
        w.wn,
        w.tn,
        w.loading_date,
        JSON_UNQUOTE(JSON_EXTRACT(v.trx_template, '$.amount')) amount,
        ifnull(document->>'$.integeration_details.jo_petrol.jo_petrol_policy_num',
			   document->>'$.integeration_details.jo_petrol.nfldnm')  jo_petrol_policy_num
    FROM
        voucher v
            RIGHT JOIN
        waybill_view w ON JSON_UNQUOTE(JSON_EXTRACT(trx_template, '$.ref_id')) = w.id
    WHERE
        w.tender_id = $tender_id
            AND w.status IN ('ONROAD' , 'ARRIVED', 'CLOSED', 'COMPLETE')
            AND w.loading_date > '$date_from'
            AND w.loading_date < '$date_to'
            AND v.create_date > '2020-01-01';";
        $result = Reg_DBConnection::runBindDatabaseQuery($sql_query,$param);
        return $result;
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------ get grains comopany share ------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function getGrainsCompanyShare($tenderId , $queueId){

        $param = [];

        $tenderCompanyQuotaSql = "
                SELECT id,
                    name,
                    company_id,
                    trucking_company_id,
                    tender_name,
                    share AS fleet,
                    wbl ,
                    wbl * share / cnt quota,
                    IFNULL(a.wbls, 0) used_quota,
                    (wbl * share / cnt) - IFNULL(a.wbls, 0) residual,
                    share / cnt perc
                FROM tender_company_view t
                        JOIN
                    (SELECT SUM(share) cnt
                    FROM tender_company c
                    WHERE c.tender_id = $tenderId) tot
                    JOIN
                    (SELECT COUNT(*) ";

                    if($tenderId == 13 && $queueId == 1){
            $tenderCompanyQuotaSql .= "+(SELECT count(*) FROM waybill wo join tender_order o on o.id=wo.order_id WHERE o.tender_id = 13 AND q_id=3 and wo.status != 'REVOKED' and wo.create_date > '2020-12-15' ";
                    }else{
                        $tenderCompanyQuotaSql .= "+(0";
                    }

                    $tenderCompanyQuotaSql .= ") wbl
                    FROM waybill_order wo join tender_order o on o.id=wo.tender_order_id
                            WHERE tender_id = $tenderId AND q_id=$queueId and wo.status != 'revoked' ";

        if ($tenderId == 13) {
            $tenderCompanyQuotaSql .= "and wo.create_date > '2020-12-15' ";
                }
 
                $tenderCompanyQuotaSql .= "
                        ) w
                        LEFT JOIN
                        (SELECT COUNT(*) wbls, tc
                    from( SELECT wo.id wbls, json_unquote(json_extract(tc_details,'$.trucking_company_id')) tc
                    FROM waybill_order wo join tender_order o on o.id=wo.tender_order_id
                        WHERE tender_id = $tenderId AND q_id=$queueId AND wo.status != 'revoked' ";

        if ($tenderId == 13 ) {
            $tenderCompanyQuotaSql .= "and wo.create_date > '2020-12-15' ";
                    }

                    if($tenderId == 13 && $queueId == 1){
                        $tenderCompanyQuotaSql .= " union
                        SELECT wo.id, trucking_company_id tc
                        FROM waybill wo
                                JOIN
                            tender_order o ON o.id = wo.order_id
                        WHERE o.tender_id = 13 AND q_id = 3
                                AND wo.status != 'REVOKED'
                                and wo.create_date > '2020-12-15'
                                ";
                    }
                    $tenderCompanyQuotaSql .= "
                         ) w
                        group by tc) a ON a.tc = t.trucking_company_id
                        WHERE  t.tender_id = $tenderId
                        and t.status != 'INACTIVE'
                order by residual desc";


        $result = Reg_DBConnection::runBindDatabaseQuery($tenderCompanyQuotaSql,$param);
     
        // for packed shares , add the old residual to company share
        if($tenderId == 13){
            $tender_company_ids = [];
            foreach ($result as $comp) {
                $tender_company_ids[] = $comp->id;
            }
   
            $historyCompanyQuotaSql = "select * from tender_company_history where tender_company_id in ("
                                     . implode(", ", $tender_company_ids) .") 
                                     and q_id = $queueId 
                                     and status = 'ACTIVE'";
            $param2 = [];
            $result2 =Reg_DBConnection::runBindDatabaseQuery($historyCompanyQuotaSql,$param2);

            foreach ($result as &$origianl) {
                foreach ($result2 as $history) {
                    if($origianl->id == $history->tender_company_id){
                        $origianl->residual+= $history->residual;
                    }
                }
            }
        }

        return $result;
    }
    


    //----------------get the loading and discharge report --------------------///
    public static function getLoadingAndDischargeReport($tender_id , $loading_date_from , $loading_date_to , $extra_filter=null){

        $sql_query = "SELECT 
        w.id,
        w.wn,
        w.create_date,
        CASE
			WHEN w.status = 'NEW' THEN 'جديد'
			WHEN w.status = 'APPROVED' THEN 'تمت الموافقة'
			WHEN w.status = 'ACTIVE' THEN 'فعال'
            WHEN w.status = 'PENDING' THEN 'قيد التحميل'
            WHEN w.status = 'ONROAD' THEN 'على الطريق'
            WHEN w.status = 'CLOSED' THEN 'تم التسليم'
            WHEN w.status = 'COMPLETE' THEN 'مكتمل'
		END as status,
                        w.loading_date ,
                        w.discharge_date,    
                        (select json_unquote(json_extract(claim_details,'$.ref')) from tender_claim where id = json_unquote(json_extract(v.trx_template,'$.tender_claim'))) claim_number,
        ifnull(document->>'$.integeration_details.jo_petrol.jo_petrol_policy_num',
			   document->>'$.integeration_details.jo_petrol.nfldnm')  loading_permit,
        ifnull(document->>'$.integeration_details.jo_petrol.discharge_permit_num',
			   document->>'$.integeration_details.jo_petrol.nfy55dispn')  discharge_permit,
                        json_unquote(json_extract(document,'$.carrier[0].truck.tn')) tn,
                        json_unquote(json_extract(document,'$.carrier[0].trailer.tn')) trn,
                        t.truck_owner_name,
                        json_unquote(json_extract(document,'$.carrier[0].tc.name')) tc,
                        json_unquote(json_extract(document,'$.carrier[0].driver.name')) driver_name,
                        json_unquote(json_extract(document,'$.carrier[0].driver.nn')) driver_nn,
                        json_unquote(json_extract(document,'$.cargo[0].weights.loading.net_weight')) loading_weight,
                        json_unquote(json_extract(document,'$.cargo[0].weights.discharge.net_weight')) discharge_weight,
                        json_unquote(json_extract(document,'$.freight.amount.loss_in_kg')) loss_in_kg,
                        json_unquote(json_extract(document,'$.freight.amount.base_amount')) base_amount,
                        json_unquote(json_extract(document,'$.freight.amount.total_advance_payment')) diesel,
                        json_unquote(json_extract(document,'$.freight.amount.total_deductions')) total_deductions,
                        json_unquote(json_extract(document,'$.freight.amount.tolerance_in_kg')) tolerance_in_kg,
                        json_unquote(json_extract(document,'$.freight.amount.total_fines')) total_fines,
                        json_unquote(json_extract(document,'$.freight.amount.net_amount')) net_amount,
                        json_unquote(json_extract(v.trx_template,'$.target_account_name')) consignee_name,
                        json_unquote(json_extract(document,'$.negotiable_instructios.route.destination.name')) destination_name,
                        json_unquote(json_extract(document,'$.freight.route_wage.wage_per_ton')) wage_per_ton,
                        v.payment_method,
                        json_unquote(json_extract(v.integration_details,'$.payment.ref_id')) ref_id
                    FROM
                        waybill_view w
                        left join truck t on w.truck_id = t.id
        left join voucher v on w.id = json_unquote(json_extract(trx_template,'$.ref_id'))
                            and v.status not IN ('REVOKED','INACTIVE')
                            and json_unquote(json_extract(trx_template,'$.ref_code')) in('WAYBILL','WAYBILL_COMPLETE')
    WHERE
        w.tender_id = ?";

        $param = [$tender_id];
        if($extra_filter){
            switch ($extra_filter) {
                case '*':
                    $sql_query .= " AND w.loading_date > ?
                                    AND w.loading_date < ?";
                    $param[] = $loading_date_from;
                    $param[] = $loading_date_to;
                    break;
                case 'no-discharge':
                    $sql_query .= " AND w.discharge_date is null
                                    AND w.loading_date > ?
                                    AND w.loading_date < ?";
                    $param[] = $loading_date_from;
                    $param[] = $loading_date_to;
                    break;
                case 'no-loading':
                    $sql_query .= " and w.loading_date is null
                                    AND w.create_date > ?
                                    AND w.create_date < ?";
                    $param[] = $loading_date_from;
                    $param[] = $loading_date_to;

                    break;
                case 'no-voucher':
                    $sql_query .= " AND v.id IS NULL
                                    AND w.loading_date > ?
                                    AND w.loading_date < ?
                                    ";
                    $param[] = $loading_date_from;
                    $param[] = $loading_date_to;
                    break;
                case 'no-claim':
                    $sql_query .= " AND w.loading_date > ?
                                    AND w.loading_date < ? ";
                    $param[] = $loading_date_from;
                    $param[] = $loading_date_to;

                    if($tender_id == 13){
                        $sql_query .= " AND not exists ( select id from tender_claim_item i where i.waybill_id = w.id and status = 'ACTIVE')";
                    }else{
                    $sql_query .= "  and (select json_unquote(json_extract(claim_details,'$.ref')) from tender_claim where id = json_unquote(json_extract(v.trx_template,'$.tender_claim'))) is null";
                    }
                    break;
                default:                   
                    break;
            }
        }

        // exclude 'REVOKED','INACTIVE'
        $sql_query .= " AND w.status NOT IN ('REVOKED','INACTIVE') ";

        // if($tender_id == 13){
        //     $sql_query .= " AND w.status NOT IN ('CLOSED','COMPLETE') ";
        // }       
        $sql_query .= ' ORDER BY loading_date ';
        $result = Reg_DBConnection::runBindDatabaseQuery($sql_query,$param);
        return $result;
    }



    // -------------------------------------------------------------------------------- //
    // ------------------ get a list of active status of each object  ----------------- //
    // -------------------------------------------------------------------------------- //
    public static function getActiveStatus($objectName){

        switch($objectName){
            case "waybill": {
                $db_query = "SELECT DISTINCT (object_status_code) FROM waybill.wf
                             WHERE object_code = 'waybill' AND action_code = 'CHANGE_STATUS' AND
                             object_status_code NOT IN ('INACTIVE','CLOSED','COMPLETE') and status = 'ACTIVE'";

                $stmt = self::$db->prepare($db_query);
                $stmt->execute();
                $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
                $status = [];
                foreach ($tempResult as $t ) {
                    array_push($status,$t->object_status_code);
                }
                return $status;
                break;
            }

            case "queue": {
                $db_query = "select distinct(object_status_code) from waybill.wf where object_code = 'QUEUE' and action_code = 'CHANGE_STATUS' and status='ACTIVE' AND role_code != 'SYSTEM'";
                $stmt = self::$db->prepare($db_query);
                $stmt->execute();
                $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
                $status = [];
                foreach ($tempResult as $t ) {
                    array_push($status,$t->object_status_code);
                }
                return $status;
                break;
            }

            case "tender_truck": {
                $db_query = "select distinct(object_status_code) from waybill.wf where object_code = 'tender_truck' and action_code = 'CHANGE_STATUS' AND role_code != 'SYSTEM'";

                $stmt = self::$db->prepare($db_query);
                $stmt->execute();
                $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
                $status = [];
                foreach ($tempResult as $t ) {
                    array_push($status,$t->object_status_code);
                }
                return $status;
                break;
            }

            case "tender_order": {
                $db_query = "select distinct(object_status_code) from waybill.wf where object_code = 'tender_order' and action_code = 'CHANGE_STATUS' AND role_code != 'SYSTEM'";

                $stmt = self::$db->prepare($db_query);
                $stmt->execute();
                $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
                $status = ['PENDING'];
                foreach ($tempResult as $t ) {
                    array_push($status,$t->object_status_code);
                }
                return $status;
                break;
            }

            case "truck_contract": {
                $status = ["NEW","ACTIVE"];
                return $status;
                break;
            }
            case "tender_company": {
                $status = ["NEW","ACTIVE"];
                return $status;
                break;
            }
            case "truck": {
                $status = ["NEW","ACTIVE"];
                return $status;
                break;
            }
            case "user": {
                $status = ["NEW","ACTIVE"];
                return $status;
                break;
            }
            case "driver": {
                $status = ["NEW","ACTIVE"];
                return $status;
                break;
            }
            case "cargo": {
                $status = ["ACTIVE"];
                return $status;
                break;
            }
            case "waybill_order": {
                $status = ["NEW"];
                return $status;
                break;
            }
            case "tender": {
                $status = ["ACTIVE"];
                return $status;
                break;
            }
            case "account": {
                $status = ["ACTIVE"];
                return $status;
                break;
            }
            case "pa": {
                $status = ["ACTIVE",'NEW'];
                return $status;
                break;
            }
          
        }
    }

    //----------------get the beneficiary accounts--------------------///
    public static function getBeneficiaryAccounts($tender_id){

        $param = [];
        $sql_query = "SELECT
        q.rank,
        q.tn,
        json_unquote(json_extract(t.financial_details,'$.payment_channel')) payment_channel,
        u.phone,
        a.name
    FROM
        queue_view q,
        tender_truck_view t,
        account_view a,
        user u
    WHERE
        q.tender_id = $tender_id
        and t.tender_id = q.tender_id
        and t.truck_id = q.truck_id
        and q.rank is not null
        and a.id = json_unquote(json_extract(t.financial_details,'$.waybill_beneficiary_account'))
        and a.user_id =  u.id
        order by q.rank;";

        $result = Reg_DBConnection::runBindDatabaseQuery($sql_query,$param);
        return $result;
    }

    // -------------------------------------------------------------------------------- //
        // ------------------ get user id for certain session ----------------------------- //
        // -------------------------------------------------------------------------------- //
        public static function getlateTrucks($tender_id){
            $sqlQuery = "  SELECT
            q.tn, a.activity_date , -1 * TIMESTAMPDIFF(HOUR, NOW(), a.activity_date) AS count
        FROM
            queue_view q,
            activity a
        WHERE
            q.tender_id = ?
                AND q.status = 'PENDING'
                AND a.queue_id = q.id
                AND a.action_code = 'CHANGE_STATUS'
                AND a.object_status_code = 'ACTIVE'
                AND a.object_new_status_code = 'PENDING'";

            $param = [$tender_id];
            $result = Reg_DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            return $result;
        }
}