<?php

class Poll_DBConnection
{

    protected static $db;
    private function __construct()
    {
        try {

            // connect to Poll Database
            $host = '34.134.70.8';
            $db   = 'waybill';
            $user = 'system';
            $pass = '35DcDw9M7B2nD3f';
            $charset = 'utf8mb4';
            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => true
            ];
            $dsn = "mysql:host=$host;port=3306;dbname=$db;charset=$charset";
            self::$db = new PDO($dsn, $user, $pass, $options);
        } catch (PDOException $e) {
            echo "Connection Error: " . $e->getMessage();
        }
    }

    // -------------------------------------------------------------------------------------------------------- //
    // ---------------------- Singelton method to make 1 DB instance for the whole application ---------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public static function getInstance()
    {
        if (!self::$db) {
            new Poll_DBConnection();
        }

        return self::$db;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------------- Destruct the DB instance ------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function __destruct()
    {
        $db = NULL;
    }


    private static function prepareSqlWhere($searchFilter, $tableName)
    {
        // prepare the searchFilter as convert it to string
        $searchFilter = (is_null($searchFilter) ? [] : $searchFilter);
        $searchFilter = (gettype($searchFilter) === 'array' ? json_decode(json_encode($searchFilter)) : json_decode($searchFilter));
        $searchQuery = '';

        foreach ($searchFilter as $i) {
            $op = (array_key_exists('op', $i) ? $i->op : '=');

            switch (strtolower($op)) {
                case "=":
                    $searchQuery .= " AND " . $i->key . " = '" . $i->val . "' ";
                    break;
                case "like":
                    if ($tableName == 'waybill' || $tableName == 'waybill_order') {
                        $searchQuery .= " AND MATCH (search_index) AGAINST ( '$i->val' IN BOOLEAN MODE)";
                    } else {
                        $searchQuery .= " AND " . $i->key . " like '%" . $i->val . "%' ";
                    }
                    break;
                case "in":
                    $searchQuery .= " AND " . $i->key . " in('" . implode("','", $i->val) . "') ";
                    break;
                case "not in":
                    $searchQuery .= " AND " . $i->key . " not in('" . implode("','", $i->val) . "') ";
                    break;
                case "json":
                    $searchQuery .= " AND JSON_CONTAINS(" . $i->key . ",'" . $i->val . "','" . $i->node . "')";
                    break;
                case "json unquote":
                    $searchQuery .= " AND JSON_UNQUOTE(JSON_EXTRACT(" . $i->key . ", '$i->node')) = " . $i->val;
                    break;
                case "json in":
                    $searchQuery .= " AND JSON_UNQUOTE(JSON_EXTRACT(" . $i->key . ",'" . $i->node . "')) in('" . implode("','", $i->val) . "') ";
                    break;
                case "is null":
                    $searchQuery .= " AND " . $i->key . " is null ";
                    break;
                case "is not null":
                    $searchQuery .= " AND " . $i->key . " is not null ";
                    break;
                case "greater than":
                    $searchQuery .= " AND " . $i->key . " >= " . "'" . $i->val . "'";
                    break;
                case "less than":
                    $searchQuery .= " AND " . $i->key . " <= " . "'" . $i->val . "'";
                    break;
                case "date greater than":
                    $searchQuery .= " AND " . $i->key . " >= " . "'" . $i->val . "'";
                    break;
                case "date less than": {
                        $parsed_date_arr = date_parse($i->val);
                        $filtered_date_arr = array_filter($parsed_date_arr);

                        if (!array_key_exists('hour', $filtered_date_arr))
                            $date_str = $i->val . ' 23:59:59';
                        else
                            $date_str = $i->val;

                        $searchQuery .= " AND " . $i->key . " < " . "'" . $date_str . "'";
                        break;
                    }
                case "startswith":
                    $searchQuery .= " AND " . $i->key . " like '" . $i->val . "%' ";
                    break;
            }
        }

        return $searchQuery;
    }


    // ------------------------------------------------------------------------------------- //
    // -------------------- Generate a random number from 19 digits ------------------------ //
    // ------------------------------------------------------------------------------------- //
    private static function random19()
    {
        $number = "";
        for ($i = 0; $i < 19; $i++) {
            $min = ($i == 0) ? 1 : 0;
            $number .= mt_rand($min, 9);
        }
        return $number;
    }

    // ------------------------------------------------------------------------------------ //
    // ------------------------- get the initial status for any object -------------------- //
    // ------------------------------------------------------------------------------------ //
    public static function get_init_Status($objectName)
    {

        $search_query = "call get_lookup('object','')";
        $stmt = self::$db->prepare($search_query);

        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        foreach ($result as $row) {
            if ($row['code'] == strtoupper($objectName)) {
                return $row['default_status'];
            }
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------------  Check if user has action ---------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public static function has_authority($userid, $object, $action, $currentStatus, $newStatus)
    {

        $search_query = "select has_authority('" . $userid . "','" . $object . "','" . $action . "','" . $currentStatus . "','" . $newStatus . "' ) as auth";
        $stmt = self::$db->prepare($search_query);

        $result = $stmt->execute();
        $result = $stmt->fetchAll();

        if (count($result) == 0) {
            throw new Exception("NO_AUTHORITY", 0);
            throw new Exception("NO_AUTHORITY", 0);
        }

        if ($result[0]['auth'] == 0) {
            throw new Exception("NO_AUTHORITY", 0);
            throw new Exception("NO_AUTHORITY", 0);
        }
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runDatabaseQuery($query)
    {
        $db_query = $query;

        $stmt = self::$db->prepare($db_query);
        $stmt->execute();
        $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $tempResult;
    }

    // ---------------------------------------------------------------------------- //
    // ------------------------  run database query ------------------------------- //
    // ---------------------------------------------------------------------------- //
    public static function runBindDatabaseQuery($query, $param)
    {

        $stmt = self::$db->prepare($query);
        $stmt->execute($param);
        try {
            $tempResult = $stmt->fetchAll(PDO::FETCH_OBJ);
            return $tempResult;
        } catch (Exception $e) {
        }
    }
}
